/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.metrics2.util;

import java.util.PriorityQueue;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.classification.InterfaceAudience;

@InterfaceAudience.Private
public class Metrics2Util {

    @InterfaceAudience.Private
    public static class TopN
    extends PriorityQueue<NameValuePair> {
        private static final long serialVersionUID = 5134028249611535803L;
        private int n;
        private long total = 0L;

        public TopN(int n) {
            super(n);
            this.n = n;
        }

        @Override
        public boolean offer(NameValuePair entry) {
            this.updateTotal(entry.value);
            if (this.size() == this.n) {
                NameValuePair smallest = (NameValuePair)this.peek();
                if (smallest.value >= entry.value) {
                    return false;
                }
                this.poll();
            }
            return super.offer(entry);
        }

        private void updateTotal(long value) {
            this.total += value;
        }

        public long getTotal() {
            return this.total;
        }
    }

    @InterfaceAudience.Private
    public static class NameValuePair
    implements Comparable<NameValuePair> {
        private String name;
        private long value;

        public NameValuePair(String metricName, long value) {
            this.name = metricName;
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        public long getValue() {
            return this.value;
        }

        @Override
        public int compareTo(NameValuePair other) {
            return (int)(this.value - other.value);
        }

        public boolean equals(Object other) {
            if (other instanceof NameValuePair) {
                return this.compareTo((NameValuePair)other) == 0;
            }
            return false;
        }

        public int hashCode() {
            return Long.valueOf(this.value).hashCode();
        }
    }
}

