/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.record.compiler;

import java.util.Map;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.classification.InterfaceAudience;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.classification.InterfaceStability;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.record.compiler.CodeBuffer;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.record.compiler.JCompType;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.record.compiler.JType;

@Deprecated
@InterfaceAudience.Public
@InterfaceStability.Stable
public class JVector
extends JCompType {
    private static int level = 0;
    private JType type;

    private static String getId(String id) {
        return id + JVector.getLevel();
    }

    private static String getLevel() {
        return Integer.toString(level);
    }

    private static void incrLevel() {
        ++level;
    }

    private static void decrLevel() {
        --level;
    }

    public JVector(JType t) {
        this.type = t;
        this.setJavaType(new JavaVector(t.getJavaType()));
        this.setCppType(new CppVector(t.getCppType()));
        this.setCType(new JCompType.CCompType());
    }

    @Override
    String getSignature() {
        return "[" + this.type.getSignature() + "]";
    }

    class CppVector
    extends JCompType.CppCompType {
        private JType.CppType element;

        CppVector(JType.CppType t) {
            super("::std::vector< " + t.getType() + " >");
            this.element = t;
        }

        @Override
        String getTypeIDObjectString() {
            return "new ::hadoop::VectorTypeID(" + this.element.getTypeIDObjectString() + ")";
        }

        @Override
        void genSetRTIFilter(CodeBuffer cb) {
            this.element.genSetRTIFilter(cb);
        }
    }

    class JavaVector
    extends JCompType.JavaCompType {
        private JType.JavaType element;

        JavaVector(JType.JavaType t) {
            super("java.util.ArrayList<" + t.getWrapperType() + ">", "Vector", "java.util.ArrayList<" + t.getWrapperType() + ">", "TypeID.RIOType.VECTOR");
            this.element = t;
        }

        @Override
        String getTypeIDObjectString() {
            return "new org.apache.hadoop.record.meta.VectorTypeID(" + this.element.getTypeIDObjectString() + ")";
        }

        @Override
        void genSetRTIFilter(CodeBuffer cb, Map<String, Integer> nestedStructMap) {
            this.element.genSetRTIFilter(cb, nestedStructMap);
        }

        @Override
        void genCompareTo(CodeBuffer cb, String fname, String other) {
            cb.append("{\n");
            JVector.incrLevel();
            cb.append("int " + JVector.getId("_rio_len1") + " = " + fname + ".size();\n");
            cb.append("int " + JVector.getId("_rio_len2") + " = " + other + ".size();\n");
            cb.append("for(int " + JVector.getId("_rio_vidx") + " = 0; " + JVector.getId("_rio_vidx") + "<" + JVector.getId("_rio_len1") + " && " + JVector.getId("_rio_vidx") + "<" + JVector.getId("_rio_len2") + "; " + JVector.getId("_rio_vidx") + "++) {\n");
            cb.append(this.element.getType() + " " + JVector.getId("_rio_e1") + " = " + fname + ".get(" + JVector.getId("_rio_vidx") + ");\n");
            cb.append(this.element.getType() + " " + JVector.getId("_rio_e2") + " = " + other + ".get(" + JVector.getId("_rio_vidx") + ");\n");
            this.element.genCompareTo(cb, JVector.getId("_rio_e1"), JVector.getId("_rio_e2"));
            cb.append("if (_rio_ret != 0) { return _rio_ret; }\n");
            cb.append("}\n");
            cb.append("_rio_ret = (" + JVector.getId("_rio_len1") + " - " + JVector.getId("_rio_len2") + ");\n");
            JVector.decrLevel();
            cb.append("}\n");
        }

        @Override
        void genReadMethod(CodeBuffer cb, String fname, String tag, boolean decl) {
            if (decl) {
                cb.append(this.getType() + " " + fname + ";\n");
            }
            cb.append("{\n");
            JVector.incrLevel();
            cb.append("org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.record.Index " + JVector.getId("_rio_vidx") + " = " + "_rio_a" + ".startVector(\"" + tag + "\");\n");
            cb.append(fname + "=new " + this.getType() + "();\n");
            cb.append("for (; !" + JVector.getId("_rio_vidx") + ".done(); " + JVector.getId("_rio_vidx") + ".incr()) {\n");
            this.element.genReadMethod(cb, JVector.getId("_rio_e"), JVector.getId("_rio_e"), true);
            cb.append(fname + ".add(" + JVector.getId("_rio_e") + ");\n");
            cb.append("}\n");
            cb.append("_rio_a.endVector(\"" + tag + "\");\n");
            JVector.decrLevel();
            cb.append("}\n");
        }

        @Override
        void genWriteMethod(CodeBuffer cb, String fname, String tag) {
            cb.append("{\n");
            JVector.incrLevel();
            cb.append("_rio_a.startVector(" + fname + ",\"" + tag + "\");\n");
            cb.append("int " + JVector.getId("_rio_len") + " = " + fname + ".size();\n");
            cb.append("for(int " + JVector.getId("_rio_vidx") + " = 0; " + JVector.getId("_rio_vidx") + "<" + JVector.getId("_rio_len") + "; " + JVector.getId("_rio_vidx") + "++) {\n");
            cb.append(this.element.getType() + " " + JVector.getId("_rio_e") + " = " + fname + ".get(" + JVector.getId("_rio_vidx") + ");\n");
            this.element.genWriteMethod(cb, JVector.getId("_rio_e"), JVector.getId("_rio_e"));
            cb.append("}\n");
            cb.append("_rio_a.endVector(" + fname + ",\"" + tag + "\");\n");
            cb.append("}\n");
            JVector.decrLevel();
        }

        @Override
        void genSlurpBytes(CodeBuffer cb, String b, String s, String l) {
            cb.append("{\n");
            JVector.incrLevel();
            cb.append("int " + JVector.getId("vi") + " = org.apache.hadoop.record.Utils.readVInt(" + b + ", " + s + ");\n");
            cb.append("int " + JVector.getId("vz") + " = org.apache.hadoop.record.Utils.getVIntSize(" + JVector.getId("vi") + ");\n");
            cb.append(s + "+=" + JVector.getId("vz") + "; " + l + "-=" + JVector.getId("vz") + ";\n");
            cb.append("for (int " + JVector.getId("vidx") + " = 0; " + JVector.getId("vidx") + " < " + JVector.getId("vi") + "; " + JVector.getId("vidx") + "++)");
            this.element.genSlurpBytes(cb, b, s, l);
            JVector.decrLevel();
            cb.append("}\n");
        }

        @Override
        void genCompareBytes(CodeBuffer cb) {
            cb.append("{\n");
            JVector.incrLevel();
            cb.append("int " + JVector.getId("vi1") + " = org.apache.hadoop.record.Utils.readVInt(b1, s1);\n");
            cb.append("int " + JVector.getId("vi2") + " = org.apache.hadoop.record.Utils.readVInt(b2, s2);\n");
            cb.append("int " + JVector.getId("vz1") + " = org.apache.hadoop.record.Utils.getVIntSize(" + JVector.getId("vi1") + ");\n");
            cb.append("int " + JVector.getId("vz2") + " = org.apache.hadoop.record.Utils.getVIntSize(" + JVector.getId("vi2") + ");\n");
            cb.append("s1+=" + JVector.getId("vz1") + "; s2+=" + JVector.getId("vz2") + "; l1-=" + JVector.getId("vz1") + "; l2-=" + JVector.getId("vz2") + ";\n");
            cb.append("for (int " + JVector.getId("vidx") + " = 0; " + JVector.getId("vidx") + " < " + JVector.getId("vi1") + " && " + JVector.getId("vidx") + " < " + JVector.getId("vi2") + "; " + JVector.getId("vidx") + "++)");
            this.element.genCompareBytes(cb);
            cb.append("if (" + JVector.getId("vi1") + " != " + JVector.getId("vi2") + ") { return (" + JVector.getId("vi1") + "<" + JVector.getId("vi2") + ")?-1:0; }\n");
            JVector.decrLevel();
            cb.append("}\n");
        }
    }
}

