/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.security;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.commons.logging.Log;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.commons.logging.LogFactory;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.classification.InterfaceAudience;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.classification.InterfaceStability;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.conf.Configurable;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.conf.Configuration;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.security.GroupMappingServiceProvider;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.util.ReflectionUtils;

@InterfaceAudience.LimitedPrivate(value={"HDFS", "MapReduce"})
@InterfaceStability.Evolving
public class CompositeGroupsMapping
implements GroupMappingServiceProvider,
Configurable {
    public static final String MAPPING_PROVIDERS_CONFIG_KEY = "hadoop.security.group.mapping.providers";
    public static final String MAPPING_PROVIDERS_COMBINED_CONFIG_KEY = "hadoop.security.group.mapping.providers.combined";
    public static final String MAPPING_PROVIDER_CONFIG_PREFIX = "hadoop.security.group.mapping.provider";
    private static final Log LOG = LogFactory.getLog(CompositeGroupsMapping.class);
    private List<GroupMappingServiceProvider> providersList = new ArrayList<GroupMappingServiceProvider>();
    private Configuration conf;
    private boolean combined;

    @Override
    public synchronized List<String> getGroups(String user) throws IOException {
        TreeSet<String> groupSet = new TreeSet<String>();
        List<String> groups = null;
        for (GroupMappingServiceProvider provider : this.providersList) {
            try {
                groups = provider.getGroups(user);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (groups == null || groups.isEmpty()) continue;
            groupSet.addAll(groups);
            if (this.combined) continue;
            break;
        }
        ArrayList<String> results = new ArrayList<String>(groupSet.size());
        results.addAll(groupSet);
        return results;
    }

    @Override
    public void cacheGroupsRefresh() throws IOException {
    }

    @Override
    public void cacheGroupsAdd(List<String> groups) throws IOException {
    }

    @Override
    public synchronized Configuration getConf() {
        return this.conf;
    }

    @Override
    public synchronized void setConf(Configuration conf) {
        this.conf = conf;
        this.combined = conf.getBoolean(MAPPING_PROVIDERS_COMBINED_CONFIG_KEY, true);
        this.loadMappingProviders();
    }

    private void loadMappingProviders() {
        String[] providerNames;
        for (String name : providerNames = this.conf.getStrings(MAPPING_PROVIDERS_CONFIG_KEY, new String[0])) {
            String providerKey = "hadoop.security.group.mapping.provider." + name;
            Class<?> providerClass = this.conf.getClass(providerKey, null);
            if (providerClass == null) {
                LOG.error("The mapping provider, " + name + " does not have a valid class");
                continue;
            }
            this.addMappingProvider(name, providerClass);
        }
    }

    private void addMappingProvider(String providerName, Class<?> providerClass) {
        Configuration newConf = this.prepareConf(providerName);
        GroupMappingServiceProvider provider = (GroupMappingServiceProvider)ReflectionUtils.newInstance(providerClass, newConf);
        this.providersList.add(provider);
    }

    private Configuration prepareConf(String providerName) {
        Configuration newConf = new Configuration();
        Iterator<Map.Entry<String, String>> entries = this.conf.iterator();
        String providerKey = "hadoop.security.group.mapping.provider." + providerName;
        while (entries.hasNext()) {
            Map.Entry<String, String> entry = entries.next();
            String key = entry.getKey();
            if (!key.startsWith(providerKey) || key.equals(providerKey)) continue;
            key = key.replace(".provider." + providerName, "");
            newConf.set(key, entry.getValue());
        }
        return newConf;
    }
}

