/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.security.alias;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.EnumSet;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.classification.InterfaceAudience;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.conf.Configuration;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.fs.FileUtil;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.fs.permission.FsPermission;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.security.alias.AbstractJavaKeyStoreProvider;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.security.alias.CredentialProvider;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.security.alias.CredentialProviderFactory;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.util.Shell;

@InterfaceAudience.Private
public final class LocalJavaKeyStoreProvider
extends AbstractJavaKeyStoreProvider {
    public static final String SCHEME_NAME = "localjceks";
    private File file;
    private Set<PosixFilePermission> permissions;

    private LocalJavaKeyStoreProvider(URI uri, Configuration conf) throws IOException {
        super(uri, conf);
    }

    @Override
    protected String getSchemeName() {
        return SCHEME_NAME;
    }

    @Override
    protected OutputStream getOutputStreamForKeystore() throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("using '" + this.file + "' for output stream.");
        }
        FileOutputStream out = new FileOutputStream(this.file);
        return out;
    }

    @Override
    protected boolean keystoreExists() throws IOException {
        return this.file.exists() && this.file.length() > 0L;
    }

    @Override
    protected InputStream getInputStreamForFile() throws IOException {
        FileInputStream is = new FileInputStream(this.file);
        return is;
    }

    @Override
    protected void createPermissions(String perms) throws IOException {
        int mode = 700;
        try {
            mode = Integer.parseInt(perms, 8);
        }
        catch (NumberFormatException nfe) {
            throw new IOException("Invalid permissions mode provided while trying to createPermissions", nfe);
        }
        this.permissions = LocalJavaKeyStoreProvider.modeToPosixFilePermission(mode);
    }

    @Override
    protected void stashOriginalFilePermissions() throws IOException {
        if (!Shell.WINDOWS) {
            Path path = Paths.get(this.file.getCanonicalPath(), new String[0]);
            this.permissions = Files.getPosixFilePermissions(path, new LinkOption[0]);
        } else {
            String[] cmd = Shell.getGetPermissionCommand();
            String[] args = new String[cmd.length + 1];
            System.arraycopy(cmd, 0, args, 0, cmd.length);
            args[cmd.length] = this.file.getCanonicalPath();
            String out = Shell.execCommand(args);
            StringTokenizer t = new StringTokenizer(out, Shell.TOKEN_SEPARATOR_REGEX);
            String permString = t.nextToken().substring(1);
            this.permissions = PosixFilePermissions.fromString(permString);
        }
    }

    @Override
    protected void initFileSystem(URI uri) throws IOException {
        super.initFileSystem(uri);
        try {
            this.file = new File(new URI(this.getPath().toString()));
            if (LOG.isDebugEnabled()) {
                LOG.debug("initialized local file as '" + this.file + "'.");
                if (this.file.exists()) {
                    LOG.debug("the local file exists and is size " + this.file.length());
                    if (LOG.isTraceEnabled()) {
                        if (this.file.canRead()) {
                            LOG.trace("we can read the local file.");
                        }
                        if (this.file.canWrite()) {
                            LOG.trace("we can write the local file.");
                        }
                    }
                } else {
                    LOG.debug("the local file does not exist.");
                }
            }
        }
        catch (URISyntaxException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void flush() throws IOException {
        super.flush();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Resetting permissions to '" + this.permissions + "'");
        }
        if (!Shell.WINDOWS) {
            Files.setPosixFilePermissions(Paths.get(this.file.getCanonicalPath(), new String[0]), this.permissions);
        } else {
            FsPermission fsPermission = FsPermission.valueOf("-" + PosixFilePermissions.toString(this.permissions));
            FileUtil.setPermission(this.file, fsPermission);
        }
    }

    private static Set<PosixFilePermission> modeToPosixFilePermission(int mode) {
        EnumSet<PosixFilePermission> perms = EnumSet.noneOf(PosixFilePermission.class);
        if ((mode & 1) != 0) {
            perms.add(PosixFilePermission.OTHERS_EXECUTE);
        }
        if ((mode & 2) != 0) {
            perms.add(PosixFilePermission.OTHERS_WRITE);
        }
        if ((mode & 4) != 0) {
            perms.add(PosixFilePermission.OTHERS_READ);
        }
        if ((mode & 8) != 0) {
            perms.add(PosixFilePermission.GROUP_EXECUTE);
        }
        if ((mode & 0x10) != 0) {
            perms.add(PosixFilePermission.GROUP_WRITE);
        }
        if ((mode & 0x20) != 0) {
            perms.add(PosixFilePermission.GROUP_READ);
        }
        if ((mode & 0x40) != 0) {
            perms.add(PosixFilePermission.OWNER_EXECUTE);
        }
        if ((mode & 0x80) != 0) {
            perms.add(PosixFilePermission.OWNER_WRITE);
        }
        if ((mode & 0x100) != 0) {
            perms.add(PosixFilePermission.OWNER_READ);
        }
        return perms;
    }

    public static class Factory
    extends CredentialProviderFactory {
        @Override
        public CredentialProvider createProvider(URI providerName, Configuration conf) throws IOException {
            if (LocalJavaKeyStoreProvider.SCHEME_NAME.equals(providerName.getScheme())) {
                return new LocalJavaKeyStoreProvider(providerName, conf);
            }
            return null;
        }
    }
}

