/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.util;

import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.flink.fs.s3hadoop.shaded.com.google.common.annotations.VisibleForTesting;

public class AutoCloseableLock
implements AutoCloseable {
    private final Lock lock;

    public AutoCloseableLock() {
        this(new ReentrantLock());
    }

    public AutoCloseableLock(Lock lock) {
        this.lock = lock;
    }

    public AutoCloseableLock acquire() {
        this.lock.lock();
        return this;
    }

    public void release() {
        this.lock.unlock();
    }

    @Override
    public void close() {
        this.release();
    }

    public boolean tryLock() {
        return this.lock.tryLock();
    }

    @VisibleForTesting
    boolean isLocked() {
        if (this.lock instanceof ReentrantLock) {
            return ((ReentrantLock)this.lock).isLocked();
        }
        throw new UnsupportedOperationException();
    }

    public Condition newCondition() {
        return this.lock.newCondition();
    }
}

