/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.util;

import java.util.Comparator;
import java.util.Iterator;
import java.util.PriorityQueue;
import org.apache.flink.fs.s3hadoop.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.flink.fs.s3hadoop.shaded.com.google.common.base.Preconditions;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.HadoopIllegalArgumentException;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.classification.InterfaceAudience;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.util.LightWeightGSet;

@InterfaceAudience.Private
public class LightWeightCache<K, E extends K>
extends LightWeightGSet<K, E> {
    private static final int EVICTION_LIMIT = 65536;
    private static final Comparator<Entry> expirationTimeComparator = new Comparator<Entry>(){

        @Override
        public int compare(Entry left, Entry right) {
            long r;
            long l = left.getExpirationTime();
            return l > (r = right.getExpirationTime()) ? 1 : (l < r ? -1 : 0);
        }
    };
    private final PriorityQueue<Entry> queue;
    private final long creationExpirationPeriod;
    private final long accessExpirationPeriod;
    private final int sizeLimit;
    private final Clock clock;

    private static int updateRecommendedLength(int recommendedLength, int sizeLimit) {
        return sizeLimit > 0 && sizeLimit < recommendedLength ? sizeLimit / 4 * 3 : recommendedLength;
    }

    public LightWeightCache(int recommendedLength, int sizeLimit, long creationExpirationPeriod, long accessExpirationPeriod) {
        this(recommendedLength, sizeLimit, creationExpirationPeriod, accessExpirationPeriod, new Clock());
    }

    @VisibleForTesting
    LightWeightCache(int recommendedLength, int sizeLimit, long creationExpirationPeriod, long accessExpirationPeriod, Clock clock) {
        super(LightWeightCache.updateRecommendedLength(recommendedLength, sizeLimit));
        this.sizeLimit = sizeLimit;
        if (creationExpirationPeriod <= 0L) {
            throw new IllegalArgumentException("creationExpirationPeriod = " + creationExpirationPeriod + " <= 0");
        }
        this.creationExpirationPeriod = creationExpirationPeriod;
        if (accessExpirationPeriod < 0L) {
            throw new IllegalArgumentException("accessExpirationPeriod = " + accessExpirationPeriod + " < 0");
        }
        this.accessExpirationPeriod = accessExpirationPeriod;
        this.queue = new PriorityQueue<Entry>(sizeLimit > 0 ? sizeLimit + 1 : 1024, expirationTimeComparator);
        this.clock = clock;
    }

    void setExpirationTime(Entry e, long expirationPeriod) {
        e.setExpirationTime(this.clock.currentTime() + expirationPeriod);
    }

    boolean isExpired(Entry e, long now) {
        return now > e.getExpirationTime();
    }

    private E evict() {
        Entry polled = this.queue.poll();
        Object removed = super.remove(polled);
        Preconditions.checkState(removed == polled);
        return (E)polled;
    }

    private void evictExpiredEntries() {
        long now = this.clock.currentTime();
        for (int i = 0; i < 65536; ++i) {
            Entry peeked = this.queue.peek();
            if (peeked == null || !this.isExpired(peeked, now)) {
                return;
            }
            E evicted = this.evict();
            Preconditions.checkState(evicted == peeked);
        }
    }

    private void evictEntries() {
        if (this.sizeLimit > 0) {
            for (int i = this.size(); i > this.sizeLimit; --i) {
                this.evict();
            }
        }
    }

    @Override
    public E get(K key) {
        Object entry = super.get(key);
        if (entry != null && this.accessExpirationPeriod > 0L) {
            Entry existing = (Entry)entry;
            Preconditions.checkState(this.queue.remove(existing));
            this.setExpirationTime(existing, this.accessExpirationPeriod);
            this.queue.offer(existing);
        }
        return entry;
    }

    @Override
    public E put(E entry) {
        if (!(entry instanceof Entry)) {
            throw new HadoopIllegalArgumentException("!(entry instanceof Entry), entry.getClass()=" + entry.getClass());
        }
        this.evictExpiredEntries();
        E existing = super.put(entry);
        if (existing != null) {
            this.queue.remove(existing);
        }
        Entry e = (Entry)entry;
        this.setExpirationTime(e, this.creationExpirationPeriod);
        this.queue.offer(e);
        this.evictEntries();
        return existing;
    }

    @Override
    public E remove(K key) {
        this.evictExpiredEntries();
        Object removed = super.remove(key);
        if (removed != null) {
            Preconditions.checkState(this.queue.remove(removed));
        }
        return removed;
    }

    @Override
    public Iterator<E> iterator() {
        final Iterator iter = super.iterator();
        return new Iterator<E>(){

            @Override
            public boolean hasNext() {
                return iter.hasNext();
            }

            @Override
            public E next() {
                return iter.next();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Remove via iterator is not supported for LightWeightCache");
            }
        };
    }

    static class Clock {
        Clock() {
        }

        long currentTime() {
            return System.nanoTime();
        }
    }

    public static interface Entry
    extends LightWeightGSet.LinkedElement {
        public void setExpirationTime(long var1);

        public long getExpirationTime();
    }
}

