/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.s3hadoop.shaded.org.tukaani.xz.check;

import org.apache.flink.fs.s3hadoop.shaded.org.tukaani.xz.check.Check;

public class CRC64
extends Check {
    private static final long poly = -3932672073523589310L;
    private static final long[] crcTable = new long[256];
    private long crc = -1L;

    public CRC64() {
        this.size = 8;
        this.name = "CRC64";
    }

    public void update(byte[] byArray, int n, int n2) {
        int n3 = n + n2;
        while (n < n3) {
            this.crc = crcTable[(byArray[n++] ^ (int)this.crc) & 0xFF] ^ this.crc >>> 8;
        }
    }

    public byte[] finish() {
        long l = this.crc ^ 0xFFFFFFFFFFFFFFFFL;
        this.crc = -1L;
        byte[] byArray = new byte[8];
        for (int i = 0; i < byArray.length; ++i) {
            byArray[i] = (byte)(l >> i * 8);
        }
        return byArray;
    }

    static {
        for (int i = 0; i < crcTable.length; ++i) {
            long l = i;
            for (int j = 0; j < 8; ++j) {
                if ((l & 1L) == 1L) {
                    l = l >>> 1 ^ 0xC96C5795D7870F42L;
                    continue;
                }
                l >>>= 1;
            }
            CRC64.crcTable[i] = l;
        }
    }
}

