/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.s3base.shaded.com.amazonaws.jmespath;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.flink.fs.s3base.shaded.com.amazonaws.jmespath.InvalidTypeException;
import org.apache.flink.fs.s3base.shaded.com.amazonaws.jmespath.JmesPathExpression;
import org.apache.flink.fs.s3base.shaded.com.amazonaws.jmespath.JmesPathFunction;
import org.apache.flink.fs.s3base.shaded.com.fasterxml.jackson.databind.JsonNode;
import org.apache.flink.fs.s3base.shaded.com.fasterxml.jackson.databind.node.BooleanNode;

public class JmesPathContainsFunction
extends JmesPathFunction {
    public JmesPathContainsFunction(JmesPathExpression ... expressions) {
        this(Arrays.asList(expressions));
    }

    public JmesPathContainsFunction(List<JmesPathExpression> expressions) {
        super(expressions);
    }

    @Override
    public JsonNode evaluate(List<JsonNode> evaluatedArgs) {
        JsonNode subject = evaluatedArgs.get(0);
        JsonNode search = evaluatedArgs.get(1);
        if (subject.isArray()) {
            return JmesPathContainsFunction.doesArrayContain(subject, search);
        }
        if (subject.isTextual()) {
            return JmesPathContainsFunction.doesStringContain(subject, search);
        }
        throw new InvalidTypeException("Type mismatch. Expecting a string or an array.");
    }

    private static BooleanNode doesArrayContain(JsonNode subject, JsonNode search) {
        Iterator<JsonNode> elements = subject.elements();
        while (elements.hasNext()) {
            if (!elements.next().equals(search)) continue;
            return BooleanNode.TRUE;
        }
        return BooleanNode.FALSE;
    }

    private static BooleanNode doesStringContain(JsonNode subject, JsonNode search) {
        if (subject.asText().contains(search.asText())) {
            return BooleanNode.TRUE;
        }
        return BooleanNode.FALSE;
    }
}

