/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.s3base.shaded.com.amazonaws.services.dynamodbv2.model.transform;

import java.util.Map;
import org.apache.flink.fs.s3base.shaded.com.amazonaws.SdkClientException;
import org.apache.flink.fs.s3base.shaded.com.amazonaws.annotation.SdkInternalApi;
import org.apache.flink.fs.s3base.shaded.com.amazonaws.protocol.MarshallLocation;
import org.apache.flink.fs.s3base.shaded.com.amazonaws.protocol.MarshallingInfo;
import org.apache.flink.fs.s3base.shaded.com.amazonaws.protocol.MarshallingType;
import org.apache.flink.fs.s3base.shaded.com.amazonaws.protocol.ProtocolMarshaller;
import org.apache.flink.fs.s3base.shaded.com.amazonaws.protocol.StructuredPojo;
import org.apache.flink.fs.s3base.shaded.com.amazonaws.services.dynamodbv2.model.ConsumedCapacity;

@SdkInternalApi
public class ConsumedCapacityMarshaller {
    private static final MarshallingInfo<String> TABLENAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TableName").build();
    private static final MarshallingInfo<Double> CAPACITYUNITS_BINDING = MarshallingInfo.builder(MarshallingType.DOUBLE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CapacityUnits").build();
    private static final MarshallingInfo<StructuredPojo> TABLE_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Table").build();
    private static final MarshallingInfo<Map> LOCALSECONDARYINDEXES_BINDING = MarshallingInfo.builder(MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LocalSecondaryIndexes").build();
    private static final MarshallingInfo<Map> GLOBALSECONDARYINDEXES_BINDING = MarshallingInfo.builder(MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("GlobalSecondaryIndexes").build();
    private static final ConsumedCapacityMarshaller instance = new ConsumedCapacityMarshaller();

    public static ConsumedCapacityMarshaller getInstance() {
        return instance;
    }

    public void marshall(ConsumedCapacity consumedCapacity, ProtocolMarshaller protocolMarshaller) {
        if (consumedCapacity == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(consumedCapacity.getTableName(), TABLENAME_BINDING);
            protocolMarshaller.marshall(consumedCapacity.getCapacityUnits(), CAPACITYUNITS_BINDING);
            protocolMarshaller.marshall(consumedCapacity.getTable(), TABLE_BINDING);
            protocolMarshaller.marshall(consumedCapacity.getLocalSecondaryIndexes(), LOCALSECONDARYINDEXES_BINDING);
            protocolMarshaller.marshall(consumedCapacity.getGlobalSecondaryIndexes(), GLOBALSECONDARYINDEXES_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

