/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.s3base.shaded.com.amazonaws.services.s3.transfer.internal;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.flink.fs.s3base.shaded.com.amazonaws.SdkClientException;
import org.apache.flink.fs.s3base.shaded.com.amazonaws.event.ProgressEventType;
import org.apache.flink.fs.s3base.shaded.com.amazonaws.event.ProgressListenerChain;
import org.apache.flink.fs.s3base.shaded.com.amazonaws.event.SDKProgressPublisher;
import org.apache.flink.fs.s3base.shaded.com.amazonaws.services.s3.AmazonS3;
import org.apache.flink.fs.s3base.shaded.com.amazonaws.services.s3.model.CopyObjectRequest;
import org.apache.flink.fs.s3base.shaded.com.amazonaws.services.s3.model.PartETag;
import org.apache.flink.fs.s3base.shaded.com.amazonaws.services.s3.transfer.Transfer;
import org.apache.flink.fs.s3base.shaded.com.amazonaws.services.s3.transfer.TransferManager;
import org.apache.flink.fs.s3base.shaded.com.amazonaws.services.s3.transfer.internal.CompleteMultipartCopy;
import org.apache.flink.fs.s3base.shaded.com.amazonaws.services.s3.transfer.internal.CopyCallable;
import org.apache.flink.fs.s3base.shaded.com.amazonaws.services.s3.transfer.internal.CopyImpl;
import org.apache.flink.fs.s3base.shaded.com.amazonaws.services.s3.transfer.internal.TransferMonitor;
import org.apache.flink.fs.s3base.shaded.com.amazonaws.services.s3.transfer.model.CopyResult;

public class CopyMonitor
implements Callable<CopyResult>,
TransferMonitor {
    private final AmazonS3 s3;
    private final ExecutorService threadPool;
    private final CopyObjectRequest origReq;
    private final CopyCallable multipartCopyCallable;
    private final CopyImpl transfer;
    private final ProgressListenerChain listener;
    private final List<Future<PartETag>> futures = new ArrayList<Future<PartETag>>();
    private boolean isCopyDone = false;
    private AtomicReference<Future<CopyResult>> futureReference = new AtomicReference<Object>(null);

    public Future<CopyResult> getFuture() {
        return this.futureReference.get();
    }

    @Override
    public synchronized boolean isDone() {
        return this.isCopyDone;
    }

    private synchronized void markAllDone() {
        this.isCopyDone = true;
    }

    public static CopyMonitor create(TransferManager manager, CopyImpl transfer, ExecutorService threadPool, CopyCallable multipartCopyCallable, CopyObjectRequest copyObjectRequest, ProgressListenerChain progressListenerChain) {
        CopyMonitor copyMonitor = new CopyMonitor(manager, transfer, threadPool, multipartCopyCallable, copyObjectRequest, progressListenerChain);
        Future<CopyResult> thisFuture = threadPool.submit(copyMonitor);
        copyMonitor.futureReference.compareAndSet(null, thisFuture);
        return copyMonitor;
    }

    private CopyMonitor(TransferManager manager, CopyImpl transfer, ExecutorService threadPool, CopyCallable multipartCopyCallable, CopyObjectRequest copyObjectRequest, ProgressListenerChain progressListenerChain) {
        this.s3 = manager.getAmazonS3Client();
        this.multipartCopyCallable = multipartCopyCallable;
        this.origReq = copyObjectRequest;
        this.listener = progressListenerChain;
        this.transfer = transfer;
        this.threadPool = threadPool;
    }

    @Override
    public CopyResult call() throws Exception {
        try {
            CopyResult result = this.multipartCopyCallable.call();
            if (result == null) {
                this.futures.addAll(this.multipartCopyCallable.getFutures());
                this.futureReference.set(this.threadPool.submit(new CompleteMultipartCopy(this.multipartCopyCallable.getMultipartUploadId(), this.s3, this.origReq, this.futures, this.listener, this)));
            } else {
                this.copyComplete();
            }
            return result;
        }
        catch (CancellationException e) {
            this.transfer.setState(Transfer.TransferState.Canceled);
            SDKProgressPublisher.publishProgress(this.listener, ProgressEventType.TRANSFER_CANCELED_EVENT);
            throw new SdkClientException("Upload canceled");
        }
        catch (Exception e) {
            this.transfer.setState(Transfer.TransferState.Failed);
            SDKProgressPublisher.publishProgress(this.listener, ProgressEventType.TRANSFER_FAILED_EVENT);
            throw e;
        }
    }

    void copyComplete() {
        this.markAllDone();
        this.transfer.setState(Transfer.TransferState.Completed);
        if (this.multipartCopyCallable.isMultipartCopy()) {
            SDKProgressPublisher.publishProgress(this.listener, ProgressEventType.TRANSFER_COMPLETED_EVENT);
        }
    }
}

