/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.s3hadoop;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.flink.fs.s3.common.writer.S3MultiPartUploader;
import org.apache.flink.fs.s3base.shaded.com.amazonaws.SdkBaseException;
import org.apache.flink.fs.s3base.shaded.com.amazonaws.services.s3.model.CompleteMultipartUploadResult;
import org.apache.flink.fs.s3base.shaded.com.amazonaws.services.s3.model.ObjectMetadata;
import org.apache.flink.fs.s3base.shaded.com.amazonaws.services.s3.model.PartETag;
import org.apache.flink.fs.s3base.shaded.com.amazonaws.services.s3.model.PutObjectRequest;
import org.apache.flink.fs.s3base.shaded.com.amazonaws.services.s3.model.PutObjectResult;
import org.apache.flink.fs.s3base.shaded.com.amazonaws.services.s3.model.UploadPartRequest;
import org.apache.flink.fs.s3base.shaded.com.amazonaws.services.s3.model.UploadPartResult;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.conf.Configuration;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.Path;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.s3a.S3AFileSystem;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.s3a.S3AUtils;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.s3a.WriteOperationHelper;
import org.apache.flink.util.MathUtils;
import org.apache.flink.util.Preconditions;

public class HadoopS3MultiPartUploader
implements S3MultiPartUploader {
    private final S3AFileSystem s3a;
    private final InternalWriteOperationHelper s3uploader;

    public HadoopS3MultiPartUploader(S3AFileSystem s3a, Configuration conf) {
        this.s3uploader = new InternalWriteOperationHelper((S3AFileSystem)Preconditions.checkNotNull((Object)s3a), (Configuration)Preconditions.checkNotNull((Object)conf));
        this.s3a = s3a;
    }

    @Override
    public String startMultiPartUpload(String key) throws IOException {
        return this.s3uploader.initiateMultiPartUpload(key);
    }

    @Override
    public UploadPartResult uploadPart(String key, String uploadId, int partNumber, InputStream inputStream, long length) throws IOException {
        UploadPartRequest uploadRequest = this.s3uploader.newUploadPartRequest(key, uploadId, partNumber, MathUtils.checkedDownCast((long)length), inputStream, null, 0L);
        return this.s3uploader.uploadPart(uploadRequest);
    }

    @Override
    public PutObjectResult uploadIncompletePart(String key, InputStream inputStream, long length) throws IOException {
        PutObjectRequest putRequest = this.s3uploader.createPutObjectRequest(key, inputStream, length);
        return this.s3uploader.putObject(putRequest);
    }

    @Override
    public CompleteMultipartUploadResult commitMultiPartUpload(String destKey, String uploadId, List<PartETag> partETags, long length, AtomicInteger errorCount) throws IOException {
        return this.s3uploader.completeMPUwithRetries(destKey, uploadId, partETags, length, errorCount);
    }

    @Override
    public ObjectMetadata getObjectMetadata(String key) throws IOException {
        try {
            return this.s3a.getObjectMetadata(new Path('/' + key));
        }
        catch (SdkBaseException e) {
            throw S3AUtils.translateException("getObjectMetadata", key, e);
        }
    }

    private static final class InternalWriteOperationHelper
    extends WriteOperationHelper {
        InternalWriteOperationHelper(S3AFileSystem owner, Configuration conf) {
            super(owner, conf);
        }
    }
}

