/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.s3a;

import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.flink.fs.s3base.shaded.com.amazonaws.AmazonClientException;
import org.apache.flink.fs.s3base.shaded.com.amazonaws.auth.AWSCredentials;
import org.apache.flink.fs.s3base.shaded.com.amazonaws.auth.AWSCredentialsProvider;
import org.apache.flink.fs.s3base.shaded.com.amazonaws.auth.AnonymousAWSCredentials;
import org.apache.flink.fs.s3base.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.flink.fs.shaded.hadoop3.org.apache.commons.lang.StringUtils;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.classification.InterfaceAudience;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.classification.InterfaceStability;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class AWSCredentialProviderList
implements AWSCredentialsProvider,
AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(AWSCredentialProviderList.class);
    public static final String NO_AWS_CREDENTIAL_PROVIDERS = "No AWS Credential Providers";
    private final List<AWSCredentialsProvider> providers = new ArrayList<AWSCredentialsProvider>(1);
    private boolean reuseLastProvider = true;
    private AWSCredentialsProvider lastProvider;

    public AWSCredentialProviderList() {
    }

    public AWSCredentialProviderList(Collection<AWSCredentialsProvider> providers) {
        this.providers.addAll(providers);
    }

    public void add(AWSCredentialsProvider p) {
        this.providers.add(p);
    }

    @Override
    public void refresh() {
        for (AWSCredentialsProvider provider : this.providers) {
            provider.refresh();
        }
    }

    @Override
    public AWSCredentials getCredentials() {
        this.checkNotEmpty();
        if (this.reuseLastProvider && this.lastProvider != null) {
            return this.lastProvider.getCredentials();
        }
        AmazonClientException lastException = null;
        for (AWSCredentialsProvider provider : this.providers) {
            try {
                AWSCredentials credentials = provider.getCredentials();
                if ((credentials.getAWSAccessKeyId() == null || credentials.getAWSSecretKey() == null) && !(credentials instanceof AnonymousAWSCredentials)) continue;
                this.lastProvider = provider;
                LOG.debug("Using credentials from {}", (Object)provider);
                return credentials;
            }
            catch (AmazonClientException e) {
                lastException = e;
                LOG.debug("No credentials provided by {}: {}", new Object[]{provider, e.toString(), e});
            }
        }
        String message = "No AWS Credentials provided by " + this.listProviderNames();
        if (lastException != null) {
            message = message + ": " + lastException;
        }
        throw new AmazonClientException(message, lastException);
    }

    @VisibleForTesting
    List<AWSCredentialsProvider> getProviders() {
        return this.providers;
    }

    public void checkNotEmpty() {
        if (this.providers.isEmpty()) {
            throw new AmazonClientException(NO_AWS_CREDENTIAL_PROVIDERS);
        }
    }

    public String listProviderNames() {
        return this.providers.stream().map(provider -> provider.getClass().getSimpleName() + ' ').collect(Collectors.joining());
    }

    public String toString() {
        return "AWSCredentialProviderList: " + StringUtils.join(this.providers, " ");
    }

    @Override
    public void close() {
        for (AWSCredentialsProvider p : this.providers) {
            if (!(p instanceof Closeable)) continue;
            IOUtils.closeStream((Closeable)((Object)p));
        }
    }
}

