/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.s3a.commit.staging;

import java.io.IOException;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import org.apache.flink.fs.s3base.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.flink.fs.s3base.shaded.com.google.common.base.Preconditions;
import org.apache.flink.fs.s3base.shaded.com.google.common.cache.Cache;
import org.apache.flink.fs.s3base.shaded.com.google.common.cache.CacheBuilder;
import org.apache.flink.fs.s3base.shaded.com.google.common.collect.Sets;
import org.apache.flink.fs.s3base.shaded.com.google.common.util.concurrent.UncheckedExecutionException;
import org.apache.flink.fs.shaded.hadoop3.org.apache.commons.lang.StringUtils;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.conf.Configuration;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.FileStatus;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.FileSystem;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.LocalDirAllocator;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.Path;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.PathIsDirectoryException;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.security.UserGroupInformation;

public final class Paths {
    private static Cache<TaskAttemptID, Path> tempFolders = CacheBuilder.newBuilder().build();

    private Paths() {
    }

    public static String addUUID(String pathStr, String uuid) {
        int dot;
        Preconditions.checkArgument(StringUtils.isNotEmpty(pathStr), "empty path");
        Preconditions.checkArgument(StringUtils.isNotEmpty(uuid), "empty uuid");
        if (pathStr.contains(uuid)) {
            return pathStr;
        }
        int lastSlash = pathStr.lastIndexOf(47);
        if (lastSlash >= 0) {
            Preconditions.checkState(lastSlash + 1 < pathStr.length(), "Bad path: " + pathStr);
            dot = pathStr.indexOf(46, lastSlash);
        } else {
            dot = pathStr.indexOf(46);
        }
        if (dot >= 0) {
            return pathStr.substring(0, dot) + "-" + uuid + pathStr.substring(dot);
        }
        return pathStr + "-" + uuid;
    }

    public static String getParent(String pathStr) {
        int lastSlash = pathStr.lastIndexOf(47);
        if (lastSlash >= 0) {
            return pathStr.substring(0, lastSlash);
        }
        return null;
    }

    public static String getRelativePath(Path basePath, Path fullPath) {
        return basePath.toUri().relativize(fullPath.toUri()).getPath();
    }

    public static Path path(Path parent, String ... child) {
        Path p = parent;
        for (String c : child) {
            if (c.isEmpty()) continue;
            p = new Path(p, c);
        }
        return p;
    }

    public static Path getLocalTaskAttemptTempDir(Configuration conf, String uuid, TaskAttemptID attemptID) throws IOException {
        try {
            LocalDirAllocator allocator = new LocalDirAllocator("fs.s3a.buffer.dir");
            return tempFolders.get(attemptID, () -> FileSystem.getLocal(conf).makeQualified(allocator.getLocalPathForWrite(uuid, conf)));
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e.getCause());
        }
        catch (UncheckedExecutionException e) {
            if (e.getCause() instanceof RuntimeException) {
                throw (RuntimeException)e.getCause();
            }
            throw new RuntimeException(e);
        }
    }

    public static void clearTempFolderInfo(TaskAttemptID attemptID) {
        tempFolders.invalidate(attemptID);
    }

    @VisibleForTesting
    public static void resetTempFolderCache() {
        tempFolders.invalidateAll();
    }

    public static Path tempDirForStaging(FileSystem fs, Configuration conf) {
        String fallbackPath = fs.getScheme().equals("file") ? System.getProperty("java.io.tmpdir") : "tmp/staging";
        return fs.makeQualified(new Path(conf.getTrimmed("fs.s3a.committer.staging.tmp.path", fallbackPath)));
    }

    private static int getAppAttemptId(Configuration conf) {
        return conf.getInt("mapreduce.job.application.attempt.id", 0);
    }

    public static Path getMultipartUploadCommitsDirectory(Configuration conf, String uuid) throws IOException {
        return Paths.getMultipartUploadCommitsDirectory(FileSystem.get(conf), conf, uuid);
    }

    @VisibleForTesting
    static Path getMultipartUploadCommitsDirectory(FileSystem fs, Configuration conf, String uuid) throws IOException {
        return Paths.path(Paths.tempDirForStaging(fs, conf), UserGroupInformation.getCurrentUser().getShortUserName(), uuid, "staging-uploads");
    }

    protected static String getPartition(String relative) {
        return Paths.getParent(relative);
    }

    public static Set<String> getPartitions(Path attemptPath, List<? extends FileStatus> taskOutput) throws IOException {
        LinkedHashSet<String> partitions = Sets.newLinkedHashSet();
        for (FileStatus fileStatus : taskOutput) {
            Path outputFile = fileStatus.getPath();
            if (!fileStatus.isFile()) {
                throw new PathIsDirectoryException(outputFile.toString());
            }
            String partition = Paths.getPartition(Paths.getRelativePath(attemptPath, outputFile));
            partitions.add(partition != null ? partition : "table_root");
        }
        return partitions;
    }
}

