/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.s3base.shaded.com.amazonaws.services.dynamodbv2.model;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.apache.flink.fs.s3base.shaded.com.amazonaws.AmazonWebServiceRequest;
import org.apache.flink.fs.s3base.shaded.com.amazonaws.services.dynamodbv2.model.AttributeValue;
import org.apache.flink.fs.s3base.shaded.com.amazonaws.services.dynamodbv2.model.ConditionalOperator;
import org.apache.flink.fs.s3base.shaded.com.amazonaws.services.dynamodbv2.model.ExpectedAttributeValue;
import org.apache.flink.fs.s3base.shaded.com.amazonaws.services.dynamodbv2.model.ReturnConsumedCapacity;
import org.apache.flink.fs.s3base.shaded.com.amazonaws.services.dynamodbv2.model.ReturnItemCollectionMetrics;
import org.apache.flink.fs.s3base.shaded.com.amazonaws.services.dynamodbv2.model.ReturnValue;

public class DeleteItemRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String tableName;
    private Map<String, AttributeValue> key;
    private Map<String, ExpectedAttributeValue> expected;
    private String conditionalOperator;
    private String returnValues;
    private String returnConsumedCapacity;
    private String returnItemCollectionMetrics;
    private String conditionExpression;
    private Map<String, String> expressionAttributeNames;
    private Map<String, AttributeValue> expressionAttributeValues;

    public DeleteItemRequest() {
    }

    public DeleteItemRequest(String tableName, Map<String, AttributeValue> key) {
        this.setTableName(tableName);
        this.setKey(key);
    }

    public DeleteItemRequest(String tableName, Map<String, AttributeValue> key, String returnValues) {
        this.setTableName(tableName);
        this.setKey(key);
        this.setReturnValues(returnValues);
    }

    public DeleteItemRequest(String tableName, Map<String, AttributeValue> key, ReturnValue returnValues) {
        this.setTableName(tableName);
        this.setKey(key);
        this.setReturnValues(returnValues.toString());
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public DeleteItemRequest withTableName(String tableName) {
        this.setTableName(tableName);
        return this;
    }

    public Map<String, AttributeValue> getKey() {
        return this.key;
    }

    public void setKey(Map<String, AttributeValue> key) {
        this.key = key;
    }

    public DeleteItemRequest withKey(Map<String, AttributeValue> key) {
        this.setKey(key);
        return this;
    }

    public DeleteItemRequest addKeyEntry(String key, AttributeValue value) {
        if (null == this.key) {
            this.key = new HashMap<String, AttributeValue>();
        }
        if (this.key.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.key.put(key, value);
        return this;
    }

    public DeleteItemRequest clearKeyEntries() {
        this.key = null;
        return this;
    }

    public Map<String, ExpectedAttributeValue> getExpected() {
        return this.expected;
    }

    public void setExpected(Map<String, ExpectedAttributeValue> expected) {
        this.expected = expected;
    }

    public DeleteItemRequest withExpected(Map<String, ExpectedAttributeValue> expected) {
        this.setExpected(expected);
        return this;
    }

    public DeleteItemRequest addExpectedEntry(String key, ExpectedAttributeValue value) {
        if (null == this.expected) {
            this.expected = new HashMap<String, ExpectedAttributeValue>();
        }
        if (this.expected.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.expected.put(key, value);
        return this;
    }

    public DeleteItemRequest clearExpectedEntries() {
        this.expected = null;
        return this;
    }

    public void setConditionalOperator(String conditionalOperator) {
        this.conditionalOperator = conditionalOperator;
    }

    public String getConditionalOperator() {
        return this.conditionalOperator;
    }

    public DeleteItemRequest withConditionalOperator(String conditionalOperator) {
        this.setConditionalOperator(conditionalOperator);
        return this;
    }

    public void setConditionalOperator(ConditionalOperator conditionalOperator) {
        this.withConditionalOperator(conditionalOperator);
    }

    public DeleteItemRequest withConditionalOperator(ConditionalOperator conditionalOperator) {
        this.conditionalOperator = conditionalOperator.toString();
        return this;
    }

    public void setReturnValues(String returnValues) {
        this.returnValues = returnValues;
    }

    public String getReturnValues() {
        return this.returnValues;
    }

    public DeleteItemRequest withReturnValues(String returnValues) {
        this.setReturnValues(returnValues);
        return this;
    }

    public void setReturnValues(ReturnValue returnValues) {
        this.withReturnValues(returnValues);
    }

    public DeleteItemRequest withReturnValues(ReturnValue returnValues) {
        this.returnValues = returnValues.toString();
        return this;
    }

    public void setReturnConsumedCapacity(String returnConsumedCapacity) {
        this.returnConsumedCapacity = returnConsumedCapacity;
    }

    public String getReturnConsumedCapacity() {
        return this.returnConsumedCapacity;
    }

    public DeleteItemRequest withReturnConsumedCapacity(String returnConsumedCapacity) {
        this.setReturnConsumedCapacity(returnConsumedCapacity);
        return this;
    }

    public void setReturnConsumedCapacity(ReturnConsumedCapacity returnConsumedCapacity) {
        this.withReturnConsumedCapacity(returnConsumedCapacity);
    }

    public DeleteItemRequest withReturnConsumedCapacity(ReturnConsumedCapacity returnConsumedCapacity) {
        this.returnConsumedCapacity = returnConsumedCapacity.toString();
        return this;
    }

    public void setReturnItemCollectionMetrics(String returnItemCollectionMetrics) {
        this.returnItemCollectionMetrics = returnItemCollectionMetrics;
    }

    public String getReturnItemCollectionMetrics() {
        return this.returnItemCollectionMetrics;
    }

    public DeleteItemRequest withReturnItemCollectionMetrics(String returnItemCollectionMetrics) {
        this.setReturnItemCollectionMetrics(returnItemCollectionMetrics);
        return this;
    }

    public void setReturnItemCollectionMetrics(ReturnItemCollectionMetrics returnItemCollectionMetrics) {
        this.withReturnItemCollectionMetrics(returnItemCollectionMetrics);
    }

    public DeleteItemRequest withReturnItemCollectionMetrics(ReturnItemCollectionMetrics returnItemCollectionMetrics) {
        this.returnItemCollectionMetrics = returnItemCollectionMetrics.toString();
        return this;
    }

    public void setConditionExpression(String conditionExpression) {
        this.conditionExpression = conditionExpression;
    }

    public String getConditionExpression() {
        return this.conditionExpression;
    }

    public DeleteItemRequest withConditionExpression(String conditionExpression) {
        this.setConditionExpression(conditionExpression);
        return this;
    }

    public Map<String, String> getExpressionAttributeNames() {
        return this.expressionAttributeNames;
    }

    public void setExpressionAttributeNames(Map<String, String> expressionAttributeNames) {
        this.expressionAttributeNames = expressionAttributeNames;
    }

    public DeleteItemRequest withExpressionAttributeNames(Map<String, String> expressionAttributeNames) {
        this.setExpressionAttributeNames(expressionAttributeNames);
        return this;
    }

    public DeleteItemRequest addExpressionAttributeNamesEntry(String key, String value) {
        if (null == this.expressionAttributeNames) {
            this.expressionAttributeNames = new HashMap<String, String>();
        }
        if (this.expressionAttributeNames.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.expressionAttributeNames.put(key, value);
        return this;
    }

    public DeleteItemRequest clearExpressionAttributeNamesEntries() {
        this.expressionAttributeNames = null;
        return this;
    }

    public Map<String, AttributeValue> getExpressionAttributeValues() {
        return this.expressionAttributeValues;
    }

    public void setExpressionAttributeValues(Map<String, AttributeValue> expressionAttributeValues) {
        this.expressionAttributeValues = expressionAttributeValues;
    }

    public DeleteItemRequest withExpressionAttributeValues(Map<String, AttributeValue> expressionAttributeValues) {
        this.setExpressionAttributeValues(expressionAttributeValues);
        return this;
    }

    public DeleteItemRequest addExpressionAttributeValuesEntry(String key, AttributeValue value) {
        if (null == this.expressionAttributeValues) {
            this.expressionAttributeValues = new HashMap<String, AttributeValue>();
        }
        if (this.expressionAttributeValues.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.expressionAttributeValues.put(key, value);
        return this;
    }

    public DeleteItemRequest clearExpressionAttributeValuesEntries() {
        this.expressionAttributeValues = null;
        return this;
    }

    public void setKey(Map.Entry<String, AttributeValue> hashKey, Map.Entry<String, AttributeValue> rangeKey) throws IllegalArgumentException {
        HashMap<String, AttributeValue> key = new HashMap<String, AttributeValue>();
        if (hashKey == null) {
            throw new IllegalArgumentException("hashKey must be non-null object.");
        }
        key.put(hashKey.getKey(), hashKey.getValue());
        if (rangeKey != null) {
            key.put(rangeKey.getKey(), rangeKey.getValue());
        }
        this.setKey(key);
    }

    public DeleteItemRequest withKey(Map.Entry<String, AttributeValue> hashKey, Map.Entry<String, AttributeValue> rangeKey) throws IllegalArgumentException {
        this.setKey(hashKey, rangeKey);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getTableName() != null) {
            sb.append("TableName: ").append(this.getTableName()).append(",");
        }
        if (this.getKey() != null) {
            sb.append("Key: ").append(this.getKey()).append(",");
        }
        if (this.getExpected() != null) {
            sb.append("Expected: ").append(this.getExpected()).append(",");
        }
        if (this.getConditionalOperator() != null) {
            sb.append("ConditionalOperator: ").append(this.getConditionalOperator()).append(",");
        }
        if (this.getReturnValues() != null) {
            sb.append("ReturnValues: ").append(this.getReturnValues()).append(",");
        }
        if (this.getReturnConsumedCapacity() != null) {
            sb.append("ReturnConsumedCapacity: ").append(this.getReturnConsumedCapacity()).append(",");
        }
        if (this.getReturnItemCollectionMetrics() != null) {
            sb.append("ReturnItemCollectionMetrics: ").append(this.getReturnItemCollectionMetrics()).append(",");
        }
        if (this.getConditionExpression() != null) {
            sb.append("ConditionExpression: ").append(this.getConditionExpression()).append(",");
        }
        if (this.getExpressionAttributeNames() != null) {
            sb.append("ExpressionAttributeNames: ").append(this.getExpressionAttributeNames()).append(",");
        }
        if (this.getExpressionAttributeValues() != null) {
            sb.append("ExpressionAttributeValues: ").append(this.getExpressionAttributeValues());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteItemRequest)) {
            return false;
        }
        DeleteItemRequest other = (DeleteItemRequest)obj;
        if (other.getTableName() == null ^ this.getTableName() == null) {
            return false;
        }
        if (other.getTableName() != null && !other.getTableName().equals(this.getTableName())) {
            return false;
        }
        if (other.getKey() == null ^ this.getKey() == null) {
            return false;
        }
        if (other.getKey() != null && !other.getKey().equals(this.getKey())) {
            return false;
        }
        if (other.getExpected() == null ^ this.getExpected() == null) {
            return false;
        }
        if (other.getExpected() != null && !other.getExpected().equals(this.getExpected())) {
            return false;
        }
        if (other.getConditionalOperator() == null ^ this.getConditionalOperator() == null) {
            return false;
        }
        if (other.getConditionalOperator() != null && !other.getConditionalOperator().equals(this.getConditionalOperator())) {
            return false;
        }
        if (other.getReturnValues() == null ^ this.getReturnValues() == null) {
            return false;
        }
        if (other.getReturnValues() != null && !other.getReturnValues().equals(this.getReturnValues())) {
            return false;
        }
        if (other.getReturnConsumedCapacity() == null ^ this.getReturnConsumedCapacity() == null) {
            return false;
        }
        if (other.getReturnConsumedCapacity() != null && !other.getReturnConsumedCapacity().equals(this.getReturnConsumedCapacity())) {
            return false;
        }
        if (other.getReturnItemCollectionMetrics() == null ^ this.getReturnItemCollectionMetrics() == null) {
            return false;
        }
        if (other.getReturnItemCollectionMetrics() != null && !other.getReturnItemCollectionMetrics().equals(this.getReturnItemCollectionMetrics())) {
            return false;
        }
        if (other.getConditionExpression() == null ^ this.getConditionExpression() == null) {
            return false;
        }
        if (other.getConditionExpression() != null && !other.getConditionExpression().equals(this.getConditionExpression())) {
            return false;
        }
        if (other.getExpressionAttributeNames() == null ^ this.getExpressionAttributeNames() == null) {
            return false;
        }
        if (other.getExpressionAttributeNames() != null && !other.getExpressionAttributeNames().equals(this.getExpressionAttributeNames())) {
            return false;
        }
        if (other.getExpressionAttributeValues() == null ^ this.getExpressionAttributeValues() == null) {
            return false;
        }
        return other.getExpressionAttributeValues() == null || other.getExpressionAttributeValues().equals(this.getExpressionAttributeValues());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getTableName() == null ? 0 : this.getTableName().hashCode());
        hashCode = 31 * hashCode + (this.getKey() == null ? 0 : this.getKey().hashCode());
        hashCode = 31 * hashCode + (this.getExpected() == null ? 0 : this.getExpected().hashCode());
        hashCode = 31 * hashCode + (this.getConditionalOperator() == null ? 0 : this.getConditionalOperator().hashCode());
        hashCode = 31 * hashCode + (this.getReturnValues() == null ? 0 : this.getReturnValues().hashCode());
        hashCode = 31 * hashCode + (this.getReturnConsumedCapacity() == null ? 0 : this.getReturnConsumedCapacity().hashCode());
        hashCode = 31 * hashCode + (this.getReturnItemCollectionMetrics() == null ? 0 : this.getReturnItemCollectionMetrics().hashCode());
        hashCode = 31 * hashCode + (this.getConditionExpression() == null ? 0 : this.getConditionExpression().hashCode());
        hashCode = 31 * hashCode + (this.getExpressionAttributeNames() == null ? 0 : this.getExpressionAttributeNames().hashCode());
        hashCode = 31 * hashCode + (this.getExpressionAttributeValues() == null ? 0 : this.getExpressionAttributeValues().hashCode());
        return hashCode;
    }

    @Override
    public DeleteItemRequest clone() {
        return (DeleteItemRequest)super.clone();
    }
}

