/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.s3base.shaded.com.amazonaws.services.dynamodbv2.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.flink.fs.s3base.shaded.com.amazonaws.annotation.SdkInternalApi;
import org.apache.flink.fs.s3base.shaded.com.amazonaws.protocol.ProtocolMarshaller;
import org.apache.flink.fs.s3base.shaded.com.amazonaws.protocol.StructuredPojo;
import org.apache.flink.fs.s3base.shaded.com.amazonaws.services.dynamodbv2.model.ProjectionType;
import org.apache.flink.fs.s3base.shaded.com.amazonaws.services.dynamodbv2.model.transform.ProjectionMarshaller;

public class Projection
implements Serializable,
Cloneable,
StructuredPojo {
    private String projectionType;
    private List<String> nonKeyAttributes;

    public void setProjectionType(String projectionType) {
        this.projectionType = projectionType;
    }

    public String getProjectionType() {
        return this.projectionType;
    }

    public Projection withProjectionType(String projectionType) {
        this.setProjectionType(projectionType);
        return this;
    }

    public void setProjectionType(ProjectionType projectionType) {
        this.withProjectionType(projectionType);
    }

    public Projection withProjectionType(ProjectionType projectionType) {
        this.projectionType = projectionType.toString();
        return this;
    }

    public List<String> getNonKeyAttributes() {
        return this.nonKeyAttributes;
    }

    public void setNonKeyAttributes(Collection<String> nonKeyAttributes) {
        if (nonKeyAttributes == null) {
            this.nonKeyAttributes = null;
            return;
        }
        this.nonKeyAttributes = new ArrayList<String>(nonKeyAttributes);
    }

    public Projection withNonKeyAttributes(String ... nonKeyAttributes) {
        if (this.nonKeyAttributes == null) {
            this.setNonKeyAttributes(new ArrayList<String>(nonKeyAttributes.length));
        }
        for (String ele : nonKeyAttributes) {
            this.nonKeyAttributes.add(ele);
        }
        return this;
    }

    public Projection withNonKeyAttributes(Collection<String> nonKeyAttributes) {
        this.setNonKeyAttributes(nonKeyAttributes);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getProjectionType() != null) {
            sb.append("ProjectionType: ").append(this.getProjectionType()).append(",");
        }
        if (this.getNonKeyAttributes() != null) {
            sb.append("NonKeyAttributes: ").append(this.getNonKeyAttributes());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Projection)) {
            return false;
        }
        Projection other = (Projection)obj;
        if (other.getProjectionType() == null ^ this.getProjectionType() == null) {
            return false;
        }
        if (other.getProjectionType() != null && !other.getProjectionType().equals(this.getProjectionType())) {
            return false;
        }
        if (other.getNonKeyAttributes() == null ^ this.getNonKeyAttributes() == null) {
            return false;
        }
        return other.getNonKeyAttributes() == null || other.getNonKeyAttributes().equals(this.getNonKeyAttributes());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getProjectionType() == null ? 0 : this.getProjectionType().hashCode());
        hashCode = 31 * hashCode + (this.getNonKeyAttributes() == null ? 0 : this.getNonKeyAttributes().hashCode());
        return hashCode;
    }

    public Projection clone() {
        try {
            return (Projection)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ProjectionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

