/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.s3base.shaded.com.amazonaws.services.dynamodbv2.xspec;

import java.util.LinkedHashMap;
import java.util.Map;

final class SubstitutionContext {
    private final Map<String, Integer> nameToToken = new LinkedHashMap<String, Integer>();
    private final Map<Object, Integer> valueToToken = new LinkedHashMap<Object, Integer>();

    SubstitutionContext() {
    }

    String nameTokenFor(String name) {
        Integer token = this.nameToToken.get(name);
        if (token == null) {
            token = this.nameToToken.size();
            this.nameToToken.put(name, token);
        }
        return "#" + token;
    }

    String valueTokenFor(Object value) {
        Integer token = this.valueToToken.get(value);
        if (token == null) {
            token = this.valueToToken.size();
            this.valueToToken.put(value, token);
        }
        return ":" + token;
    }

    Map<String, String> getNameMap() {
        if (this.nameToToken.size() == 0) {
            return null;
        }
        LinkedHashMap<String, String> out = new LinkedHashMap<String, String>();
        for (Map.Entry<String, Integer> e : this.nameToToken.entrySet()) {
            out.put("#" + e.getValue(), e.getKey());
        }
        return out;
    }

    Map<String, Object> getValueMap() {
        if (this.valueToToken.size() == 0) {
            return null;
        }
        LinkedHashMap<String, Object> out = new LinkedHashMap<String, Object>();
        for (Map.Entry<Object, Integer> e : this.valueToToken.entrySet()) {
            out.put(":" + e.getValue(), e.getKey());
        }
        return out;
    }

    int numNameTokens() {
        return this.nameToToken.size();
    }

    int numValueTokens() {
        return this.valueToToken.size();
    }

    String getNameByToken(int token) {
        for (Map.Entry<String, Integer> e : this.nameToToken.entrySet()) {
            if (e.getValue() != token) continue;
            return e.getKey();
        }
        return null;
    }

    Object getValueByToken(int token) {
        for (Map.Entry<Object, Integer> e : this.valueToToken.entrySet()) {
            if (e.getValue() != token) continue;
            return e.getKey();
        }
        return null;
    }

    public String toString() {
        return "name-tokens: " + this.nameToToken.toString() + "\nvalue-tokens: " + this.valueToToken.toString();
    }
}

