/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.s3base.shaded.com.amazonaws.services.s3.transfer.internal;

import java.io.File;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import org.apache.flink.fs.s3base.shaded.com.amazonaws.annotation.SdkInternalApi;
import org.apache.flink.fs.s3base.shaded.com.amazonaws.services.s3.internal.ServiceUtils;
import org.apache.flink.fs.s3base.shaded.com.amazonaws.services.s3.transfer.Transfer;
import org.apache.flink.fs.s3base.shaded.com.amazonaws.services.s3.transfer.internal.DownloadImpl;

@SdkInternalApi
public class CompleteMultipartDownload
implements Callable<File> {
    private final List<Future<File>> partFiles;
    private final File destinationFile;
    private final DownloadImpl download;
    private Integer currentPartNumber;

    public CompleteMultipartDownload(List<Future<File>> files, File destinationFile, DownloadImpl download, Integer currentPartNumber) {
        this.partFiles = files;
        this.destinationFile = destinationFile;
        this.download = download;
        this.currentPartNumber = currentPartNumber;
    }

    @Override
    public File call() throws Exception {
        for (Future<File> file : this.partFiles) {
            ServiceUtils.appendFile(file.get(), this.destinationFile);
            Integer n = this.currentPartNumber;
            Integer n2 = this.currentPartNumber = Integer.valueOf(this.currentPartNumber + 1);
            this.download.updatePersistableTransfer(n);
        }
        this.download.setState(Transfer.TransferState.Completed);
        return this.destinationFile;
    }
}

