/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.s3hadoop;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.flink.fs.s3.common.writer.S3AccessHelper;
import org.apache.flink.fs.s3base.shaded.com.amazonaws.SdkBaseException;
import org.apache.flink.fs.s3base.shaded.com.amazonaws.services.s3.model.CompleteMultipartUploadResult;
import org.apache.flink.fs.s3base.shaded.com.amazonaws.services.s3.model.ObjectMetadata;
import org.apache.flink.fs.s3base.shaded.com.amazonaws.services.s3.model.PartETag;
import org.apache.flink.fs.s3base.shaded.com.amazonaws.services.s3.model.PutObjectRequest;
import org.apache.flink.fs.s3base.shaded.com.amazonaws.services.s3.model.PutObjectResult;
import org.apache.flink.fs.s3base.shaded.com.amazonaws.services.s3.model.UploadPartRequest;
import org.apache.flink.fs.s3base.shaded.com.amazonaws.services.s3.model.UploadPartResult;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.conf.Configuration;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.FSDataInputStream;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.Path;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.s3a.S3AFileSystem;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.s3a.S3AUtils;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.s3a.WriteOperationHelper;
import org.apache.flink.util.MathUtils;
import org.apache.flink.util.Preconditions;

public class HadoopS3AccessHelper
implements S3AccessHelper {
    private final S3AFileSystem s3a;
    private final InternalWriteOperationHelper s3accessHelper;

    public HadoopS3AccessHelper(S3AFileSystem s3a, Configuration conf) {
        this.s3accessHelper = new InternalWriteOperationHelper((S3AFileSystem)Preconditions.checkNotNull((Object)s3a), (Configuration)Preconditions.checkNotNull((Object)conf));
        this.s3a = s3a;
    }

    @Override
    public String startMultiPartUpload(String key) throws IOException {
        return this.s3accessHelper.initiateMultiPartUpload(key);
    }

    @Override
    public UploadPartResult uploadPart(String key, String uploadId, int partNumber, InputStream inputStream, long length) throws IOException {
        UploadPartRequest uploadRequest = this.s3accessHelper.newUploadPartRequest(key, uploadId, partNumber, MathUtils.checkedDownCast((long)length), inputStream, null, 0L);
        return this.s3accessHelper.uploadPart(uploadRequest);
    }

    @Override
    public PutObjectResult putObject(String key, InputStream inputStream, long length) throws IOException {
        PutObjectRequest putRequest = this.s3accessHelper.createPutObjectRequest(key, inputStream, length);
        return this.s3accessHelper.putObject(putRequest);
    }

    @Override
    public CompleteMultipartUploadResult commitMultiPartUpload(String destKey, String uploadId, List<PartETag> partETags, long length, AtomicInteger errorCount) throws IOException {
        return this.s3accessHelper.completeMPUwithRetries(destKey, uploadId, partETags, length, errorCount);
    }

    @Override
    public boolean deleteObject(String key) throws IOException {
        return this.s3a.delete(new Path('/' + key), false);
    }

    @Override
    public long getObject(String key, File targetLocation) throws IOException {
        long numBytes = 0L;
        try (FileOutputStream outStream = new FileOutputStream(targetLocation);
             FSDataInputStream inStream = this.s3a.open(new Path('/' + key));){
            int numRead;
            byte[] buffer = new byte[32768];
            while ((numRead = inStream.read(buffer)) != -1) {
                ((OutputStream)outStream).write(buffer, 0, numRead);
                numBytes += (long)numRead;
            }
        }
        if (numBytes != targetLocation.length()) {
            throw new IOException(String.format("Error recovering writer: Downloading the last data chunk file gives incorrect length. File=%d bytes, Stream=%d bytes", targetLocation.length(), numBytes));
        }
        return numBytes;
    }

    @Override
    public ObjectMetadata getObjectMetadata(String key) throws IOException {
        try {
            return this.s3a.getObjectMetadata(new Path('/' + key));
        }
        catch (SdkBaseException e) {
            throw S3AUtils.translateException("getObjectMetadata", key, e);
        }
    }

    private static final class InternalWriteOperationHelper
    extends WriteOperationHelper {
        InternalWriteOperationHelper(S3AFileSystem owner, Configuration conf) {
            super(owner, conf);
        }
    }
}

