/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.classification.InterfaceAudience;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.classification.InterfaceStability;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.GetSpaceUsed;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.LimitedPrivate(value={"HDFS", "MapReduce"})
@InterfaceStability.Evolving
public abstract class CachingGetSpaceUsed
implements Closeable,
GetSpaceUsed {
    static final Logger LOG = LoggerFactory.getLogger(CachingGetSpaceUsed.class);
    protected final AtomicLong used = new AtomicLong();
    private final AtomicBoolean running = new AtomicBoolean(true);
    private final long refreshInterval;
    private final long jitter;
    private final String dirPath;
    private Thread refreshUsed;

    public CachingGetSpaceUsed(GetSpaceUsed.Builder builder) throws IOException {
        this(builder.getPath(), builder.getInterval(), builder.getJitter(), builder.getInitialUsed());
    }

    CachingGetSpaceUsed(File path, long interval, long jitter, long initialUsed) throws IOException {
        this.dirPath = path.getCanonicalPath();
        this.refreshInterval = interval;
        this.jitter = jitter;
        this.used.set(initialUsed);
    }

    void init() {
        if (this.used.get() < 0L) {
            this.used.set(0L);
            this.refresh();
        }
        if (this.refreshInterval > 0L) {
            this.refreshUsed = new Thread((Runnable)new RefreshThread(this), "refreshUsed-" + this.dirPath);
            this.refreshUsed.setDaemon(true);
            this.refreshUsed.start();
        } else {
            this.running.set(false);
            this.refreshUsed = null;
        }
    }

    protected abstract void refresh();

    @Override
    public long getUsed() throws IOException {
        return Math.max(this.used.get(), 0L);
    }

    public String getDirPath() {
        return this.dirPath;
    }

    public void incDfsUsed(long value) {
        this.used.addAndGet(value);
    }

    boolean running() {
        return this.running.get();
    }

    long getRefreshInterval() {
        return this.refreshInterval;
    }

    protected void setUsed(long usedValue) {
        this.used.set(usedValue);
    }

    @Override
    public void close() throws IOException {
        this.running.set(false);
        if (this.refreshUsed != null) {
            this.refreshUsed.interrupt();
        }
    }

    private static final class RefreshThread
    implements Runnable {
        final CachingGetSpaceUsed spaceUsed;

        RefreshThread(CachingGetSpaceUsed spaceUsed) {
            this.spaceUsed = spaceUsed;
        }

        @Override
        public void run() {
            while (this.spaceUsed.running()) {
                try {
                    long refreshInterval = this.spaceUsed.refreshInterval;
                    if (this.spaceUsed.jitter > 0L) {
                        long jitter = this.spaceUsed.jitter;
                        refreshInterval += ThreadLocalRandom.current().nextLong(-jitter, jitter);
                    }
                    refreshInterval = Math.max(refreshInterval, 1L);
                    Thread.sleep(refreshInterval);
                    this.spaceUsed.refresh();
                }
                catch (InterruptedException e) {
                    LOG.warn("Thread Interrupted waiting to refresh disk information: " + e.getMessage());
                    Thread.currentThread().interrupt();
                }
            }
        }
    }
}

