/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.util;

import org.apache.flink.fs.s3base.shaded.com.google.common.base.Preconditions;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.classification.InterfaceAudience;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.classification.InterfaceStability;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public final class IdentityHashStore<K, V> {
    private Object[] buffer;
    private int numInserted = 0;
    private int capacity;
    private static final int DEFAULT_MAX_CAPACITY = 2;

    public IdentityHashStore(int capacity) {
        Preconditions.checkArgument(capacity >= 0);
        if (capacity == 0) {
            this.capacity = 0;
            this.buffer = null;
        } else {
            this.realloc((int)Math.pow(2.0, Math.ceil(Math.log(capacity) / Math.log(2.0))));
        }
    }

    private void realloc(int newCapacity) {
        Preconditions.checkArgument(newCapacity > 0);
        Object[] prevBuffer = this.buffer;
        this.capacity = newCapacity;
        this.buffer = new Object[4 * newCapacity];
        this.numInserted = 0;
        if (prevBuffer != null) {
            for (int i = 0; i < prevBuffer.length; i += 2) {
                if (prevBuffer[i] == null) continue;
                this.putInternal(prevBuffer[i], prevBuffer[i + 1]);
            }
        }
    }

    private void putInternal(Object k, Object v) {
        int hash = System.identityHashCode(k);
        int numEntries = this.buffer.length >> 1;
        int index = hash & numEntries - 1;
        while (true) {
            if (this.buffer[2 * index] == null) {
                this.buffer[2 * index] = k;
                this.buffer[1 + 2 * index] = v;
                ++this.numInserted;
                return;
            }
            index = (index + 1) % numEntries;
        }
    }

    public void put(K k, V v) {
        Preconditions.checkNotNull(k);
        if (this.buffer == null) {
            this.realloc(2);
        } else if (this.numInserted + 1 > this.capacity) {
            this.realloc(this.capacity * 2);
        }
        this.putInternal(k, v);
    }

    private int getElementIndex(K k) {
        int index;
        if (this.buffer == null) {
            return -1;
        }
        int numEntries = this.buffer.length >> 1;
        int hash = System.identityHashCode(k);
        int firstIndex = index = hash & numEntries - 1;
        do {
            if (this.buffer[2 * index] != k) continue;
            return index;
        } while ((index = (index + 1) % numEntries) != firstIndex);
        return -1;
    }

    public V get(K k) {
        int index = this.getElementIndex(k);
        if (index < 0) {
            return null;
        }
        return (V)this.buffer[1 + 2 * index];
    }

    public V remove(K k) {
        int index = this.getElementIndex(k);
        if (index < 0) {
            return null;
        }
        Object val = this.buffer[1 + 2 * index];
        this.buffer[2 * index] = null;
        this.buffer[1 + 2 * index] = null;
        --this.numInserted;
        return (V)val;
    }

    public boolean isEmpty() {
        return this.numInserted == 0;
    }

    public int numElements() {
        return this.numInserted;
    }

    public int capacity() {
        return this.capacity;
    }

    public void visitAll(Visitor<K, V> visitor) {
        int length = this.buffer == null ? 0 : this.buffer.length;
        for (int i = 0; i < length; i += 2) {
            if (this.buffer[i] == null) continue;
            visitor.accept(this.buffer[i], this.buffer[i + 1]);
        }
    }

    public static interface Visitor<K, V> {
        public void accept(K var1, V var2);
    }
}

