/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.s3.common.writer;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.flink.annotation.Internal;
import org.apache.flink.fs.s3base.shaded.com.amazonaws.services.s3.model.PartETag;
import org.apache.flink.util.Preconditions;

@Internal
final class MultiPartUploadInfo {
    private final String objectName;
    private final String uploadId;
    private final List<PartETag> completeParts;
    private final Optional<File> incompletePart;
    private int numberOfRegisteredParts;
    private long expectedSizeInBytes;

    MultiPartUploadInfo(String objectName, String uploadId, List<PartETag> completeParts, long numBytes, Optional<File> incompletePart) {
        Preconditions.checkArgument((numBytes >= 0L ? 1 : 0) != 0);
        this.objectName = (String)Preconditions.checkNotNull((Object)objectName);
        this.uploadId = (String)Preconditions.checkNotNull((Object)uploadId);
        this.completeParts = (List)Preconditions.checkNotNull(completeParts);
        this.incompletePart = (Optional)Preconditions.checkNotNull(incompletePart);
        this.numberOfRegisteredParts = completeParts.size();
        this.expectedSizeInBytes = numBytes;
    }

    String getObjectName() {
        return this.objectName;
    }

    String getUploadId() {
        return this.uploadId;
    }

    int getNumberOfRegisteredParts() {
        return this.numberOfRegisteredParts;
    }

    long getExpectedSizeInBytes() {
        return this.expectedSizeInBytes;
    }

    Optional<File> getIncompletePart() {
        return this.incompletePart;
    }

    List<PartETag> getCopyOfEtagsOfCompleteParts() {
        return new ArrayList<PartETag>(this.completeParts);
    }

    void registerNewPart(long length) {
        this.expectedSizeInBytes += length;
        ++this.numberOfRegisteredParts;
    }

    void registerCompletePart(PartETag eTag) {
        this.completeParts.add(eTag);
    }

    int getRemainingParts() {
        return this.numberOfRegisteredParts - this.completeParts.size();
    }
}

