/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.s3base.shaded.com.amazonaws.internal;

import java.io.IOException;
import java.io.InputStream;
import org.apache.flink.fs.s3base.shaded.com.amazonaws.AbortedException;
import org.apache.flink.fs.s3base.shaded.com.amazonaws.internal.MetricAware;
import org.apache.flink.fs.s3base.shaded.com.amazonaws.internal.Releasable;
import org.apache.flink.fs.s3base.shaded.com.amazonaws.util.IOUtils;
import org.apache.flink.fs.s3base.shaded.com.amazonaws.util.SdkRuntime;
import org.apache.flink.fs.shaded.hadoop3.org.apache.commons.logging.LogFactory;

public abstract class SdkInputStream
extends InputStream
implements MetricAware,
Releasable {
    protected abstract InputStream getWrappedInputStream();

    @Override
    public final boolean isMetricActivated() {
        InputStream in = this.getWrappedInputStream();
        if (in instanceof MetricAware) {
            MetricAware metricAware = (MetricAware)((Object)in);
            return metricAware.isMetricActivated();
        }
        return false;
    }

    protected final void abortIfNeeded() {
        if (SdkRuntime.shouldAbort()) {
            try {
                this.abort();
            }
            catch (IOException e) {
                LogFactory.getLog(this.getClass()).debug("FYI", e);
            }
            throw new AbortedException();
        }
    }

    protected void abort() throws IOException {
    }

    @Override
    public void release() {
        IOUtils.closeQuietly(this, null);
        InputStream in = this.getWrappedInputStream();
        if (in instanceof Releasable) {
            Releasable r = (Releasable)((Object)in);
            r.release();
        }
    }
}

