/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.s3base.shaded.com.amazonaws.services.dynamodbv2.document.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.flink.fs.s3base.shaded.com.amazonaws.services.dynamodbv2.AmazonDynamoDB;
import org.apache.flink.fs.s3base.shaded.com.amazonaws.services.dynamodbv2.document.BatchWriteItemOutcome;
import org.apache.flink.fs.s3base.shaded.com.amazonaws.services.dynamodbv2.document.Item;
import org.apache.flink.fs.s3base.shaded.com.amazonaws.services.dynamodbv2.document.PrimaryKey;
import org.apache.flink.fs.s3base.shaded.com.amazonaws.services.dynamodbv2.document.TableWriteItems;
import org.apache.flink.fs.s3base.shaded.com.amazonaws.services.dynamodbv2.document.api.BatchWriteItemApi;
import org.apache.flink.fs.s3base.shaded.com.amazonaws.services.dynamodbv2.document.internal.InternalUtils;
import org.apache.flink.fs.s3base.shaded.com.amazonaws.services.dynamodbv2.document.spec.BatchWriteItemSpec;
import org.apache.flink.fs.s3base.shaded.com.amazonaws.services.dynamodbv2.model.BatchWriteItemRequest;
import org.apache.flink.fs.s3base.shaded.com.amazonaws.services.dynamodbv2.model.BatchWriteItemResult;
import org.apache.flink.fs.s3base.shaded.com.amazonaws.services.dynamodbv2.model.DeleteRequest;
import org.apache.flink.fs.s3base.shaded.com.amazonaws.services.dynamodbv2.model.PutRequest;
import org.apache.flink.fs.s3base.shaded.com.amazonaws.services.dynamodbv2.model.WriteRequest;

public class BatchWriteItemImpl
implements BatchWriteItemApi {
    private final AmazonDynamoDB client;

    public BatchWriteItemImpl(AmazonDynamoDB client) {
        this.client = client;
    }

    @Override
    public BatchWriteItemOutcome batchWriteItem(TableWriteItems ... tableWriteItems) {
        return this.doBatchWriteItem(new BatchWriteItemSpec().withTableWriteItems(tableWriteItems));
    }

    @Override
    public BatchWriteItemOutcome batchWriteItem(BatchWriteItemSpec spec) {
        return this.doBatchWriteItem(spec);
    }

    @Override
    public BatchWriteItemOutcome batchWriteItemUnprocessed(Map<String, List<WriteRequest>> unprocessedItems) {
        return this.doBatchWriteItem(new BatchWriteItemSpec().withUnprocessedItems(unprocessedItems));
    }

    private BatchWriteItemOutcome doBatchWriteItem(BatchWriteItemSpec spec) {
        Collection<TableWriteItems> tableWriteItemsCol = spec.getTableWriteItems();
        Map<String, List<WriteRequest>> requestItems = spec.getUnprocessedItems();
        if (requestItems == null || requestItems.size() == 0) {
            requestItems = new LinkedHashMap<String, List<WriteRequest>>();
        }
        if (tableWriteItemsCol != null) {
            for (TableWriteItems tableWriteItems : tableWriteItemsCol) {
                Collection<Item> itemsToPut = tableWriteItems.getItemsToPut();
                List<PrimaryKey> pksToDelete = tableWriteItems.getPrimaryKeysToDelete();
                int numPut = itemsToPut == null ? 0 : itemsToPut.size();
                int numDel = pksToDelete == null ? 0 : pksToDelete.size();
                ArrayList<WriteRequest> writeRequests = new ArrayList<WriteRequest>(numPut + numDel);
                if (itemsToPut != null) {
                    for (Item item : itemsToPut) {
                        writeRequests.add(new WriteRequest().withPutRequest(new PutRequest().withItem(InternalUtils.toAttributeValues(item))));
                    }
                }
                if (pksToDelete != null) {
                    for (PrimaryKey pkToDelete : pksToDelete) {
                        writeRequests.add(new WriteRequest().withDeleteRequest(new DeleteRequest().withKey(InternalUtils.toAttributeValueMap(pkToDelete))));
                    }
                }
                requestItems.put(tableWriteItems.getTableName(), writeRequests);
            }
        }
        BatchWriteItemRequest req = ((BatchWriteItemRequest)spec.getRequest()).withRequestItems(requestItems);
        BatchWriteItemResult result = this.client.batchWriteItem(req);
        return new BatchWriteItemOutcome(result);
    }
}

