/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.s3base.shaded.com.amazonaws.services.dynamodbv2.model.transform;

import org.apache.flink.fs.s3base.shaded.com.amazonaws.SdkClientException;
import org.apache.flink.fs.s3base.shaded.com.amazonaws.annotation.SdkInternalApi;
import org.apache.flink.fs.s3base.shaded.com.amazonaws.protocol.MarshallLocation;
import org.apache.flink.fs.s3base.shaded.com.amazonaws.protocol.MarshallingInfo;
import org.apache.flink.fs.s3base.shaded.com.amazonaws.protocol.MarshallingType;
import org.apache.flink.fs.s3base.shaded.com.amazonaws.protocol.ProtocolMarshaller;
import org.apache.flink.fs.s3base.shaded.com.amazonaws.protocol.StructuredPojo;
import org.apache.flink.fs.s3base.shaded.com.amazonaws.services.dynamodbv2.model.BackupDescription;

@SdkInternalApi
public class BackupDescriptionMarshaller {
    private static final MarshallingInfo<StructuredPojo> BACKUPDETAILS_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("BackupDetails").build();
    private static final MarshallingInfo<StructuredPojo> SOURCETABLEDETAILS_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SourceTableDetails").build();
    private static final MarshallingInfo<StructuredPojo> SOURCETABLEFEATUREDETAILS_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SourceTableFeatureDetails").build();
    private static final BackupDescriptionMarshaller instance = new BackupDescriptionMarshaller();

    public static BackupDescriptionMarshaller getInstance() {
        return instance;
    }

    public void marshall(BackupDescription backupDescription, ProtocolMarshaller protocolMarshaller) {
        if (backupDescription == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(backupDescription.getBackupDetails(), BACKUPDETAILS_BINDING);
            protocolMarshaller.marshall(backupDescription.getSourceTableDetails(), SOURCETABLEDETAILS_BINDING);
            protocolMarshaller.marshall(backupDescription.getSourceTableFeatureDetails(), SOURCETABLEFEATUREDETAILS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

