/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.s3base.shaded.com.amazonaws.services.kms.model.transform;

import java.nio.ByteBuffer;
import java.util.Date;
import org.apache.flink.fs.s3base.shaded.com.amazonaws.SdkClientException;
import org.apache.flink.fs.s3base.shaded.com.amazonaws.annotation.SdkInternalApi;
import org.apache.flink.fs.s3base.shaded.com.amazonaws.protocol.MarshallLocation;
import org.apache.flink.fs.s3base.shaded.com.amazonaws.protocol.MarshallingInfo;
import org.apache.flink.fs.s3base.shaded.com.amazonaws.protocol.MarshallingType;
import org.apache.flink.fs.s3base.shaded.com.amazonaws.protocol.ProtocolMarshaller;
import org.apache.flink.fs.s3base.shaded.com.amazonaws.services.kms.model.ImportKeyMaterialRequest;

@SdkInternalApi
public class ImportKeyMaterialRequestMarshaller {
    private static final MarshallingInfo<String> KEYID_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("KeyId").build();
    private static final MarshallingInfo<ByteBuffer> IMPORTTOKEN_BINDING = MarshallingInfo.builder(MarshallingType.BYTE_BUFFER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ImportToken").build();
    private static final MarshallingInfo<ByteBuffer> ENCRYPTEDKEYMATERIAL_BINDING = MarshallingInfo.builder(MarshallingType.BYTE_BUFFER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EncryptedKeyMaterial").build();
    private static final MarshallingInfo<Date> VALIDTO_BINDING = MarshallingInfo.builder(MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ValidTo").build();
    private static final MarshallingInfo<String> EXPIRATIONMODEL_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ExpirationModel").build();
    private static final ImportKeyMaterialRequestMarshaller instance = new ImportKeyMaterialRequestMarshaller();

    public static ImportKeyMaterialRequestMarshaller getInstance() {
        return instance;
    }

    public void marshall(ImportKeyMaterialRequest importKeyMaterialRequest, ProtocolMarshaller protocolMarshaller) {
        if (importKeyMaterialRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(importKeyMaterialRequest.getKeyId(), KEYID_BINDING);
            protocolMarshaller.marshall(importKeyMaterialRequest.getImportToken(), IMPORTTOKEN_BINDING);
            protocolMarshaller.marshall(importKeyMaterialRequest.getEncryptedKeyMaterial(), ENCRYPTEDKEYMATERIAL_BINDING);
            protocolMarshaller.marshall(importKeyMaterialRequest.getValidTo(), VALIDTO_BINDING);
            protocolMarshaller.marshall(importKeyMaterialRequest.getExpirationModel(), EXPIRATIONMODEL_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

