/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.s3base.shaded.com.google.common.hash;

import java.io.Serializable;
import java.nio.ByteBuffer;
import org.apache.flink.fs.s3base.shaded.com.google.common.hash.AbstractStreamingHashFunction;
import org.apache.flink.fs.s3base.shaded.com.google.common.hash.HashCode;
import org.apache.flink.fs.s3base.shaded.com.google.common.hash.HashCodes;
import org.apache.flink.fs.s3base.shaded.com.google.common.hash.Hasher;
import org.apache.flink.fs.s3base.shaded.com.google.common.primitives.UnsignedBytes;

final class Murmur3_32HashFunction
extends AbstractStreamingHashFunction
implements Serializable {
    private final int seed;
    private static final long serialVersionUID = 0L;

    Murmur3_32HashFunction(int seed) {
        this.seed = seed;
    }

    public int bits() {
        return 32;
    }

    public Hasher newHasher() {
        return new Murmur3_32Hasher(this.seed);
    }

    private static final class Murmur3_32Hasher
    extends AbstractStreamingHashFunction.AbstractStreamingHasher {
        int h1;
        int c1 = -862048943;
        int c2 = 461845907;
        int len;

        Murmur3_32Hasher(int seed) {
            super(4);
            this.h1 = seed;
        }

        protected void process(ByteBuffer bb) {
            int k1 = bb.getInt();
            this.len += 4;
            k1 *= this.c1;
            k1 = Integer.rotateLeft(k1, 15);
            this.h1 ^= (k1 *= this.c2);
            this.h1 = Integer.rotateLeft(this.h1, 13);
            this.h1 = this.h1 * 5 + -430675100;
        }

        protected void processRemaining(ByteBuffer bb) {
            this.len += bb.remaining();
            int k1 = 0;
            switch (bb.remaining()) {
                case 3: {
                    k1 ^= UnsignedBytes.toInt(bb.get(2)) << 16;
                }
                case 2: {
                    k1 ^= UnsignedBytes.toInt(bb.get(1)) << 8;
                }
                case 1: {
                    k1 ^= UnsignedBytes.toInt(bb.get(0));
                }
            }
            k1 *= this.c1;
            k1 = Integer.rotateLeft(k1, 15);
            this.h1 ^= (k1 *= this.c2);
        }

        public HashCode makeHash() {
            this.h1 ^= this.len;
            this.h1 ^= this.h1 >>> 16;
            this.h1 *= -2048144789;
            this.h1 ^= this.h1 >>> 13;
            this.h1 *= -1028477387;
            this.h1 ^= this.h1 >>> 16;
            return HashCodes.fromInt(this.h1);
        }
    }
}

