/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.s3a.s3guard;

import org.apache.flink.fs.s3base.shaded.com.google.common.base.Preconditions;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.classification.InterfaceAudience;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.classification.InterfaceStability;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.FileStatus;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.Path;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.s3a.Tristate;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class PathMetadata {
    private final FileStatus fileStatus;
    private Tristate isEmptyDirectory;
    private boolean isDeleted;

    public static PathMetadata tombstone(Path path) {
        long now = System.currentTimeMillis();
        FileStatus status = new FileStatus(0L, false, 0, 0L, now, path);
        return new PathMetadata(status, Tristate.UNKNOWN, true);
    }

    public PathMetadata(FileStatus fileStatus) {
        this(fileStatus, Tristate.UNKNOWN);
    }

    public PathMetadata(FileStatus fileStatus, Tristate isEmptyDir) {
        this(fileStatus, isEmptyDir, false);
    }

    public PathMetadata(FileStatus fileStatus, Tristate isEmptyDir, boolean isDeleted) {
        Preconditions.checkNotNull(fileStatus, "fileStatus must be non-null");
        Preconditions.checkNotNull(fileStatus.getPath(), "fileStatus path must be non-null");
        Preconditions.checkArgument(fileStatus.getPath().isAbsolute(), "path must be absolute");
        this.fileStatus = fileStatus;
        this.isEmptyDirectory = isEmptyDir;
        this.isDeleted = isDeleted;
    }

    public final FileStatus getFileStatus() {
        return this.fileStatus;
    }

    public Tristate isEmptyDirectory() {
        return this.isEmptyDirectory;
    }

    void setIsEmptyDirectory(Tristate isEmptyDirectory) {
        this.isEmptyDirectory = isEmptyDirectory;
    }

    public boolean isDeleted() {
        return this.isDeleted;
    }

    void setIsDeleted(boolean isDeleted) {
        this.isDeleted = isDeleted;
    }

    public boolean equals(Object o) {
        if (!(o instanceof PathMetadata)) {
            return false;
        }
        return this.fileStatus.equals(((PathMetadata)o).fileStatus);
    }

    public int hashCode() {
        return this.fileStatus.hashCode();
    }

    public String toString() {
        return "PathMetadata{fileStatus=" + this.fileStatus + "; isEmptyDirectory=" + (Object)((Object)this.isEmptyDirectory) + "; isDeleted=" + this.isDeleted + '}';
    }

    public void prettyPrint(StringBuilder sb) {
        sb.append(String.format("%-5s %-20s %-7d %-8s %-6s", this.fileStatus.isDirectory() ? "dir" : "file", this.fileStatus.getPath().toString(), this.fileStatus.getLen(), this.isEmptyDirectory.name(), this.isDeleted));
        sb.append(this.fileStatus);
    }

    public String prettyPrint() {
        StringBuilder sb = new StringBuilder();
        this.prettyPrint(sb);
        return sb.toString();
    }
}

