/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.s3.common.writer;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Optional;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.core.fs.RecoverableFsDataOutputStream;
import org.apache.flink.core.fs.RecoverableWriter;
import org.apache.flink.fs.s3.common.utils.RefCountedBufferingFileStream;
import org.apache.flink.fs.s3.common.utils.RefCountedFSOutputStream;
import org.apache.flink.fs.s3.common.utils.RefCountedFile;
import org.apache.flink.fs.s3.common.writer.RecoverableMultiPartUpload;
import org.apache.flink.fs.shaded.hadoop3.org.apache.commons.io.IOUtils;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.function.FunctionWithException;

@PublicEvolving
@NotThreadSafe
public final class S3RecoverableFsDataOutputStream
extends RecoverableFsDataOutputStream {
    private final ReentrantLock lock = new ReentrantLock();
    private final RecoverableMultiPartUpload upload;
    private final FunctionWithException<File, RefCountedFile, IOException> tmpFileProvider;
    private final long userDefinedMinPartSize;
    private RefCountedFSOutputStream fileStream;
    private long bytesBeforeCurrentPart;

    S3RecoverableFsDataOutputStream(RecoverableMultiPartUpload upload, FunctionWithException<File, RefCountedFile, IOException> tempFileCreator, RefCountedFSOutputStream initialTmpFile, long userDefinedMinPartSize, long bytesBeforeCurrentPart) {
        Preconditions.checkArgument((bytesBeforeCurrentPart >= 0L ? 1 : 0) != 0);
        this.upload = (RecoverableMultiPartUpload)Preconditions.checkNotNull((Object)upload);
        this.tmpFileProvider = (FunctionWithException)Preconditions.checkNotNull(tempFileCreator);
        this.userDefinedMinPartSize = userDefinedMinPartSize;
        this.fileStream = initialTmpFile;
        this.bytesBeforeCurrentPart = bytesBeforeCurrentPart;
    }

    public void write(int b) throws IOException {
        this.fileStream.write(b);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        this.fileStream.write(b, off, len);
        this.openNewPartIfNecessary(this.userDefinedMinPartSize);
    }

    public void flush() throws IOException {
        this.fileStream.flush();
        this.openNewPartIfNecessary(this.userDefinedMinPartSize);
    }

    public long getPos() throws IOException {
        return this.bytesBeforeCurrentPart + this.fileStream.getPos();
    }

    public void sync() throws IOException {
        this.fileStream.sync();
    }

    public void close() throws IOException {
        this.lock();
        try {
            this.fileStream.flush();
        }
        finally {
            IOUtils.closeQuietly((OutputStream)((Object)this.fileStream));
            this.fileStream.release();
            this.unlock();
        }
    }

    public RecoverableWriter.ResumeRecoverable persist() throws IOException {
        this.lock();
        try {
            this.fileStream.flush();
            this.openNewPartIfNecessary(this.userDefinedMinPartSize);
            RecoverableWriter.ResumeRecoverable resumeRecoverable = this.upload.snapshotAndGetRecoverable(this.fileStream);
            return resumeRecoverable;
        }
        finally {
            this.unlock();
        }
    }

    public RecoverableFsDataOutputStream.Committer closeForCommit() throws IOException {
        this.lock();
        try {
            this.closeAndUploadPart();
            RecoverableFsDataOutputStream.Committer committer = this.upload.snapshotAndGetCommitter();
            return committer;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void openNewPartIfNecessary(long sizeThreshold) throws IOException {
        long fileLength = this.fileStream.getPos();
        if (fileLength >= sizeThreshold) {
            this.lock();
            try {
                this.uploadCurrentAndOpenNewPart(fileLength);
            }
            finally {
                this.unlock();
            }
        }
    }

    private void uploadCurrentAndOpenNewPart(long fileLength) throws IOException {
        this.bytesBeforeCurrentPart += fileLength;
        this.closeAndUploadPart();
        this.fileStream = RefCountedBufferingFileStream.openNew(this.tmpFileProvider);
    }

    private void closeAndUploadPart() throws IOException {
        this.fileStream.flush();
        this.fileStream.close();
        if (this.fileStream.getPos() > 0L) {
            this.upload.uploadPart(this.fileStream);
        }
        this.fileStream.release();
    }

    private void lock() throws IOException {
        try {
            this.lock.lockInterruptibly();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IOException("interrupted");
        }
    }

    private void unlock() {
        this.lock.unlock();
    }

    public static S3RecoverableFsDataOutputStream newStream(RecoverableMultiPartUpload upload, FunctionWithException<File, RefCountedFile, IOException> tmpFileCreator, long userDefinedMinPartSize) throws IOException {
        Preconditions.checkArgument((userDefinedMinPartSize >= 0x500000L ? 1 : 0) != 0);
        RefCountedBufferingFileStream fileStream = S3RecoverableFsDataOutputStream.boundedBufferingFileStream(tmpFileCreator, Optional.empty());
        return new S3RecoverableFsDataOutputStream(upload, tmpFileCreator, fileStream, userDefinedMinPartSize, 0L);
    }

    public static S3RecoverableFsDataOutputStream recoverStream(RecoverableMultiPartUpload upload, FunctionWithException<File, RefCountedFile, IOException> tmpFileCreator, long userDefinedMinPartSize, long bytesBeforeCurrentPart) throws IOException {
        Preconditions.checkArgument((userDefinedMinPartSize >= 0x500000L ? 1 : 0) != 0);
        RefCountedBufferingFileStream fileStream = S3RecoverableFsDataOutputStream.boundedBufferingFileStream(tmpFileCreator, upload.getIncompletePart());
        return new S3RecoverableFsDataOutputStream(upload, tmpFileCreator, fileStream, userDefinedMinPartSize, bytesBeforeCurrentPart);
    }

    private static RefCountedBufferingFileStream boundedBufferingFileStream(FunctionWithException<File, RefCountedFile, IOException> tmpFileCreator, Optional<File> incompletePart) throws IOException {
        if (!incompletePart.isPresent()) {
            return RefCountedBufferingFileStream.openNew(tmpFileCreator);
        }
        File file = incompletePart.get();
        return RefCountedBufferingFileStream.restore(tmpFileCreator, file);
    }
}

