/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.s3.common.writer;

import java.io.File;
import java.io.IOException;
import java.util.concurrent.Executor;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.core.fs.Path;
import org.apache.flink.core.fs.RecoverableFsDataOutputStream;
import org.apache.flink.core.fs.RecoverableWriter;
import org.apache.flink.core.io.SimpleVersionedSerializer;
import org.apache.flink.fs.s3.common.utils.RefCountedFile;
import org.apache.flink.fs.s3.common.writer.RecoverableMultiPartUpload;
import org.apache.flink.fs.s3.common.writer.S3AccessHelper;
import org.apache.flink.fs.s3.common.writer.S3Recoverable;
import org.apache.flink.fs.s3.common.writer.S3RecoverableFsDataOutputStream;
import org.apache.flink.fs.s3.common.writer.S3RecoverableMultipartUploadFactory;
import org.apache.flink.fs.s3.common.writer.S3RecoverableSerializer;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.FileSystem;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.function.FunctionWithException;

@PublicEvolving
public class S3RecoverableWriter
implements RecoverableWriter {
    private final FunctionWithException<File, RefCountedFile, IOException> tempFileCreator;
    private final long userDefinedMinPartSize;
    private final S3AccessHelper s3AccessHelper;
    private final S3RecoverableMultipartUploadFactory uploadFactory;

    @VisibleForTesting
    S3RecoverableWriter(S3AccessHelper s3AccessHelper, S3RecoverableMultipartUploadFactory uploadFactory, FunctionWithException<File, RefCountedFile, IOException> tempFileCreator, long userDefinedMinPartSize) {
        this.s3AccessHelper = (S3AccessHelper)Preconditions.checkNotNull((Object)s3AccessHelper);
        this.uploadFactory = (S3RecoverableMultipartUploadFactory)Preconditions.checkNotNull((Object)uploadFactory);
        this.tempFileCreator = (FunctionWithException)Preconditions.checkNotNull(tempFileCreator);
        this.userDefinedMinPartSize = userDefinedMinPartSize;
    }

    public RecoverableFsDataOutputStream open(Path path) throws IOException {
        RecoverableMultiPartUpload upload = this.uploadFactory.getNewRecoverableUpload(path);
        return S3RecoverableFsDataOutputStream.newStream(upload, this.tempFileCreator, this.userDefinedMinPartSize);
    }

    public RecoverableFsDataOutputStream.Committer recoverForCommit(RecoverableWriter.CommitRecoverable recoverable) throws IOException {
        S3Recoverable s3recoverable = S3RecoverableWriter.castToS3Recoverable(recoverable);
        S3RecoverableFsDataOutputStream recovered = this.recover(s3recoverable);
        return recovered.closeForCommit();
    }

    public S3RecoverableFsDataOutputStream recover(RecoverableWriter.ResumeRecoverable recoverable) throws IOException {
        S3Recoverable s3recoverable = S3RecoverableWriter.castToS3Recoverable((RecoverableWriter.CommitRecoverable)recoverable);
        RecoverableMultiPartUpload upload = this.uploadFactory.recoverRecoverableUpload(s3recoverable);
        return S3RecoverableFsDataOutputStream.recoverStream(upload, this.tempFileCreator, this.userDefinedMinPartSize, s3recoverable.numBytesInParts());
    }

    public boolean requiresCleanupOfRecoverableState() {
        return true;
    }

    public boolean cleanupRecoverableState(RecoverableWriter.ResumeRecoverable resumable) throws IOException {
        S3Recoverable s3recoverable = S3RecoverableWriter.castToS3Recoverable((RecoverableWriter.CommitRecoverable)resumable);
        String smallPartObjectToDelete = s3recoverable.incompleteObjectName();
        return smallPartObjectToDelete != null && this.s3AccessHelper.deleteObject(smallPartObjectToDelete);
    }

    public SimpleVersionedSerializer<RecoverableWriter.CommitRecoverable> getCommitRecoverableSerializer() {
        return S3RecoverableSerializer.INSTANCE;
    }

    public SimpleVersionedSerializer<RecoverableWriter.ResumeRecoverable> getResumeRecoverableSerializer() {
        return S3RecoverableSerializer.INSTANCE;
    }

    public boolean supportsResume() {
        return true;
    }

    private static S3Recoverable castToS3Recoverable(RecoverableWriter.CommitRecoverable recoverable) {
        if (recoverable instanceof S3Recoverable) {
            return (S3Recoverable)recoverable;
        }
        throw new IllegalArgumentException("S3 File System cannot recover recoverable for other file system: " + recoverable);
    }

    public static S3RecoverableWriter writer(FileSystem fs, FunctionWithException<File, RefCountedFile, IOException> tempFileCreator, S3AccessHelper s3AccessHelper, Executor uploadThreadPool, long userDefinedMinPartSize, int maxConcurrentUploadsPerStream) {
        Preconditions.checkArgument((userDefinedMinPartSize >= 0x500000L ? 1 : 0) != 0);
        S3RecoverableMultipartUploadFactory uploadFactory = new S3RecoverableMultipartUploadFactory(fs, s3AccessHelper, maxConcurrentUploadsPerStream, uploadThreadPool, tempFileCreator);
        return new S3RecoverableWriter(s3AccessHelper, uploadFactory, tempFileCreator, userDefinedMinPartSize);
    }
}

