/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.s3base.shaded.com.amazonaws.http;

import org.apache.flink.fs.s3base.shaded.com.amazonaws.AmazonServiceException;
import org.apache.flink.fs.s3base.shaded.com.amazonaws.annotation.SdkInternalApi;
import org.apache.flink.fs.s3base.shaded.com.amazonaws.http.HttpResponse;
import org.apache.flink.fs.s3base.shaded.com.amazonaws.http.HttpResponseHandler;
import org.apache.flink.fs.s3base.shaded.com.amazonaws.util.AWSRequestMetrics;

@SdkInternalApi
class AwsErrorResponseHandler
implements HttpResponseHandler<AmazonServiceException> {
    private final HttpResponseHandler<AmazonServiceException> delegate;
    private final AWSRequestMetrics awsRequestMetrics;

    AwsErrorResponseHandler(HttpResponseHandler<AmazonServiceException> errorResponseHandler, AWSRequestMetrics awsRequestMetrics) {
        this.delegate = errorResponseHandler;
        this.awsRequestMetrics = awsRequestMetrics;
    }

    @Override
    public AmazonServiceException handle(HttpResponse response) throws Exception {
        AmazonServiceException ase = this.handleAse(response);
        ase.setStatusCode(response.getStatusCode());
        ase.setServiceName(response.getRequest().getServiceName());
        this.awsRequestMetrics.addPropertyWith(AWSRequestMetrics.Field.AWSRequestID, (Object)ase.getRequestId()).addPropertyWith(AWSRequestMetrics.Field.AWSErrorCode, (Object)ase.getErrorCode()).addPropertyWith(AWSRequestMetrics.Field.StatusCode, (Object)ase.getStatusCode());
        return ase;
    }

    private AmazonServiceException handleAse(HttpResponse response) throws Exception {
        int statusCode = response.getStatusCode();
        try {
            return this.delegate.handle(response);
        }
        catch (InterruptedException e) {
            throw e;
        }
        catch (Exception e) {
            if (statusCode == 413) {
                AmazonServiceException exception = new AmazonServiceException("Request entity too large");
                exception.setServiceName(response.getRequest().getServiceName());
                exception.setStatusCode(statusCode);
                exception.setErrorType(AmazonServiceException.ErrorType.Client);
                exception.setErrorCode("Request entity too large");
                return exception;
            }
            if (statusCode >= 500 && statusCode < 600) {
                AmazonServiceException exception = new AmazonServiceException(response.getStatusText());
                exception.setServiceName(response.getRequest().getServiceName());
                exception.setStatusCode(statusCode);
                exception.setErrorType(AmazonServiceException.ErrorType.Service);
                exception.setErrorCode(response.getStatusText());
                return exception;
            }
            throw e;
        }
    }

    @Override
    public boolean needsConnectionLeftOpen() {
        return this.delegate.needsConnectionLeftOpen();
    }
}

