/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.s3base.shaded.com.amazonaws.services.dynamodbv2.datamodeling;

import org.apache.flink.fs.s3base.shaded.com.amazonaws.annotation.SdkInternalApi;

public interface DynamoDBTypeConverter<S, T> {
    public S convert(T var1);

    public T unconvert(S var1);

    public static class NullSafeConverter<S, T>
    extends DelegateConverter<S, T> {
        public NullSafeConverter(DynamoDBTypeConverter<S, T> delegate) {
            super(delegate);
        }

        @Override
        public S convert(T object) {
            return object == null ? null : (S)super.convert(object);
        }

        @Override
        public T unconvert(S object) {
            return object == null ? null : (T)super.unconvert(object);
        }
    }

    public static class DelegateConverter<S, T>
    extends AbstractConverter<S, T> {
        private final DynamoDBTypeConverter<S, T> delegate;

        public DelegateConverter(DynamoDBTypeConverter<S, T> delegate) {
            this.delegate = delegate;
        }

        @Override
        public S convert(T object) {
            return this.delegate.convert(object);
        }

        @Override
        public T unconvert(S object) {
            return this.delegate.unconvert(object);
        }
    }

    public static class ExtendedConverter<S, U, T>
    extends AbstractConverter<S, T> {
        private final DynamoDBTypeConverter<S, U> source;
        private final DynamoDBTypeConverter<U, T> target;

        public ExtendedConverter(DynamoDBTypeConverter<S, U> source, DynamoDBTypeConverter<U, T> target) {
            this.source = source;
            this.target = target;
        }

        @Override
        public S convert(T o) {
            return this.source.convert(this.target.convert(o));
        }

        @Override
        public T unconvert(S o) {
            return this.target.unconvert(this.source.unconvert(o));
        }
    }

    @SdkInternalApi
    public static abstract class AbstractConverter<S, T>
    implements DynamoDBTypeConverter<S, T> {
        public static <S, U, T> ExtendedConverter<S, U, T> join(DynamoDBTypeConverter<S, U> source, DynamoDBTypeConverter<U, T> target) {
            return new ExtendedConverter<S, U, T>(source, target);
        }

        public static <S, T> NullSafeConverter<S, T> nullSafe(DynamoDBTypeConverter<S, T> converter) {
            return new NullSafeConverter<S, T>(converter);
        }

        public <U> DynamoDBTypeConverter<S, U> joinAll(DynamoDBTypeConverter<T, U> ... targets) {
            AbstractConverter converter = this.nullSafe();
            for (DynamoDBTypeConverter<U, U> dynamoDBTypeConverter : targets) {
                if (dynamoDBTypeConverter == null) continue;
                converter = converter.join(AbstractConverter.nullSafe(dynamoDBTypeConverter));
            }
            return converter;
        }

        public <U> ExtendedConverter<S, T, U> join(DynamoDBTypeConverter<T, U> target) {
            return AbstractConverter.join(this, target);
        }

        public NullSafeConverter<S, T> nullSafe() {
            return AbstractConverter.nullSafe(this);
        }
    }
}

