/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.s3base.shaded.com.amazonaws.services.dynamodbv2.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.flink.fs.s3base.shaded.com.amazonaws.AmazonWebServiceResult;
import org.apache.flink.fs.s3base.shaded.com.amazonaws.ResponseMetadata;
import org.apache.flink.fs.s3base.shaded.com.amazonaws.services.dynamodbv2.model.Record;

public class GetRecordsResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private List<Record> records;
    private String nextShardIterator;

    public List<Record> getRecords() {
        return this.records;
    }

    public void setRecords(Collection<Record> records) {
        if (records == null) {
            this.records = null;
            return;
        }
        this.records = new ArrayList<Record>(records);
    }

    public GetRecordsResult withRecords(Record ... records) {
        if (this.records == null) {
            this.setRecords(new ArrayList<Record>(records.length));
        }
        for (Record ele : records) {
            this.records.add(ele);
        }
        return this;
    }

    public GetRecordsResult withRecords(Collection<Record> records) {
        this.setRecords(records);
        return this;
    }

    public void setNextShardIterator(String nextShardIterator) {
        this.nextShardIterator = nextShardIterator;
    }

    public String getNextShardIterator() {
        return this.nextShardIterator;
    }

    public GetRecordsResult withNextShardIterator(String nextShardIterator) {
        this.setNextShardIterator(nextShardIterator);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getRecords() != null) {
            sb.append("Records: ").append(this.getRecords()).append(",");
        }
        if (this.getNextShardIterator() != null) {
            sb.append("NextShardIterator: ").append(this.getNextShardIterator());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetRecordsResult)) {
            return false;
        }
        GetRecordsResult other = (GetRecordsResult)obj;
        if (other.getRecords() == null ^ this.getRecords() == null) {
            return false;
        }
        if (other.getRecords() != null && !other.getRecords().equals(this.getRecords())) {
            return false;
        }
        if (other.getNextShardIterator() == null ^ this.getNextShardIterator() == null) {
            return false;
        }
        return other.getNextShardIterator() == null || other.getNextShardIterator().equals(this.getNextShardIterator());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getRecords() == null ? 0 : this.getRecords().hashCode());
        hashCode = 31 * hashCode + (this.getNextShardIterator() == null ? 0 : this.getNextShardIterator().hashCode());
        return hashCode;
    }

    public GetRecordsResult clone() {
        try {
            return (GetRecordsResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

