/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.s3base.shaded.com.amazonaws.services.dynamodbv2.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.flink.fs.s3base.shaded.com.amazonaws.annotation.SdkInternalApi;
import org.apache.flink.fs.s3base.shaded.com.amazonaws.protocol.ProtocolMarshaller;
import org.apache.flink.fs.s3base.shaded.com.amazonaws.protocol.StructuredPojo;
import org.apache.flink.fs.s3base.shaded.com.amazonaws.services.dynamodbv2.model.KeySchemaElement;
import org.apache.flink.fs.s3base.shaded.com.amazonaws.services.dynamodbv2.model.Projection;
import org.apache.flink.fs.s3base.shaded.com.amazonaws.services.dynamodbv2.model.transform.LocalSecondaryIndexDescriptionMarshaller;

public class LocalSecondaryIndexDescription
implements Serializable,
Cloneable,
StructuredPojo {
    private String indexName;
    private List<KeySchemaElement> keySchema;
    private Projection projection;
    private Long indexSizeBytes;
    private Long itemCount;
    private String indexArn;

    public void setIndexName(String indexName) {
        this.indexName = indexName;
    }

    public String getIndexName() {
        return this.indexName;
    }

    public LocalSecondaryIndexDescription withIndexName(String indexName) {
        this.setIndexName(indexName);
        return this;
    }

    public List<KeySchemaElement> getKeySchema() {
        return this.keySchema;
    }

    public void setKeySchema(Collection<KeySchemaElement> keySchema) {
        if (keySchema == null) {
            this.keySchema = null;
            return;
        }
        this.keySchema = new ArrayList<KeySchemaElement>(keySchema);
    }

    public LocalSecondaryIndexDescription withKeySchema(KeySchemaElement ... keySchema) {
        if (this.keySchema == null) {
            this.setKeySchema(new ArrayList<KeySchemaElement>(keySchema.length));
        }
        for (KeySchemaElement ele : keySchema) {
            this.keySchema.add(ele);
        }
        return this;
    }

    public LocalSecondaryIndexDescription withKeySchema(Collection<KeySchemaElement> keySchema) {
        this.setKeySchema(keySchema);
        return this;
    }

    public void setProjection(Projection projection) {
        this.projection = projection;
    }

    public Projection getProjection() {
        return this.projection;
    }

    public LocalSecondaryIndexDescription withProjection(Projection projection) {
        this.setProjection(projection);
        return this;
    }

    public void setIndexSizeBytes(Long indexSizeBytes) {
        this.indexSizeBytes = indexSizeBytes;
    }

    public Long getIndexSizeBytes() {
        return this.indexSizeBytes;
    }

    public LocalSecondaryIndexDescription withIndexSizeBytes(Long indexSizeBytes) {
        this.setIndexSizeBytes(indexSizeBytes);
        return this;
    }

    public void setItemCount(Long itemCount) {
        this.itemCount = itemCount;
    }

    public Long getItemCount() {
        return this.itemCount;
    }

    public LocalSecondaryIndexDescription withItemCount(Long itemCount) {
        this.setItemCount(itemCount);
        return this;
    }

    public void setIndexArn(String indexArn) {
        this.indexArn = indexArn;
    }

    public String getIndexArn() {
        return this.indexArn;
    }

    public LocalSecondaryIndexDescription withIndexArn(String indexArn) {
        this.setIndexArn(indexArn);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getIndexName() != null) {
            sb.append("IndexName: ").append(this.getIndexName()).append(",");
        }
        if (this.getKeySchema() != null) {
            sb.append("KeySchema: ").append(this.getKeySchema()).append(",");
        }
        if (this.getProjection() != null) {
            sb.append("Projection: ").append(this.getProjection()).append(",");
        }
        if (this.getIndexSizeBytes() != null) {
            sb.append("IndexSizeBytes: ").append(this.getIndexSizeBytes()).append(",");
        }
        if (this.getItemCount() != null) {
            sb.append("ItemCount: ").append(this.getItemCount()).append(",");
        }
        if (this.getIndexArn() != null) {
            sb.append("IndexArn: ").append(this.getIndexArn());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LocalSecondaryIndexDescription)) {
            return false;
        }
        LocalSecondaryIndexDescription other = (LocalSecondaryIndexDescription)obj;
        if (other.getIndexName() == null ^ this.getIndexName() == null) {
            return false;
        }
        if (other.getIndexName() != null && !other.getIndexName().equals(this.getIndexName())) {
            return false;
        }
        if (other.getKeySchema() == null ^ this.getKeySchema() == null) {
            return false;
        }
        if (other.getKeySchema() != null && !other.getKeySchema().equals(this.getKeySchema())) {
            return false;
        }
        if (other.getProjection() == null ^ this.getProjection() == null) {
            return false;
        }
        if (other.getProjection() != null && !other.getProjection().equals(this.getProjection())) {
            return false;
        }
        if (other.getIndexSizeBytes() == null ^ this.getIndexSizeBytes() == null) {
            return false;
        }
        if (other.getIndexSizeBytes() != null && !other.getIndexSizeBytes().equals(this.getIndexSizeBytes())) {
            return false;
        }
        if (other.getItemCount() == null ^ this.getItemCount() == null) {
            return false;
        }
        if (other.getItemCount() != null && !other.getItemCount().equals(this.getItemCount())) {
            return false;
        }
        if (other.getIndexArn() == null ^ this.getIndexArn() == null) {
            return false;
        }
        return other.getIndexArn() == null || other.getIndexArn().equals(this.getIndexArn());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getIndexName() == null ? 0 : this.getIndexName().hashCode());
        hashCode = 31 * hashCode + (this.getKeySchema() == null ? 0 : this.getKeySchema().hashCode());
        hashCode = 31 * hashCode + (this.getProjection() == null ? 0 : this.getProjection().hashCode());
        hashCode = 31 * hashCode + (this.getIndexSizeBytes() == null ? 0 : this.getIndexSizeBytes().hashCode());
        hashCode = 31 * hashCode + (this.getItemCount() == null ? 0 : this.getItemCount().hashCode());
        hashCode = 31 * hashCode + (this.getIndexArn() == null ? 0 : this.getIndexArn().hashCode());
        return hashCode;
    }

    public LocalSecondaryIndexDescription clone() {
        try {
            return (LocalSecondaryIndexDescription)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        LocalSecondaryIndexDescriptionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

