/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.s3base.shaded.com.amazonaws.services.s3.transfer.internal;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.apache.flink.fs.s3base.shaded.com.amazonaws.AmazonClientException;
import org.apache.flink.fs.s3base.shaded.com.amazonaws.AmazonServiceException;
import org.apache.flink.fs.s3base.shaded.com.amazonaws.event.ProgressListenerChain;
import org.apache.flink.fs.s3base.shaded.com.amazonaws.services.s3.transfer.PauseResult;
import org.apache.flink.fs.s3base.shaded.com.amazonaws.services.s3.transfer.PauseStatus;
import org.apache.flink.fs.s3base.shaded.com.amazonaws.services.s3.transfer.PersistableUpload;
import org.apache.flink.fs.s3base.shaded.com.amazonaws.services.s3.transfer.TransferProgress;
import org.apache.flink.fs.s3base.shaded.com.amazonaws.services.s3.transfer.Upload;
import org.apache.flink.fs.s3base.shaded.com.amazonaws.services.s3.transfer.exception.PauseException;
import org.apache.flink.fs.s3base.shaded.com.amazonaws.services.s3.transfer.internal.AbstractTransfer;
import org.apache.flink.fs.s3base.shaded.com.amazonaws.services.s3.transfer.internal.TransferStateChangeListener;
import org.apache.flink.fs.s3base.shaded.com.amazonaws.services.s3.transfer.internal.UploadMonitor;
import org.apache.flink.fs.s3base.shaded.com.amazonaws.services.s3.transfer.model.UploadResult;

public class UploadImpl
extends AbstractTransfer
implements Upload {
    public UploadImpl(String description, TransferProgress transferProgressInternalState, ProgressListenerChain progressListenerChain, TransferStateChangeListener listener) {
        super(description, transferProgressInternalState, progressListenerChain, listener);
    }

    @Override
    public UploadResult waitForUploadResult() throws AmazonClientException, AmazonServiceException, InterruptedException {
        try {
            UploadResult result = null;
            while (!this.monitor.isDone() || result == null) {
                Future<?> f = this.monitor.getFuture();
                result = (UploadResult)f.get();
            }
            return result;
        }
        catch (ExecutionException e) {
            this.rethrowExecutionException(e);
            return null;
        }
    }

    @Override
    public PersistableUpload pause() throws PauseException {
        PauseResult<PersistableUpload> pauseResult = this.pause(true);
        if (pauseResult.getPauseStatus() != PauseStatus.SUCCESS) {
            throw new PauseException(pauseResult.getPauseStatus());
        }
        return pauseResult.getInfoToResume();
    }

    private PauseResult<PersistableUpload> pause(boolean forceCancelTransfers) throws AmazonClientException {
        UploadMonitor uploadMonitor = (UploadMonitor)this.monitor;
        return uploadMonitor.pause(forceCancelTransfers);
    }

    @Override
    public PauseResult<PersistableUpload> tryPause(boolean forceCancelTransfers) {
        return this.pause(forceCancelTransfers);
    }

    @Override
    public void abort() {
        UploadMonitor uploadMonitor = (UploadMonitor)this.monitor;
        uploadMonitor.performAbort();
    }
}

