/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.s3base.shaded.org.apache.http.message;

import java.io.Serializable;
import org.apache.flink.fs.s3base.shaded.org.apache.http.ProtocolVersion;
import org.apache.flink.fs.s3base.shaded.org.apache.http.RequestLine;
import org.apache.flink.fs.s3base.shaded.org.apache.http.annotation.Contract;
import org.apache.flink.fs.s3base.shaded.org.apache.http.annotation.ThreadingBehavior;
import org.apache.flink.fs.s3base.shaded.org.apache.http.message.BasicLineFormatter;
import org.apache.flink.fs.s3base.shaded.org.apache.http.util.Args;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class BasicRequestLine
implements RequestLine,
Cloneable,
Serializable {
    private static final long serialVersionUID = 2810581718468737193L;
    private final ProtocolVersion protoversion;
    private final String method;
    private final String uri;

    public BasicRequestLine(String method, String uri, ProtocolVersion version) {
        this.method = Args.notNull(method, "Method");
        this.uri = Args.notNull(uri, "URI");
        this.protoversion = Args.notNull(version, "Version");
    }

    @Override
    public String getMethod() {
        return this.method;
    }

    @Override
    public ProtocolVersion getProtocolVersion() {
        return this.protoversion;
    }

    @Override
    public String getUri() {
        return this.uri;
    }

    public String toString() {
        return BasicLineFormatter.INSTANCE.formatRequestLine(null, this).toString();
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

