/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.s3a;

import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.classification.InterfaceAudience;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.classification.InterfaceStability;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.FileStatus;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.Path;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.s3a.Tristate;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class S3AFileStatus
extends FileStatus {
    private Tristate isEmptyDirectory;

    public S3AFileStatus(boolean isemptydir, Path path, String owner) {
        this(Tristate.fromBool(isemptydir), path, owner);
    }

    public S3AFileStatus(Tristate isemptydir, Path path, String owner) {
        super(0L, true, 1, 0L, 0L, path);
        this.isEmptyDirectory = isemptydir;
        this.setOwner(owner);
        this.setGroup(owner);
    }

    public S3AFileStatus(long length, long modification_time, Path path, long blockSize, String owner) {
        super(length, false, 1, blockSize, modification_time, path);
        this.isEmptyDirectory = Tristate.FALSE;
        this.setOwner(owner);
        this.setGroup(owner);
    }

    public static S3AFileStatus fromFileStatus(FileStatus source, Tristate isEmptyDirectory) {
        if (source.isDirectory()) {
            return new S3AFileStatus(isEmptyDirectory, source.getPath(), source.getOwner());
        }
        return new S3AFileStatus(source.getLen(), source.getModificationTime(), source.getPath(), source.getBlockSize(), source.getOwner());
    }

    public Tristate isEmptyDirectory() {
        return this.isEmptyDirectory;
    }

    @Override
    public boolean equals(Object o) {
        return super.equals(o);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public long getModificationTime() {
        if (this.isDirectory()) {
            return System.currentTimeMillis();
        }
        return super.getModificationTime();
    }

    @Override
    public String toString() {
        return super.toString() + String.format(" isEmptyDirectory=%s", this.isEmptyDirectory().name());
    }
}

