/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.s3a;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.net.URI;
import java.nio.file.AccessDeniedException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nullable;
import org.apache.flink.fs.s3base.shaded.com.amazonaws.AmazonClientException;
import org.apache.flink.fs.s3base.shaded.com.amazonaws.AmazonServiceException;
import org.apache.flink.fs.s3base.shaded.com.amazonaws.SdkBaseException;
import org.apache.flink.fs.s3base.shaded.com.amazonaws.event.ProgressListener;
import org.apache.flink.fs.s3base.shaded.com.amazonaws.services.s3.AmazonS3;
import org.apache.flink.fs.s3base.shaded.com.amazonaws.services.s3.model.AbortMultipartUploadRequest;
import org.apache.flink.fs.s3base.shaded.com.amazonaws.services.s3.model.CannedAccessControlList;
import org.apache.flink.fs.s3base.shaded.com.amazonaws.services.s3.model.CopyObjectRequest;
import org.apache.flink.fs.s3base.shaded.com.amazonaws.services.s3.model.DeleteObjectsRequest;
import org.apache.flink.fs.s3base.shaded.com.amazonaws.services.s3.model.GetObjectMetadataRequest;
import org.apache.flink.fs.s3base.shaded.com.amazonaws.services.s3.model.InitiateMultipartUploadRequest;
import org.apache.flink.fs.s3base.shaded.com.amazonaws.services.s3.model.InitiateMultipartUploadResult;
import org.apache.flink.fs.s3base.shaded.com.amazonaws.services.s3.model.ListMultipartUploadsRequest;
import org.apache.flink.fs.s3base.shaded.com.amazonaws.services.s3.model.ListObjectsRequest;
import org.apache.flink.fs.s3base.shaded.com.amazonaws.services.s3.model.ListObjectsV2Request;
import org.apache.flink.fs.s3base.shaded.com.amazonaws.services.s3.model.MultiObjectDeleteException;
import org.apache.flink.fs.s3base.shaded.com.amazonaws.services.s3.model.MultipartUpload;
import org.apache.flink.fs.s3base.shaded.com.amazonaws.services.s3.model.ObjectMetadata;
import org.apache.flink.fs.s3base.shaded.com.amazonaws.services.s3.model.PutObjectRequest;
import org.apache.flink.fs.s3base.shaded.com.amazonaws.services.s3.model.PutObjectResult;
import org.apache.flink.fs.s3base.shaded.com.amazonaws.services.s3.model.S3ObjectSummary;
import org.apache.flink.fs.s3base.shaded.com.amazonaws.services.s3.model.SSEAwsKeyManagementParams;
import org.apache.flink.fs.s3base.shaded.com.amazonaws.services.s3.model.SSECustomerKey;
import org.apache.flink.fs.s3base.shaded.com.amazonaws.services.s3.model.UploadPartRequest;
import org.apache.flink.fs.s3base.shaded.com.amazonaws.services.s3.model.UploadPartResult;
import org.apache.flink.fs.s3base.shaded.com.amazonaws.services.s3.transfer.Copy;
import org.apache.flink.fs.s3base.shaded.com.amazonaws.services.s3.transfer.TransferManager;
import org.apache.flink.fs.s3base.shaded.com.amazonaws.services.s3.transfer.TransferManagerConfiguration;
import org.apache.flink.fs.s3base.shaded.com.amazonaws.services.s3.transfer.Upload;
import org.apache.flink.fs.s3base.shaded.com.amazonaws.services.s3.transfer.model.UploadResult;
import org.apache.flink.fs.s3base.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.flink.fs.s3base.shaded.com.google.common.base.Preconditions;
import org.apache.flink.fs.s3base.shaded.com.google.common.util.concurrent.ListeningExecutorService;
import org.apache.flink.fs.shaded.hadoop3.org.apache.commons.io.IOUtils;
import org.apache.flink.fs.shaded.hadoop3.org.apache.commons.lang.StringUtils;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.classification.InterfaceAudience;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.classification.InterfaceStability;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.conf.Configuration;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.CreateFlag;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.FSDataInputStream;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.FileAlreadyExistsException;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.FileStatus;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.FileSystem;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.GlobalStorageStatistics;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.InvalidRequestException;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.LocalDirAllocator;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.LocalFileSystem;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.Path;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.PathFilter;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.PathIOException;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.PathIsNotEmptyDirectoryException;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.RemoteIterator;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.StreamCapabilities;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.permission.FsPermission;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.s3a.Constants;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.s3a.Invoker;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.s3a.Listing;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.s3a.MultipartUtils;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.s3a.ProgressableProgressListener;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.s3a.RenameFailedException;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.s3a.S3ABlockOutputStream;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.s3a.S3ADataBlocks;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.s3a.S3AEncryptionMethods;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.s3a.S3AFileStatus;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.s3a.S3AInputPolicy;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.s3a.S3AInputStream;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.s3a.S3AInstrumentation;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.s3a.S3AReadOpContext;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.s3a.S3ARetryPolicy;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.s3a.S3AStorageStatistics;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.s3a.S3AUtils;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.s3a.S3ClientFactory;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.s3a.S3GuardExistsRetryPolicy;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.s3a.S3ListRequest;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.s3a.S3ListResult;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.s3a.S3ObjectAttributes;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.s3a.Statistic;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.s3a.Tristate;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.s3a.UploadInfo;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.s3a.WriteOperationHelper;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.s3a.commit.MagicCommitIntegration;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.s3a.commit.PutTracker;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.s3a.s3guard.DirListingMetadata;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.s3a.s3guard.MetadataStore;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.s3a.s3guard.MetadataStoreListFilesIterator;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.s3a.s3guard.PathMetadata;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.s3a.s3guard.S3Guard;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.s3native.S3xLoginHelper;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.store.EtagChecksum;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.io.retry.RetryPolicies;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.security.UserGroupInformation;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.util.BlockingThreadPoolExecutorService;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.util.Progressable;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.util.ReflectionUtils;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.util.SemaphoredDelegatingExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class S3AFileSystem
extends FileSystem
implements StreamCapabilities {
    public static final int DEFAULT_BLOCKSIZE = 0x2000000;
    public static final boolean DELETE_CONSIDERED_IDEMPOTENT = true;
    private URI uri;
    private Path workingDir;
    private String username;
    private AmazonS3 s3;
    private Invoker invoker = new Invoker(RetryPolicies.TRY_ONCE_THEN_FAIL, Invoker.LOG_EVENT);
    private Invoker s3guardInvoker = new Invoker(RetryPolicies.TRY_ONCE_THEN_FAIL, Invoker.LOG_EVENT);
    private final Invoker.Retried onRetry = this::operationRetried;
    private String bucket;
    private int maxKeys;
    private Listing listing;
    private long partSize;
    private boolean enableMultiObjectsDelete;
    private TransferManager transfers;
    private ListeningExecutorService boundedThreadPool;
    private ExecutorService unboundedThreadPool;
    private long multiPartThreshold;
    public static final Logger LOG = LoggerFactory.getLogger(S3AFileSystem.class);
    private static final Logger PROGRESS = LoggerFactory.getLogger((String)"org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.s3a.S3AFileSystem.Progress");
    private LocalDirAllocator directoryAllocator;
    private CannedAccessControlList cannedACL;
    private S3AEncryptionMethods serverSideEncryptionAlgorithm;
    private S3AInstrumentation instrumentation;
    private final S3AStorageStatistics storageStatistics = S3AFileSystem.createStorageStatistics();
    private long readAhead;
    private S3AInputPolicy inputPolicy;
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private volatile boolean isClosed = false;
    private MetadataStore metadataStore;
    private boolean allowAuthoritative;
    private static final int MAX_ENTRIES_TO_DELETE = 1000;
    private String blockOutputBuffer;
    private S3ADataBlocks.BlockFactory blockFactory;
    private int blockOutputActiveBlocks;
    private WriteOperationHelper writeHelper;
    private boolean useListV1;
    private MagicCommitIntegration committerIntegration;

    private static void addDeprecatedKeys() {
        Configuration.addDeprecations(new Configuration.DeprecationDelta[]{new Configuration.DeprecationDelta("fs.s3a.server-side-encryption-key", "fs.s3a.server-side-encryption.key")});
        Configuration.reloadExistingConfigurations();
    }

    @Override
    public void initialize(URI name, Configuration originalConf) throws IOException {
        this.setUri(name);
        this.bucket = name.getHost();
        LOG.debug("Initializing S3AFileSystem for {}", (Object)this.bucket);
        Configuration conf = S3AUtils.propagateBucketOptions(originalConf, this.bucket);
        S3AUtils.patchSecurityCredentialProviders(conf);
        super.initialize(name, conf);
        this.setConf(conf);
        try {
            this.instrumentation = new S3AInstrumentation(name);
            this.username = UserGroupInformation.getCurrentUser().getShortUserName();
            this.workingDir = new Path("/user", this.username).makeQualified(this.uri, this.getWorkingDirectory());
            Class<S3ClientFactory> s3ClientFactoryClass = conf.getClass("fs.s3a.s3.client.factory.impl", Constants.DEFAULT_S3_CLIENT_FACTORY_IMPL, S3ClientFactory.class);
            this.s3 = ReflectionUtils.newInstance(s3ClientFactoryClass, conf).createS3Client(name);
            this.invoker = new Invoker(new S3ARetryPolicy(this.getConf()), this.onRetry);
            this.s3guardInvoker = new Invoker(new S3GuardExistsRetryPolicy(this.getConf()), this.onRetry);
            this.writeHelper = new WriteOperationHelper(this, this.getConf());
            this.maxKeys = S3AUtils.intOption(conf, "fs.s3a.paging.maximum", 5000, 1);
            this.listing = new Listing(this);
            this.partSize = S3AUtils.getMultipartSizeProperty(conf, "fs.s3a.multipart.size", 0x6400000L);
            this.multiPartThreshold = S3AUtils.getMultipartSizeProperty(conf, "fs.s3a.multipart.threshold", Integer.MAX_VALUE);
            S3AUtils.longBytesOption(conf, "fs.s3a.block.size", 0x2000000L, 1L);
            this.enableMultiObjectsDelete = conf.getBoolean("fs.s3a.multiobjectdelete.enable", true);
            this.readAhead = S3AUtils.longBytesOption(conf, "fs.s3a.readahead.range", 65536L, 0L);
            int maxThreads = conf.getInt("fs.s3a.threads.max", 10);
            if (maxThreads < 2) {
                LOG.warn("fs.s3a.threads.max must be at least 2: forcing to 2.");
                maxThreads = 2;
            }
            int totalTasks = S3AUtils.intOption(conf, "fs.s3a.max.total.tasks", 5, 1);
            long keepAliveTime = S3AUtils.longOption(conf, "fs.s3a.threads.keepalivetime", 60L, 0L);
            this.boundedThreadPool = BlockingThreadPoolExecutorService.newInstance(maxThreads, maxThreads + totalTasks, keepAliveTime, TimeUnit.SECONDS, "s3a-transfer-shared");
            this.unboundedThreadPool = new ThreadPoolExecutor(maxThreads, Integer.MAX_VALUE, keepAliveTime, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), BlockingThreadPoolExecutorService.newDaemonThreadFactory("s3a-transfer-unbounded"));
            int listVersion = conf.getInt("fs.s3a.list.version", 2);
            if (listVersion < 1 || listVersion > 2) {
                LOG.warn("Configured fs.s3a.list.version {} is invalid, forcing version 2", (Object)listVersion);
            }
            this.useListV1 = listVersion == 1;
            this.initTransferManager();
            this.initCannedAcls(conf);
            this.verifyBucketExists();
            this.serverSideEncryptionAlgorithm = S3AUtils.getEncryptionAlgorithm(this.bucket, conf);
            this.inputPolicy = S3AInputPolicy.getPolicy(conf.getTrimmed("fs.s3a.experimental.input.fadvise", "normal"));
            LOG.debug("Input fadvise policy = {}", (Object)this.inputPolicy);
            boolean magicCommitterEnabled = conf.getBoolean("fs.s3a.committer.magic.enabled", false);
            LOG.debug("Filesystem support for magic committers {} enabled", (Object)(magicCommitterEnabled ? "is" : "is not"));
            this.committerIntegration = new MagicCommitIntegration(this, magicCommitterEnabled);
            boolean blockUploadEnabled = conf.getBoolean("fs.s3a.fast.upload", true);
            if (!blockUploadEnabled) {
                LOG.warn("The \"slow\" output stream is no longer supported");
            }
            this.blockOutputBuffer = conf.getTrimmed("fs.s3a.fast.upload.buffer", "disk");
            this.partSize = S3AUtils.ensureOutputParameterInRange("fs.s3a.multipart.size", this.partSize);
            this.blockFactory = S3ADataBlocks.createFactory(this, this.blockOutputBuffer);
            this.blockOutputActiveBlocks = S3AUtils.intOption(conf, "fs.s3a.fast.upload.active.blocks", 4, 1);
            LOG.debug("Using S3ABlockOutputStream with buffer = {}; block={}; queue limit={}", new Object[]{this.blockOutputBuffer, this.partSize, this.blockOutputActiveBlocks});
            this.setMetadataStore(S3Guard.getMetadataStore(this));
            this.allowAuthoritative = conf.getBoolean("fs.s3a.metadatastore.authoritative", false);
            if (this.hasMetadataStore()) {
                LOG.debug("Using metadata store {}, authoritative={}", (Object)this.getMetadataStore(), (Object)this.allowAuthoritative);
            }
            this.initMultipartUploads(conf);
        }
        catch (AmazonClientException e) {
            throw S3AUtils.translateException("initializing ", new Path(name), e);
        }
    }

    protected static S3AStorageStatistics createStorageStatistics() {
        return (S3AStorageStatistics)GlobalStorageStatistics.INSTANCE.put("S3AStorageStatistics", () -> new S3AStorageStatistics());
    }

    protected void verifyBucketExists() throws FileNotFoundException, IOException {
        if (!this.invoker.retry("doesBucketExist", this.bucket, true, () -> this.s3.doesBucketExist(this.bucket)).booleanValue()) {
            throw new FileNotFoundException("Bucket " + this.bucket + " does not exist");
        }
    }

    public S3AInstrumentation getInstrumentation() {
        return this.instrumentation;
    }

    private void initTransferManager() {
        TransferManagerConfiguration transferConfiguration = new TransferManagerConfiguration();
        transferConfiguration.setMinimumUploadPartSize(this.partSize);
        transferConfiguration.setMultipartUploadThreshold(this.multiPartThreshold);
        transferConfiguration.setMultipartCopyPartSize(this.partSize);
        transferConfiguration.setMultipartCopyThreshold(this.multiPartThreshold);
        this.transfers = new TransferManager(this.s3, this.unboundedThreadPool);
        this.transfers.setConfiguration(transferConfiguration);
    }

    private void initCannedAcls(Configuration conf) {
        String cannedACLName = conf.get("fs.s3a.acl.default", "");
        this.cannedACL = !cannedACLName.isEmpty() ? CannedAccessControlList.valueOf(cannedACLName) : null;
    }

    private void initMultipartUploads(Configuration conf) throws IOException {
        boolean purgeExistingMultipart = conf.getBoolean("fs.s3a.multipart.purge", false);
        long purgeExistingMultipartAge = S3AUtils.longOption(conf, "fs.s3a.multipart.purge.age", 86400L, 0L);
        if (purgeExistingMultipart) {
            try {
                this.abortOutstandingMultipartUploads(purgeExistingMultipartAge);
            }
            catch (AccessDeniedException e) {
                this.instrumentation.errorIgnored();
                LOG.debug("Failed to purge multipart uploads against {}, FS may be read only", (Object)this.bucket);
            }
        }
    }

    public void abortOutstandingMultipartUploads(long seconds) throws IOException {
        Preconditions.checkArgument(seconds >= 0L);
        Date purgeBefore = new Date(new Date().getTime() - seconds * 1000L);
        LOG.debug("Purging outstanding multipart uploads older than {}", (Object)purgeBefore);
        this.invoker.retry("Purging multipart uploads", this.bucket, true, () -> this.transfers.abortMultipartUploads(this.bucket, purgeBefore));
    }

    @Override
    public String getScheme() {
        return "s3a";
    }

    @Override
    public URI getUri() {
        return this.uri;
    }

    @VisibleForTesting
    protected void setUri(URI uri) {
        this.uri = S3xLoginHelper.buildFSURI(uri);
    }

    @Override
    public int getDefaultPort() {
        return -1;
    }

    AmazonS3 getAmazonS3Client() {
        return this.s3;
    }

    @VisibleForTesting
    public AmazonS3 getAmazonS3ClientForTesting(String reason) {
        LOG.warn("Access to S3A client requested, reason {}", (Object)reason);
        return this.s3;
    }

    protected void setAmazonS3Client(AmazonS3 client) {
        Preconditions.checkNotNull(client, "client");
        LOG.debug("Setting S3 client to {}", (Object)client);
        this.s3 = client;
    }

    public String getBucketLocation() throws IOException {
        return this.getBucketLocation(this.bucket);
    }

    public String getBucketLocation(String bucketName) throws IOException {
        return this.invoker.retry("getBucketLocation()", bucketName, true, () -> this.s3.getBucketLocation(bucketName));
    }

    @VisibleForTesting
    long getReadAheadRange() {
        return this.readAhead;
    }

    @InterfaceStability.Unstable
    public S3AInputPolicy getInputPolicy() {
        return this.inputPolicy;
    }

    public S3AEncryptionMethods getServerSideEncryptionAlgorithm() {
        return this.serverSideEncryptionAlgorithm;
    }

    synchronized File createTmpFileForWrite(String pathStr, long size, Configuration conf) throws IOException {
        if (this.directoryAllocator == null) {
            String bufferDir = conf.get("fs.s3a.buffer.dir") != null ? "fs.s3a.buffer.dir" : "hadoop.tmp.dir";
            this.directoryAllocator = new LocalDirAllocator(bufferDir);
        }
        return this.directoryAllocator.createTmpFileForWrite(pathStr, size, conf);
    }

    public String getBucket() {
        return this.bucket;
    }

    @VisibleForTesting
    protected void setBucket(String bucket) {
        this.bucket = bucket;
    }

    CannedAccessControlList getCannedACL() {
        return this.cannedACL;
    }

    @InterfaceStability.Unstable
    public void setInputPolicy(S3AInputPolicy inputPolicy) {
        Objects.requireNonNull(inputPolicy, "Null inputStrategy");
        LOG.debug("Setting input strategy: {}", (Object)inputPolicy);
        this.inputPolicy = inputPolicy;
    }

    @VisibleForTesting
    public String pathToKey(Path path) {
        if (!path.isAbsolute()) {
            path = new Path(this.workingDir, path);
        }
        if (path.toUri().getScheme() != null && path.toUri().getPath().isEmpty()) {
            return "";
        }
        return path.toUri().getPath().substring(1);
    }

    private String maybeAddTrailingSlash(String key) {
        if (!key.isEmpty() && !key.endsWith("/")) {
            return key + '/';
        }
        return key;
    }

    Path keyToPath(String key) {
        return new Path("/" + key);
    }

    public Path keyToQualifiedPath(String key) {
        return this.qualify(this.keyToPath(key));
    }

    public Path qualify(Path path) {
        return path.makeQualified(this.uri, this.workingDir);
    }

    @Override
    public void checkPath(Path path) {
        S3xLoginHelper.checkPath(this.getConf(), this.getUri(), path, this.getDefaultPort());
    }

    @Override
    protected URI canonicalizeUri(URI rawUri) {
        return S3xLoginHelper.canonicalizeUri(rawUri, this.getDefaultPort());
    }

    @Override
    public FSDataInputStream open(Path f, int bufferSize) throws IOException {
        this.entryPoint(Statistic.INVOCATION_OPEN);
        LOG.debug("Opening '{}' for reading; input policy = {}", (Object)f, (Object)this.inputPolicy);
        FileStatus fileStatus = this.getFileStatus(f);
        if (fileStatus.isDirectory()) {
            throw new FileNotFoundException("Can't open " + f + " because it is a directory");
        }
        return new FSDataInputStream(new S3AInputStream(new S3AReadOpContext(this.hasMetadataStore(), this.invoker, this.s3guardInvoker, this.statistics, this.instrumentation, fileStatus), new S3ObjectAttributes(this.bucket, this.pathToKey(f), this.serverSideEncryptionAlgorithm, S3AUtils.getServerSideEncryptionKey(this.bucket, this.getConf())), fileStatus.getLen(), this.s3, this.readAhead, this.inputPolicy));
    }

    @Override
    public FSDataOutputStream create(Path f, FsPermission permission, boolean overwrite, int bufferSize, short replication, long blockSize, Progressable progress) throws IOException {
        this.entryPoint(Statistic.INVOCATION_CREATE);
        Path path = this.qualify(f);
        String key = this.pathToKey(path);
        FileStatus status = null;
        try {
            status = this.getFileStatus(path);
            if (status.isDirectory()) {
                throw new FileAlreadyExistsException(path + " is a directory");
            }
            if (!overwrite) {
                throw new FileAlreadyExistsException(path + " already exists");
            }
            LOG.debug("Overwriting file {}", (Object)path);
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        this.instrumentation.fileCreated();
        PutTracker putTracker = this.committerIntegration.createTracker(path, key);
        String destKey = putTracker.getDestKey();
        return new FSDataOutputStream(new S3ABlockOutputStream(this, destKey, new SemaphoredDelegatingExecutor(this.boundedThreadPool, this.blockOutputActiveBlocks, true), progress, this.partSize, this.blockFactory, this.instrumentation.newOutputStreamStatistics(this.statistics), this.getWriteOperationHelper(), putTracker), null);
    }

    @InterfaceAudience.Private
    public WriteOperationHelper getWriteOperationHelper() {
        return this.writeHelper;
    }

    @Override
    public FSDataOutputStream createNonRecursive(Path path, FsPermission permission, EnumSet<CreateFlag> flags, int bufferSize, short replication, long blockSize, Progressable progress) throws IOException {
        this.entryPoint(Statistic.INVOCATION_CREATE_NON_RECURSIVE);
        Path parent = path.getParent();
        if (parent != null && !this.getFileStatus(parent).isDirectory()) {
            throw new FileAlreadyExistsException("Not a directory: " + parent);
        }
        return this.create(path, permission, flags.contains((Object)CreateFlag.OVERWRITE), bufferSize, replication, blockSize, progress);
    }

    @Override
    public FSDataOutputStream append(Path f, int bufferSize, Progressable progress) throws IOException {
        throw new UnsupportedOperationException("Append is not supported by S3AFileSystem");
    }

    @Override
    public boolean rename(Path src, Path dst) throws IOException {
        try {
            return this.innerRename(src, dst);
        }
        catch (AmazonClientException e) {
            throw S3AUtils.translateException("rename(" + src + ", " + dst + ")", src, e);
        }
        catch (RenameFailedException e) {
            LOG.debug(e.getMessage());
            return e.getExitCode();
        }
        catch (FileNotFoundException e) {
            LOG.debug(e.toString());
            return false;
        }
    }

    private boolean innerRename(Path source, Path dest) throws RenameFailedException, FileNotFoundException, IOException, AmazonClientException {
        S3AFileStatus dstStatus;
        S3AFileStatus srcStatus;
        String dstKey;
        String srcKey;
        Path dst;
        Path src;
        block28: {
            src = this.qualify(source);
            dst = this.qualify(dest);
            LOG.debug("Rename path {} to {}", (Object)src, (Object)dst);
            this.entryPoint(Statistic.INVOCATION_RENAME);
            srcKey = this.pathToKey(src);
            dstKey = this.pathToKey(dst);
            if (srcKey.isEmpty()) {
                throw new RenameFailedException(src, dst, "source is root directory");
            }
            if (dstKey.isEmpty()) {
                throw new RenameFailedException(src, dst, "dest is root directory");
            }
            srcStatus = this.innerGetFileStatus(src, true);
            if (srcKey.equals(dstKey)) {
                LOG.debug("rename: src and dest refer to the same file or directory: {}", (Object)dst);
                throw new RenameFailedException(src, dst, "source and dest refer to the same file or directory").withExitCode(srcStatus.isFile());
            }
            dstStatus = null;
            try {
                dstStatus = this.innerGetFileStatus(dst, true);
                if (srcStatus.isDirectory()) {
                    if (dstStatus.isFile()) {
                        throw new RenameFailedException(src, dst, "source is a directory and dest is a file").withExitCode(srcStatus.isFile());
                    }
                    if (dstStatus.isEmptyDirectory() != Tristate.TRUE) {
                        throw new RenameFailedException(src, dst, "Destination is a non-empty directory").withExitCode(false);
                    }
                } else if (dstStatus.isFile()) {
                    throw new RenameFailedException(src, dst, "Cannot rename onto an existing file").withExitCode(false);
                }
            }
            catch (FileNotFoundException e) {
                LOG.debug("rename: destination path {} not found", (Object)dst);
                Path parent = dst.getParent();
                if (this.pathToKey(parent).isEmpty()) break block28;
                try {
                    S3AFileStatus dstParentStatus = this.innerGetFileStatus(dst.getParent(), false);
                    if (!dstParentStatus.isDirectory()) {
                        throw new RenameFailedException(src, dst, "destination parent is not a directory");
                    }
                }
                catch (FileNotFoundException e2) {
                    throw new RenameFailedException(src, dst, "destination has no parent ");
                }
            }
        }
        HashSet<Path> srcPaths = null;
        ArrayList<PathMetadata> dstMetas = null;
        if (this.hasMetadataStore()) {
            srcPaths = new HashSet<Path>();
            dstMetas = new ArrayList<PathMetadata>();
        }
        if (srcStatus.isFile()) {
            LOG.debug("rename: renaming file {} to {}", (Object)src, (Object)dst);
            long length = srcStatus.getLen();
            if (dstStatus != null && dstStatus.isDirectory()) {
                String newDstKey = this.maybeAddTrailingSlash(dstKey);
                String filename = srcKey.substring(this.pathToKey(src.getParent()).length() + 1);
                newDstKey = newDstKey + filename;
                this.copyFile(srcKey, newDstKey, length);
                S3Guard.addMoveFile(this.metadataStore, srcPaths, dstMetas, src, this.keyToQualifiedPath(newDstKey), length, this.getDefaultBlockSize(dst), this.username);
            } else {
                this.copyFile(srcKey, dstKey, srcStatus.getLen());
                S3Guard.addMoveFile(this.metadataStore, srcPaths, dstMetas, src, dst, length, this.getDefaultBlockSize(dst), this.username);
            }
            this.innerDelete(srcStatus, false);
        } else {
            LOG.debug("rename: renaming directory {} to {}", (Object)src, (Object)dst);
            dstKey = this.maybeAddTrailingSlash(dstKey);
            srcKey = this.maybeAddTrailingSlash(srcKey);
            if (dstKey.startsWith(srcKey)) {
                throw new RenameFailedException(srcKey, dstKey, "cannot rename a directory to a subdirectory of itself ");
            }
            ArrayList<DeleteObjectsRequest.KeyVersion> keysToDelete = new ArrayList<DeleteObjectsRequest.KeyVersion>();
            if (dstStatus != null && dstStatus.isEmptyDirectory() == Tristate.TRUE) {
                keysToDelete.add(new DeleteObjectsRequest.KeyVersion(dstKey));
            }
            Path parentPath = this.keyToQualifiedPath(srcKey);
            RemoteIterator<LocatedFileStatus> iterator = this.listFilesAndEmptyDirectories(parentPath, true);
            while (iterator.hasNext()) {
                LocatedFileStatus status = iterator.next();
                long length = status.getLen();
                String key = this.pathToKey(status.getPath());
                if (status.isDirectory() && !key.endsWith("/")) {
                    key = key + "/";
                }
                keysToDelete.add(new DeleteObjectsRequest.KeyVersion(key));
                String newDstKey = dstKey + key.substring(srcKey.length());
                this.copyFile(key, newDstKey, length);
                if (this.hasMetadataStore()) {
                    Path childSrc = this.keyToQualifiedPath(key);
                    Path childDst = this.keyToQualifiedPath(newDstKey);
                    if (S3AUtils.objectRepresentsDirectory(key, length)) {
                        S3Guard.addMoveDir(this.metadataStore, srcPaths, dstMetas, childSrc, childDst, this.username);
                    } else {
                        S3Guard.addMoveFile(this.metadataStore, srcPaths, dstMetas, childSrc, childDst, length, this.getDefaultBlockSize(childDst), this.username);
                    }
                    S3Guard.addMoveAncestors(this.metadataStore, srcPaths, dstMetas, this.keyToQualifiedPath(srcKey), childSrc, childDst, this.username);
                }
                if (keysToDelete.size() != 1000) continue;
                this.removeKeys(keysToDelete, true, false);
            }
            if (!keysToDelete.isEmpty()) {
                this.removeKeys(keysToDelete, false, false);
            }
            if (this.hasMetadataStore() && srcPaths != null && !srcPaths.contains(src)) {
                LOG.debug("To move the non-empty top-level dir src={} and dst={}", (Object)src, (Object)dst);
                S3Guard.addMoveDir(this.metadataStore, srcPaths, dstMetas, src, dst, this.username);
            }
        }
        this.metadataStore.move(srcPaths, dstMetas);
        if (!src.getParent().equals(dst.getParent())) {
            LOG.debug("source & dest parents are different; fix up dir markers");
            this.deleteUnnecessaryFakeDirectories(dst.getParent());
            this.maybeCreateFakeParentDirectory(src);
        }
        return true;
    }

    @VisibleForTesting
    public ObjectMetadata getObjectMetadata(Path path) throws IOException {
        return this.getObjectMetadata(this.pathToKey(path));
    }

    public boolean hasMetadataStore() {
        return !S3Guard.isNullMetadataStore(this.metadataStore);
    }

    @VisibleForTesting
    public MetadataStore getMetadataStore() {
        return this.metadataStore;
    }

    @VisibleForTesting
    void setMetadataStore(MetadataStore ms) {
        Preconditions.checkNotNull(ms);
        this.metadataStore = ms;
    }

    protected void entryPoint(Statistic operation) throws IOException {
        this.checkNotClosed();
        this.incrementStatistic(operation);
    }

    protected void incrementStatistic(Statistic statistic) {
        this.incrementStatistic(statistic, 1L);
    }

    protected void incrementStatistic(Statistic statistic, long count) {
        this.instrumentation.incrementCounter(statistic, count);
        this.storageStatistics.incrementCounter(statistic, count);
    }

    protected void decrementGauge(Statistic statistic, long count) {
        this.instrumentation.decrementGauge(statistic, count);
    }

    protected void incrementGauge(Statistic statistic, long count) {
        this.instrumentation.incrementGauge(statistic, count);
    }

    public void operationRetried(Exception ex) {
        Statistic stat = S3AUtils.isThrottleException(ex) ? Statistic.STORE_IO_THROTTLED : Statistic.IGNORED_ERRORS;
        this.instrumentation.incrementCounter(stat, 1L);
        this.storageStatistics.incrementCounter(stat, 1L);
    }

    public void operationRetried(String text, Exception ex, int retries, boolean idempotent) {
        this.operationRetried(ex);
    }

    public void metastoreOperationRetried(Exception ex, int retries, boolean idempotent) {
        this.operationRetried(ex);
    }

    @Override
    public S3AStorageStatistics getStorageStatistics() {
        return this.storageStatistics;
    }

    protected ObjectMetadata getObjectMetadata(String key) throws IOException {
        GetObjectMetadataRequest request = new GetObjectMetadataRequest(this.bucket, key);
        if (S3AEncryptionMethods.SSE_C.equals((Object)this.serverSideEncryptionAlgorithm) && StringUtils.isNotBlank(S3AUtils.getServerSideEncryptionKey(this.bucket, this.getConf()))) {
            request.setSSECustomerKey(this.generateSSECustomerKey());
        }
        ObjectMetadata meta = this.invoker.retryUntranslated("GET " + key, true, () -> {
            this.incrementStatistic(Statistic.OBJECT_METADATA_REQUESTS);
            return this.s3.getObjectMetadata(request);
        });
        this.incrementReadOperations();
        return meta;
    }

    protected S3ListResult listObjects(S3ListRequest request) throws IOException {
        this.incrementReadOperations();
        this.incrementStatistic(Statistic.OBJECT_LIST_REQUESTS);
        this.validateListArguments(request);
        return this.invoker.retryUntranslated(request.toString(), true, () -> {
            if (this.useListV1) {
                return S3ListResult.v1(this.s3.listObjects(request.getV1()));
            }
            return S3ListResult.v2(this.s3.listObjectsV2(request.getV2()));
        });
    }

    private void validateListArguments(S3ListRequest request) {
        if (this.useListV1) {
            Preconditions.checkArgument(request.isV1());
        } else {
            Preconditions.checkArgument(!request.isV1());
        }
    }

    protected S3ListResult continueListObjects(S3ListRequest request, S3ListResult prevResult) throws IOException {
        this.incrementReadOperations();
        this.validateListArguments(request);
        return this.invoker.retryUntranslated(request.toString(), true, () -> {
            this.incrementStatistic(Statistic.OBJECT_CONTINUE_LIST_REQUESTS);
            if (this.useListV1) {
                return S3ListResult.v1(this.s3.listNextBatchOfObjects(prevResult.getV1()));
            }
            request.getV2().setContinuationToken(prevResult.getV2().getNextContinuationToken());
            return S3ListResult.v2(this.s3.listObjectsV2(request.getV2()));
        });
    }

    public void incrementReadOperations() {
        this.statistics.incrementReadOps(1);
    }

    public void incrementWriteOperations() {
        this.statistics.incrementWriteOps(1);
    }

    @VisibleForTesting
    protected void deleteObject(String key) throws AmazonClientException, IOException {
        this.blockRootDelete(key);
        this.incrementWriteOperations();
        this.invoker.retryUntranslated("Delete " + this.bucket + ":/" + key, true, () -> {
            this.incrementStatistic(Statistic.OBJECT_DELETE_REQUESTS);
            this.s3.deleteObject(this.bucket, key);
            return null;
        });
    }

    void deleteObjectAtPath(Path f, String key, boolean isFile) throws AmazonClientException, IOException {
        if (isFile) {
            this.instrumentation.fileDeleted(1);
        } else {
            this.instrumentation.directoryDeleted();
        }
        this.deleteObject(key);
        this.metadataStore.delete(f);
    }

    private void blockRootDelete(String key) throws InvalidRequestException {
        if (key.isEmpty() || "/".equals(key)) {
            throw new InvalidRequestException("Bucket " + this.bucket + " cannot be deleted");
        }
    }

    private void deleteObjects(DeleteObjectsRequest deleteRequest) throws MultiObjectDeleteException, AmazonClientException, IOException {
        this.incrementWriteOperations();
        try {
            this.invoker.retryUntranslated("delete", true, () -> {
                this.incrementStatistic(Statistic.OBJECT_DELETE_REQUESTS, 1L);
                return this.s3.deleteObjects(deleteRequest);
            });
        }
        catch (MultiObjectDeleteException e) {
            List<MultiObjectDeleteException.DeleteError> errors = e.getErrors();
            LOG.debug("Partial failure of delete, {} errors", (Object)errors.size(), (Object)e);
            for (MultiObjectDeleteException.DeleteError error : errors) {
                LOG.debug("{}: \"{}\" - {}", new Object[]{error.getKey(), error.getCode(), error.getMessage()});
            }
            throw e;
        }
    }

    public PutObjectRequest newPutObjectRequest(String key, ObjectMetadata metadata, File srcfile) {
        Preconditions.checkNotNull(srcfile);
        PutObjectRequest putObjectRequest = new PutObjectRequest(this.bucket, key, srcfile);
        this.setOptionalPutRequestParameters(putObjectRequest);
        putObjectRequest.setCannedAcl(this.cannedACL);
        putObjectRequest.setMetadata(metadata);
        return putObjectRequest;
    }

    PutObjectRequest newPutObjectRequest(String key, ObjectMetadata metadata, InputStream inputStream) {
        Preconditions.checkNotNull(inputStream);
        Preconditions.checkArgument(StringUtils.isNotEmpty(key), "Null/empty key");
        PutObjectRequest putObjectRequest = new PutObjectRequest(this.bucket, key, inputStream, metadata);
        this.setOptionalPutRequestParameters(putObjectRequest);
        putObjectRequest.setCannedAcl(this.cannedACL);
        return putObjectRequest;
    }

    public ObjectMetadata newObjectMetadata() {
        ObjectMetadata om = new ObjectMetadata();
        this.setOptionalObjectMetadata(om);
        return om;
    }

    public ObjectMetadata newObjectMetadata(long length) {
        ObjectMetadata om = this.newObjectMetadata();
        if (length >= 0L) {
            om.setContentLength(length);
        }
        return om;
    }

    public UploadInfo putObject(PutObjectRequest putObjectRequest) {
        long len = this.getPutRequestLength(putObjectRequest);
        LOG.debug("PUT {} bytes to {} via transfer manager ", (Object)len, (Object)putObjectRequest.getKey());
        this.incrementPutStartStatistics(len);
        Upload upload = this.transfers.upload(putObjectRequest);
        return new UploadInfo(upload, len);
    }

    PutObjectResult putObjectDirect(PutObjectRequest putObjectRequest) throws AmazonClientException {
        long len = this.getPutRequestLength(putObjectRequest);
        LOG.debug("PUT {} bytes to {}", (Object)len, (Object)putObjectRequest.getKey());
        this.incrementPutStartStatistics(len);
        try {
            PutObjectResult result = this.s3.putObject(putObjectRequest);
            this.incrementPutCompletedStatistics(true, len);
            this.finishedWrite(putObjectRequest.getKey(), len);
            return result;
        }
        catch (AmazonClientException e) {
            this.incrementPutCompletedStatistics(false, len);
            throw e;
        }
    }

    private long getPutRequestLength(PutObjectRequest putObjectRequest) {
        long len = putObjectRequest.getFile() != null ? putObjectRequest.getFile().length() : putObjectRequest.getMetadata().getContentLength();
        Preconditions.checkState(len >= 0L, "Cannot PUT object of unknown length");
        return len;
    }

    UploadPartResult uploadPart(UploadPartRequest request) throws AmazonClientException {
        long len = request.getPartSize();
        this.incrementPutStartStatistics(len);
        try {
            this.setOptionalUploadPartRequestParameters(request);
            UploadPartResult uploadPartResult = this.s3.uploadPart(request);
            this.incrementPutCompletedStatistics(true, len);
            return uploadPartResult;
        }
        catch (AmazonClientException e) {
            this.incrementPutCompletedStatistics(false, len);
            throw e;
        }
    }

    public void incrementPutStartStatistics(long bytes) {
        LOG.debug("PUT start {} bytes", (Object)bytes);
        this.incrementWriteOperations();
        this.incrementStatistic(Statistic.OBJECT_PUT_REQUESTS);
        this.incrementGauge(Statistic.OBJECT_PUT_REQUESTS_ACTIVE, 1L);
        if (bytes > 0L) {
            this.incrementGauge(Statistic.OBJECT_PUT_BYTES_PENDING, bytes);
        }
    }

    public void incrementPutCompletedStatistics(boolean success, long bytes) {
        LOG.debug("PUT completed success={}; {} bytes", (Object)success, (Object)bytes);
        this.incrementWriteOperations();
        if (bytes > 0L) {
            this.incrementStatistic(Statistic.OBJECT_PUT_BYTES, bytes);
            this.decrementGauge(Statistic.OBJECT_PUT_BYTES_PENDING, bytes);
        }
        this.incrementStatistic(Statistic.OBJECT_PUT_REQUESTS_COMPLETED);
        this.decrementGauge(Statistic.OBJECT_PUT_REQUESTS_ACTIVE, 1L);
    }

    public void incrementPutProgressStatistics(String key, long bytes) {
        PROGRESS.debug("PUT {}: {} bytes", (Object)key, (Object)bytes);
        this.incrementWriteOperations();
        if (bytes > 0L) {
            this.statistics.incrementBytesWritten(bytes);
        }
    }

    @VisibleForTesting
    void removeKeys(List<DeleteObjectsRequest.KeyVersion> keysToDelete, boolean clearKeys, boolean deleteFakeDir) throws MultiObjectDeleteException, AmazonClientException, IOException {
        if (keysToDelete.isEmpty()) {
            return;
        }
        for (DeleteObjectsRequest.KeyVersion keyVersion : keysToDelete) {
            this.blockRootDelete(keyVersion.getKey());
        }
        if (this.enableMultiObjectsDelete) {
            this.deleteObjects(new DeleteObjectsRequest(this.bucket).withKeys(keysToDelete).withQuiet(true));
        } else {
            for (DeleteObjectsRequest.KeyVersion keyVersion : keysToDelete) {
                this.deleteObject(keyVersion.getKey());
            }
        }
        if (!deleteFakeDir) {
            this.instrumentation.fileDeleted(keysToDelete.size());
        } else {
            this.instrumentation.fakeDirsDeleted(keysToDelete.size());
        }
        if (clearKeys) {
            keysToDelete.clear();
        }
    }

    @Override
    public boolean delete(Path f, boolean recursive) throws IOException {
        try {
            this.entryPoint(Statistic.INVOCATION_DELETE);
            boolean outcome = this.innerDelete(this.innerGetFileStatus(f, true), recursive);
            if (outcome) {
                try {
                    this.maybeCreateFakeParentDirectory(f);
                }
                catch (AccessDeniedException e) {
                    LOG.warn("Cannot create directory marker at {}: {}", (Object)f.getParent(), (Object)e.toString());
                    LOG.debug("Failed to create fake dir above {}", (Object)f, (Object)e);
                }
            }
            return outcome;
        }
        catch (FileNotFoundException e) {
            LOG.debug("Couldn't delete {} - does not exist", (Object)f);
            this.instrumentation.errorIgnored();
            return false;
        }
        catch (AmazonClientException e) {
            throw S3AUtils.translateException("delete", f, e);
        }
    }

    private boolean innerDelete(S3AFileStatus status, boolean recursive) throws IOException, AmazonClientException {
        Path f = status.getPath();
        LOG.debug("Delete path {} - recursive {}", (Object)f, (Object)recursive);
        String key = this.pathToKey(f);
        if (status.isDirectory()) {
            LOG.debug("delete: Path is a directory: {}", (Object)f);
            Preconditions.checkArgument(status.isEmptyDirectory() != Tristate.UNKNOWN, "File status must have directory emptiness computed");
            if (!key.endsWith("/")) {
                key = key + "/";
            }
            if (key.equals("/")) {
                return this.rejectRootDirectoryDelete(status, recursive);
            }
            if (!recursive && status.isEmptyDirectory() == Tristate.FALSE) {
                throw new PathIsNotEmptyDirectoryException(f.toString());
            }
            if (status.isEmptyDirectory() == Tristate.TRUE) {
                LOG.debug("Deleting fake empty directory {}", (Object)key);
                this.deleteObjectAtPath(f, key, false);
            } else {
                LOG.debug("Getting objects for directory prefix {} to delete", (Object)key);
                S3ListRequest request = this.createListObjectsRequest(key, null);
                S3ListResult objects = this.listObjects(request);
                ArrayList<DeleteObjectsRequest.KeyVersion> keys = new ArrayList<DeleteObjectsRequest.KeyVersion>(objects.getObjectSummaries().size());
                while (true) {
                    for (S3ObjectSummary summary : objects.getObjectSummaries()) {
                        keys.add(new DeleteObjectsRequest.KeyVersion(summary.getKey()));
                        LOG.debug("Got object to delete {}", (Object)summary.getKey());
                        if (keys.size() != 1000) continue;
                        this.removeKeys(keys, true, false);
                    }
                    if (!objects.isTruncated()) break;
                    objects = this.continueListObjects(request, objects);
                }
                if (!keys.isEmpty()) {
                    this.removeKeys(keys, false, false);
                }
            }
            this.metadataStore.deleteSubtree(f);
        } else {
            LOG.debug("delete: Path is a file");
            this.deleteObjectAtPath(f, key, true);
        }
        return true;
    }

    private boolean rejectRootDirectoryDelete(S3AFileStatus status, boolean recursive) throws IOException {
        boolean emptyRoot;
        LOG.info("s3a delete the {} root directory of {}", (Object)this.bucket, (Object)recursive);
        boolean bl = emptyRoot = status.isEmptyDirectory() == Tristate.TRUE;
        if (emptyRoot) {
            return true;
        }
        if (recursive) {
            return false;
        }
        throw new PathIOException(this.bucket, "Cannot delete root path");
    }

    private void createFakeDirectoryIfNecessary(Path f) throws IOException, AmazonClientException {
        String key = this.pathToKey(f);
        if (!key.isEmpty() && !this.s3Exists(f)) {
            LOG.debug("Creating new fake directory at {}", (Object)f);
            this.createFakeDirectory(key);
        }
    }

    void maybeCreateFakeParentDirectory(Path path) throws IOException, AmazonClientException {
        Path parent = path.getParent();
        if (parent != null) {
            this.createFakeDirectoryIfNecessary(parent);
        }
    }

    @Override
    public FileStatus[] listStatus(Path f) throws FileNotFoundException, IOException {
        return Invoker.once("listStatus", f.toString(), () -> this.innerListStatus(f));
    }

    public FileStatus[] innerListStatus(Path f) throws FileNotFoundException, IOException, AmazonClientException {
        Path path = this.qualify(f);
        String key = this.pathToKey(path);
        LOG.debug("List status for path: {}", (Object)path);
        this.entryPoint(Statistic.INVOCATION_LIST_STATUS);
        FileStatus fileStatus = this.getFileStatus(path);
        if (fileStatus.isDirectory()) {
            if (!key.isEmpty()) {
                key = key + '/';
            }
            DirListingMetadata dirMeta = this.metadataStore.listChildren(path);
            if (this.allowAuthoritative && dirMeta != null && dirMeta.isAuthoritative()) {
                return S3Guard.dirMetaToStatuses(dirMeta);
            }
            S3ListRequest request = this.createListObjectsRequest(key, "/");
            LOG.debug("listStatus: doing listObjects for directory {}", (Object)key);
            Listing.FileStatusListingIterator files = this.listing.createFileStatusListingIterator(path, request, S3AUtils.ACCEPT_ALL, new Listing.AcceptAllButSelfAndS3nDirs(path));
            ArrayList<FileStatus> result = new ArrayList<FileStatus>(files.getBatchSize());
            while (files.hasNext()) {
                result.add(files.next());
            }
            return S3Guard.dirListingUnion(this.metadataStore, path, result, dirMeta, this.allowAuthoritative);
        }
        LOG.debug("Adding: rd (not a dir): {}", (Object)path);
        FileStatus[] stats = new FileStatus[]{fileStatus};
        return stats;
    }

    @VisibleForTesting
    S3ListRequest createListObjectsRequest(String key, String delimiter) {
        return this.createListObjectsRequest(key, delimiter, null);
    }

    private S3ListRequest createListObjectsRequest(String key, String delimiter, Integer overrideMaxKeys) {
        if (!this.useListV1) {
            ListObjectsV2Request request = new ListObjectsV2Request().withBucketName(this.bucket).withMaxKeys(this.maxKeys).withPrefix(key);
            if (delimiter != null) {
                request.setDelimiter(delimiter);
            }
            if (overrideMaxKeys != null) {
                request.setMaxKeys(overrideMaxKeys);
            }
            return S3ListRequest.v2(request);
        }
        ListObjectsRequest request = new ListObjectsRequest();
        request.setBucketName(this.bucket);
        request.setMaxKeys(this.maxKeys);
        request.setPrefix(key);
        if (delimiter != null) {
            request.setDelimiter(delimiter);
        }
        if (overrideMaxKeys != null) {
            request.setMaxKeys(overrideMaxKeys);
        }
        return S3ListRequest.v1(request);
    }

    @Override
    public void setWorkingDirectory(Path newDir) {
        this.workingDir = newDir;
    }

    @Override
    public Path getWorkingDirectory() {
        return this.workingDir;
    }

    public String getUsername() {
        return this.username;
    }

    @Override
    public boolean mkdirs(Path path, FsPermission permission) throws IOException, FileAlreadyExistsException {
        try {
            return this.innerMkdirs(path, permission);
        }
        catch (AmazonClientException e) {
            throw S3AUtils.translateException("innerMkdirs", path, e);
        }
    }

    private boolean innerMkdirs(Path p, FsPermission permission) throws IOException, FileAlreadyExistsException, AmazonClientException {
        Path f = this.qualify(p);
        LOG.debug("Making directory: {}", (Object)f);
        this.entryPoint(Statistic.INVOCATION_MKDIRS);
        ArrayList<Path> metadataStoreDirs = null;
        if (this.hasMetadataStore()) {
            metadataStoreDirs = new ArrayList<Path>();
        }
        try {
            FileStatus fileStatus = this.getFileStatus(f);
            if (fileStatus.isDirectory()) {
                return true;
            }
            throw new FileAlreadyExistsException("Path is a file: " + f);
        }
        catch (FileNotFoundException e) {
            Path fPart = f.getParent();
            if (metadataStoreDirs != null) {
                metadataStoreDirs.add(f);
            }
            while (fPart != null) {
                block9: {
                    try {
                        FileStatus fileStatus = this.getFileStatus(fPart);
                        if (fileStatus.isDirectory()) break;
                        if (fileStatus.isFile()) {
                            throw new FileAlreadyExistsException(String.format("Can't make directory for path '%s' since it is a file.", fPart));
                        }
                    }
                    catch (FileNotFoundException fnfe) {
                        this.instrumentation.errorIgnored();
                        if (metadataStoreDirs == null) break block9;
                        metadataStoreDirs.add(fPart);
                    }
                }
                fPart = fPart.getParent();
            }
            String key = this.pathToKey(f);
            this.createFakeDirectory(key);
            return true;
        }
    }

    @Override
    public FileStatus getFileStatus(Path f) throws IOException {
        return this.innerGetFileStatus(f, false);
    }

    @VisibleForTesting
    S3AFileStatus innerGetFileStatus(Path f, boolean needEmptyDirectoryFlag) throws IOException {
        this.entryPoint(Statistic.INVOCATION_GET_FILE_STATUS);
        Path path = this.qualify(f);
        String key = this.pathToKey(path);
        LOG.debug("Getting path status for {}  ({})", (Object)path, (Object)key);
        PathMetadata pm = this.metadataStore.get(path, needEmptyDirectoryFlag);
        Set<Path> tombstones = Collections.emptySet();
        if (pm != null) {
            S3AFileStatus s3FileStatus;
            if (pm.isDeleted()) {
                throw new FileNotFoundException("Path " + f + " is recorded as deleted by S3Guard");
            }
            FileStatus msStatus = pm.getFileStatus();
            if (needEmptyDirectoryFlag && msStatus.isDirectory()) {
                if (pm.isEmptyDirectory() != Tristate.UNKNOWN) {
                    return S3AFileStatus.fromFileStatus(msStatus, pm.isEmptyDirectory());
                }
                DirListingMetadata children = this.metadataStore.listChildren(path);
                if (children != null) {
                    tombstones = children.listTombstones();
                }
            } else {
                return S3AFileStatus.fromFileStatus(msStatus, pm.isEmptyDirectory());
            }
            LOG.debug("MetadataStore doesn't know if dir is empty, using S3.");
            try {
                s3FileStatus = this.s3GetFileStatus(path, key, tombstones);
            }
            catch (FileNotFoundException e) {
                return S3AFileStatus.fromFileStatus(msStatus, Tristate.TRUE);
            }
            return S3Guard.putAndReturn(this.metadataStore, s3FileStatus, this.instrumentation);
        }
        return S3Guard.putAndReturn(this.metadataStore, this.s3GetFileStatus(path, key, tombstones), this.instrumentation);
    }

    private S3AFileStatus s3GetFileStatus(Path path, String key, Set<Path> tombstones) throws IOException {
        if (!key.isEmpty()) {
            try {
                ObjectMetadata meta = this.getObjectMetadata(key);
                if (S3AUtils.objectRepresentsDirectory(key, meta.getContentLength())) {
                    LOG.debug("Found exact file: fake directory");
                    return new S3AFileStatus(Tristate.TRUE, path, this.username);
                }
                LOG.debug("Found exact file: normal file");
                return new S3AFileStatus(meta.getContentLength(), S3AUtils.dateToLong(meta.getLastModified()), path, this.getDefaultBlockSize(path), this.username);
            }
            catch (AmazonServiceException e) {
                if (e.getStatusCode() != 404) {
                    throw S3AUtils.translateException("getFileStatus", path, e);
                }
            }
            catch (AmazonClientException e) {
                throw S3AUtils.translateException("getFileStatus", path, e);
            }
            if (!key.endsWith("/")) {
                String newKey = key + "/";
                try {
                    ObjectMetadata meta = this.getObjectMetadata(newKey);
                    if (S3AUtils.objectRepresentsDirectory(newKey, meta.getContentLength())) {
                        LOG.debug("Found file (with /): fake directory");
                        return new S3AFileStatus(Tristate.TRUE, path, this.username);
                    }
                    LOG.warn("Found file (with /): real file? should not happen: {}", (Object)key);
                    return new S3AFileStatus(meta.getContentLength(), S3AUtils.dateToLong(meta.getLastModified()), path, this.getDefaultBlockSize(path), this.username);
                }
                catch (AmazonServiceException e) {
                    if (e.getStatusCode() != 404) {
                        throw S3AUtils.translateException("getFileStatus", newKey, (SdkBaseException)e);
                    }
                }
                catch (AmazonClientException e) {
                    throw S3AUtils.translateException("getFileStatus", newKey, (SdkBaseException)e);
                }
            }
        }
        try {
            key = this.maybeAddTrailingSlash(key);
            S3ListRequest request = this.createListObjectsRequest(key, "/", 1);
            S3ListResult objects = this.listObjects(request);
            List<String> prefixes = objects.getCommonPrefixes();
            List<S3ObjectSummary> summaries = objects.getObjectSummaries();
            if (!this.isEmptyOfKeys(prefixes, tombstones) || !this.isEmptyOfObjects(summaries, tombstones)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Found path as directory (with /): {}/{}", (Object)prefixes.size(), (Object)summaries.size());
                    for (S3ObjectSummary summary : summaries) {
                        LOG.debug("Summary: {} {}", (Object)summary.getKey(), (Object)summary.getSize());
                    }
                    for (String prefix : prefixes) {
                        LOG.debug("Prefix: {}", (Object)prefix);
                    }
                }
                return new S3AFileStatus(Tristate.FALSE, path, this.username);
            }
            if (key.isEmpty()) {
                LOG.debug("Found root directory");
                return new S3AFileStatus(Tristate.TRUE, path, this.username);
            }
        }
        catch (AmazonServiceException e) {
            if (e.getStatusCode() != 404) {
                throw S3AUtils.translateException("getFileStatus", path, e);
            }
        }
        catch (AmazonClientException e) {
            throw S3AUtils.translateException("getFileStatus", path, e);
        }
        LOG.debug("Not Found: {}", (Object)path);
        throw new FileNotFoundException("No such file or directory: " + path);
    }

    private boolean isEmptyOfKeys(Collection<String> keys, Set<Path> tombstones) {
        if (tombstones == null) {
            return keys.isEmpty();
        }
        for (String key : keys) {
            Path qualified = this.keyToQualifiedPath(key);
            if (tombstones.contains(qualified)) continue;
            return false;
        }
        return true;
    }

    private boolean isEmptyOfObjects(Collection<S3ObjectSummary> summaries, Set<Path> tombstones) {
        if (tombstones == null) {
            return summaries.isEmpty();
        }
        ArrayList<String> stringCollection = new ArrayList<String>(summaries.size());
        for (S3ObjectSummary summary : summaries) {
            stringCollection.add(summary.getKey());
        }
        return this.isEmptyOfKeys(stringCollection, tombstones);
    }

    private boolean s3Exists(Path f) throws IOException {
        Path path = this.qualify(f);
        String key = this.pathToKey(path);
        try {
            this.s3GetFileStatus(path, key, null);
            return true;
        }
        catch (FileNotFoundException e) {
            return false;
        }
    }

    @Override
    public void copyFromLocalFile(boolean delSrc, boolean overwrite, Path src, Path dst) throws IOException {
        this.innerCopyFromLocalFile(delSrc, overwrite, src, dst);
    }

    private void innerCopyFromLocalFile(boolean delSrc, boolean overwrite, Path src, Path dst) throws IOException, FileAlreadyExistsException, AmazonClientException {
        this.entryPoint(Statistic.INVOCATION_COPY_FROM_LOCAL_FILE);
        LOG.debug("Copying local file from {} to {}", (Object)src, (Object)dst);
        LocalFileSystem local = S3AFileSystem.getLocal(this.getConf());
        File srcfile = local.pathToFile(src);
        if (!srcfile.exists()) {
            throw new FileNotFoundException("No file: " + src);
        }
        if (!srcfile.isFile()) {
            throw new FileNotFoundException("Not a file: " + src);
        }
        try {
            FileStatus status = this.getFileStatus(dst);
            if (!status.isFile()) {
                throw new FileAlreadyExistsException(dst + " exists and is not a file");
            }
            if (!overwrite) {
                throw new FileAlreadyExistsException(dst + " already exists");
            }
        }
        catch (FileNotFoundException status) {
            // empty catch block
        }
        String key = this.pathToKey(dst);
        ObjectMetadata om = this.newObjectMetadata(srcfile.length());
        Progressable progress = null;
        PutObjectRequest putObjectRequest = this.newPutObjectRequest(key, om, srcfile);
        this.invoker.retry("copyFromLocalFile(" + src + ")", dst.toString(), true, () -> this.executePut(putObjectRequest, progress));
        if (delSrc) {
            local.delete(src, false);
        }
    }

    UploadResult executePut(PutObjectRequest putObjectRequest, Progressable progress) throws InterruptedIOException {
        String key = putObjectRequest.getKey();
        UploadInfo info = this.putObject(putObjectRequest);
        Upload upload = info.getUpload();
        ProgressableProgressListener listener = new ProgressableProgressListener(this, key, upload, progress);
        upload.addProgressListener(listener);
        UploadResult result = this.waitForUploadCompletion(key, info);
        listener.uploadCompleted();
        this.finishedWrite(key, info.getLength());
        return result;
    }

    UploadResult waitForUploadCompletion(String key, UploadInfo uploadInfo) throws InterruptedIOException {
        Upload upload = uploadInfo.getUpload();
        try {
            UploadResult result = upload.waitForUploadResult();
            this.incrementPutCompletedStatistics(true, uploadInfo.getLength());
            return result;
        }
        catch (InterruptedException e) {
            LOG.info("Interrupted: aborting upload");
            this.incrementPutCompletedStatistics(false, uploadInfo.getLength());
            upload.abort();
            throw (InterruptedIOException)new InterruptedIOException("Interrupted in PUT to " + this.keyToQualifiedPath(key)).initCause(e);
        }
    }

    @Override
    public void close() throws IOException {
        if (this.closed.getAndSet(true)) {
            return;
        }
        this.isClosed = true;
        LOG.debug("Filesystem {} is closed", (Object)this.uri);
        try {
            super.close();
        }
        finally {
            if (this.transfers != null) {
                this.transfers.shutdownNow(true);
                this.transfers = null;
            }
            if (this.metadataStore != null) {
                this.metadataStore.close();
                this.metadataStore = null;
            }
            IOUtils.closeQuietly(this.instrumentation);
            this.instrumentation = null;
        }
    }

    private void checkNotClosed() throws IOException {
        if (this.isClosed) {
            throw new IOException(this.uri + ": " + "FileSystem is closed!");
        }
    }

    @Override
    public String getCanonicalServiceName() {
        return null;
    }

    private void copyFile(String srcKey, String dstKey, long size) throws IOException, InterruptedIOException {
        LOG.debug("copyFile {} -> {} ", (Object)srcKey, (Object)dstKey);
        ProgressListener progressListener = progressEvent -> {
            switch (progressEvent.getEventType()) {
                case TRANSFER_PART_COMPLETED_EVENT: {
                    this.incrementWriteOperations();
                    break;
                }
            }
        };
        Invoker.once("copyFile(" + srcKey + ", " + dstKey + ")", srcKey, () -> {
            ObjectMetadata srcom = this.getObjectMetadata(srcKey);
            ObjectMetadata dstom = this.cloneObjectMetadata(srcom);
            this.setOptionalObjectMetadata(dstom);
            CopyObjectRequest copyObjectRequest = new CopyObjectRequest(this.bucket, srcKey, this.bucket, dstKey);
            this.setOptionalCopyObjectRequestParameters(copyObjectRequest);
            copyObjectRequest.setCannedAccessControlList(this.cannedACL);
            copyObjectRequest.setNewObjectMetadata(dstom);
            Copy copy = this.transfers.copy(copyObjectRequest);
            copy.addProgressListener(progressListener);
            try {
                copy.waitForCopyResult();
                this.incrementWriteOperations();
                this.instrumentation.filesCopied(1, size);
            }
            catch (InterruptedException e) {
                throw new InterruptedIOException("Interrupted copying " + srcKey + " to " + dstKey + ", cancelling");
            }
        });
    }

    protected void setOptionalMultipartUploadRequestParameters(InitiateMultipartUploadRequest req) {
        switch (this.serverSideEncryptionAlgorithm) {
            case SSE_KMS: {
                req.setSSEAwsKeyManagementParams(this.generateSSEAwsKeyParams());
                break;
            }
            case SSE_C: {
                if (!StringUtils.isNotBlank(S3AUtils.getServerSideEncryptionKey(this.bucket, this.getConf()))) break;
                req.setSSECustomerKey(this.generateSSECustomerKey());
                break;
            }
        }
    }

    protected void setOptionalUploadPartRequestParameters(UploadPartRequest request) {
        switch (this.serverSideEncryptionAlgorithm) {
            case SSE_C: {
                if (!StringUtils.isNotBlank(S3AUtils.getServerSideEncryptionKey(this.bucket, this.getConf()))) break;
                request.setSSECustomerKey(this.generateSSECustomerKey());
                break;
            }
        }
    }

    InitiateMultipartUploadResult initiateMultipartUpload(InitiateMultipartUploadRequest request) throws IOException {
        LOG.debug("Initiate multipart upload to {}", (Object)request.getKey());
        this.incrementStatistic(Statistic.OBJECT_MULTIPART_UPLOAD_INITIATED);
        return this.getAmazonS3Client().initiateMultipartUpload(request);
    }

    protected void setOptionalCopyObjectRequestParameters(CopyObjectRequest copyObjectRequest) throws IOException {
        switch (this.serverSideEncryptionAlgorithm) {
            case SSE_KMS: {
                copyObjectRequest.setSSEAwsKeyManagementParams(this.generateSSEAwsKeyParams());
                break;
            }
            case SSE_C: {
                if (!StringUtils.isNotBlank(S3AUtils.getServerSideEncryptionKey(this.bucket, this.getConf()))) break;
                SSECustomerKey customerKey = this.generateSSECustomerKey();
                copyObjectRequest.setSourceSSECustomerKey(customerKey);
                copyObjectRequest.setDestinationSSECustomerKey(customerKey);
                break;
            }
        }
    }

    private void setOptionalPutRequestParameters(PutObjectRequest request) {
        switch (this.serverSideEncryptionAlgorithm) {
            case SSE_KMS: {
                request.setSSEAwsKeyManagementParams(this.generateSSEAwsKeyParams());
                break;
            }
            case SSE_C: {
                if (!StringUtils.isNotBlank(S3AUtils.getServerSideEncryptionKey(this.bucket, this.getConf()))) break;
                request.setSSECustomerKey(this.generateSSECustomerKey());
                break;
            }
        }
    }

    private void setOptionalObjectMetadata(ObjectMetadata metadata) {
        if (S3AEncryptionMethods.SSE_S3.equals((Object)this.serverSideEncryptionAlgorithm)) {
            metadata.setSSEAlgorithm(this.serverSideEncryptionAlgorithm.getMethod());
        }
    }

    private SSEAwsKeyManagementParams generateSSEAwsKeyParams() {
        SSEAwsKeyManagementParams sseAwsKeyManagementParams = new SSEAwsKeyManagementParams();
        String encryptionKey = S3AUtils.getServerSideEncryptionKey(this.bucket, this.getConf());
        if (StringUtils.isNotBlank(encryptionKey)) {
            sseAwsKeyManagementParams = new SSEAwsKeyManagementParams(encryptionKey);
        }
        return sseAwsKeyManagementParams;
    }

    private SSECustomerKey generateSSECustomerKey() {
        SSECustomerKey customerKey = new SSECustomerKey(S3AUtils.getServerSideEncryptionKey(this.bucket, this.getConf()));
        return customerKey;
    }

    @InterfaceAudience.Private
    void finishedWrite(String key, long length) {
        LOG.debug("Finished write to {}, len {}", (Object)key, (Object)length);
        Path p = this.keyToQualifiedPath(key);
        Preconditions.checkArgument(length >= 0L, "content length is negative");
        this.deleteUnnecessaryFakeDirectories(p.getParent());
        try {
            if (this.hasMetadataStore()) {
                S3Guard.addAncestors(this.metadataStore, p, this.username);
                S3AFileStatus status = S3AUtils.createUploadFileStatus(p, S3AUtils.objectRepresentsDirectory(key, length), length, this.getDefaultBlockSize(p), this.username);
                S3Guard.putAndReturn(this.metadataStore, status, this.instrumentation);
            }
        }
        catch (IOException e) {
            LOG.error("S3Guard: Error updating MetadataStore for write to {}:", (Object)key, (Object)e);
            this.instrumentation.errorIgnored();
        }
    }

    private void deleteUnnecessaryFakeDirectories(Path path) {
        block4: {
            ArrayList<DeleteObjectsRequest.KeyVersion> keysToRemove = new ArrayList<DeleteObjectsRequest.KeyVersion>();
            while (!path.isRoot()) {
                String key = this.pathToKey(path);
                key = key.endsWith("/") ? key : key + "/";
                LOG.trace("To delete unnecessary fake directory {} for {}", (Object)key, (Object)path);
                keysToRemove.add(new DeleteObjectsRequest.KeyVersion(key));
                path = path.getParent();
            }
            try {
                this.removeKeys(keysToRemove, false, true);
            }
            catch (IOException | AmazonClientException e) {
                this.instrumentation.errorIgnored();
                if (!LOG.isDebugEnabled()) break block4;
                StringBuilder sb = new StringBuilder();
                for (DeleteObjectsRequest.KeyVersion kv : keysToRemove) {
                    sb.append(kv.getKey()).append(",");
                }
                LOG.debug("While deleting keys {} ", (Object)sb.toString(), (Object)e);
            }
        }
    }

    private void createFakeDirectory(String objectName) throws IOException {
        if (!objectName.endsWith("/")) {
            this.createEmptyObject(objectName + "/");
        } else {
            this.createEmptyObject(objectName);
        }
    }

    private void createEmptyObject(String objectName) throws IOException {
        InputStream im = new InputStream(){

            @Override
            public int read() throws IOException {
                return -1;
            }
        };
        PutObjectRequest putObjectRequest = this.newPutObjectRequest(objectName, this.newObjectMetadata(0L), im);
        this.invoker.retry("PUT 0-byte object ", objectName, true, () -> this.putObjectDirect(putObjectRequest));
        this.incrementPutProgressStatistics(objectName, 0L);
        this.instrumentation.directoryCreated();
    }

    private ObjectMetadata cloneObjectMetadata(ObjectMetadata source) {
        ObjectMetadata ret = this.newObjectMetadata(source.getContentLength());
        if (source.getCacheControl() != null) {
            ret.setCacheControl(source.getCacheControl());
        }
        if (source.getContentDisposition() != null) {
            ret.setContentDisposition(source.getContentDisposition());
        }
        if (source.getContentEncoding() != null) {
            ret.setContentEncoding(source.getContentEncoding());
        }
        if (source.getContentMD5() != null) {
            ret.setContentMD5(source.getContentMD5());
        }
        if (source.getContentType() != null) {
            ret.setContentType(source.getContentType());
        }
        if (source.getExpirationTime() != null) {
            ret.setExpirationTime(source.getExpirationTime());
        }
        if (source.getExpirationTimeRuleId() != null) {
            ret.setExpirationTimeRuleId(source.getExpirationTimeRuleId());
        }
        if (source.getHttpExpiresDate() != null) {
            ret.setHttpExpiresDate(source.getHttpExpiresDate());
        }
        if (source.getLastModified() != null) {
            ret.setLastModified(source.getLastModified());
        }
        if (source.getOngoingRestore() != null) {
            ret.setOngoingRestore(source.getOngoingRestore());
        }
        if (source.getRestoreExpirationTime() != null) {
            ret.setRestoreExpirationTime(source.getRestoreExpirationTime());
        }
        if (source.getSSEAlgorithm() != null) {
            ret.setSSEAlgorithm(source.getSSEAlgorithm());
        }
        if (source.getSSECustomerAlgorithm() != null) {
            ret.setSSECustomerAlgorithm(source.getSSECustomerAlgorithm());
        }
        if (source.getSSECustomerKeyMd5() != null) {
            ret.setSSECustomerKeyMd5(source.getSSECustomerKeyMd5());
        }
        for (Map.Entry<String, String> e : source.getUserMetadata().entrySet()) {
            ret.addUserMetadata(e.getKey(), e.getValue());
        }
        return ret;
    }

    @Override
    @Deprecated
    public long getDefaultBlockSize() {
        return this.getConf().getLongBytes("fs.s3a.block.size", 0x2000000L);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("S3AFileSystem{");
        sb.append("uri=").append(this.uri);
        sb.append(", workingDir=").append(this.workingDir);
        sb.append(", inputPolicy=").append((Object)this.inputPolicy);
        sb.append(", partSize=").append(this.partSize);
        sb.append(", enableMultiObjectsDelete=").append(this.enableMultiObjectsDelete);
        sb.append(", maxKeys=").append(this.maxKeys);
        if (this.cannedACL != null) {
            sb.append(", cannedACL=").append(this.cannedACL.toString());
        }
        sb.append(", readAhead=").append(this.readAhead);
        if (this.getConf() != null) {
            sb.append(", blockSize=").append(this.getDefaultBlockSize());
        }
        sb.append(", multiPartThreshold=").append(this.multiPartThreshold);
        if (this.serverSideEncryptionAlgorithm != null) {
            sb.append(", serverSideEncryptionAlgorithm='").append((Object)this.serverSideEncryptionAlgorithm).append('\'');
        }
        if (this.blockFactory != null) {
            sb.append(", blockFactory=").append(this.blockFactory);
        }
        sb.append(", metastore=").append(this.metadataStore);
        sb.append(", authoritative=").append(this.allowAuthoritative);
        sb.append(", useListV1=").append(this.useListV1);
        if (this.committerIntegration != null) {
            sb.append(", magicCommitter=").append(this.isMagicCommitEnabled());
        }
        sb.append(", boundedExecutor=").append(this.boundedThreadPool);
        sb.append(", unboundedExecutor=").append(this.unboundedThreadPool);
        sb.append(", statistics {").append(this.statistics).append("}");
        if (this.instrumentation != null) {
            sb.append(", metrics {").append(this.instrumentation.dump("{", "=", "} ", true)).append("}");
        }
        sb.append('}');
        return sb.toString();
    }

    public long getPartitionSize() {
        return this.partSize;
    }

    public long getMultiPartThreshold() {
        return this.multiPartThreshold;
    }

    int getMaxKeys() {
        return this.maxKeys;
    }

    public boolean isMagicCommitEnabled() {
        return this.committerIntegration.isMagicCommitEnabled();
    }

    public boolean isMagicCommitPath(Path path) {
        return this.committerIntegration.isMagicCommitPath(path);
    }

    @Override
    public FileStatus[] globStatus(Path pathPattern) throws IOException {
        this.entryPoint(Statistic.INVOCATION_GLOB_STATUS);
        return super.globStatus(pathPattern);
    }

    @Override
    public FileStatus[] globStatus(Path pathPattern, PathFilter filter) throws IOException {
        this.entryPoint(Statistic.INVOCATION_GLOB_STATUS);
        return super.globStatus(pathPattern, filter);
    }

    @Override
    public boolean exists(Path f) throws IOException {
        this.entryPoint(Statistic.INVOCATION_EXISTS);
        return super.exists(f);
    }

    @Override
    public boolean isDirectory(Path f) throws IOException {
        this.entryPoint(Statistic.INVOCATION_IS_DIRECTORY);
        return super.isDirectory(f);
    }

    @Override
    public boolean isFile(Path f) throws IOException {
        this.entryPoint(Statistic.INVOCATION_IS_FILE);
        return super.isFile(f);
    }

    @Override
    public EtagChecksum getFileChecksum(Path f, long length) throws IOException {
        Preconditions.checkArgument(length >= 0L);
        this.entryPoint(Statistic.INVOCATION_GET_FILE_CHECKSUM);
        if (this.getConf().getBoolean("fs.s3a.etag.checksum.enabled", false)) {
            Path path = this.qualify(f);
            LOG.debug("getFileChecksum({})", (Object)path);
            return Invoker.once("getFileChecksum", path.toString(), () -> {
                ObjectMetadata headers = this.getObjectMetadata(path);
                String eTag = headers.getETag();
                return eTag != null ? new EtagChecksum(eTag) : null;
            });
        }
        return null;
    }

    @Override
    public RemoteIterator<LocatedFileStatus> listFiles(Path f, boolean recursive) throws FileNotFoundException, IOException {
        return this.innerListFiles(f, recursive, new Listing.AcceptFilesOnly(this.qualify(f)));
    }

    public RemoteIterator<LocatedFileStatus> listFilesAndEmptyDirectories(Path f, boolean recursive) throws IOException {
        return this.innerListFiles(f, recursive, new Listing.AcceptAllButS3nDirs());
    }

    private RemoteIterator<LocatedFileStatus> innerListFiles(Path f, boolean recursive, Listing.FileStatusAcceptor acceptor) throws IOException {
        this.entryPoint(Statistic.INVOCATION_LIST_FILES);
        Path path = this.qualify(f);
        LOG.debug("listFiles({}, {})", (Object)path, (Object)recursive);
        try {
            RemoteIterator<FileStatus> cachedFilesIterator;
            Set<Path> tombstones;
            FileStatus fileStatus = this.getFileStatus(path);
            if (fileStatus.isFile()) {
                LOG.debug("Path is a file");
                return new Listing.SingleStatusRemoteIterator(this.toLocatedFileStatus(fileStatus));
            }
            String key = this.maybeAddTrailingSlash(this.pathToKey(path));
            String delimiter = recursive ? null : "/";
            LOG.debug("Requesting all entries under {} with delimiter '{}'", (Object)key, (Object)delimiter);
            if (recursive) {
                PathMetadata pm = this.metadataStore.get(path, true);
                MetadataStoreListFilesIterator metadataStoreListFilesIterator = new MetadataStoreListFilesIterator(this.metadataStore, pm, this.allowAuthoritative);
                tombstones = metadataStoreListFilesIterator.listTombstones();
                cachedFilesIterator = metadataStoreListFilesIterator;
            } else {
                DirListingMetadata meta = this.metadataStore.listChildren(path);
                tombstones = meta != null ? meta.listTombstones() : null;
                cachedFilesIterator = this.listing.createProvidedFileStatusIterator(S3Guard.dirMetaToStatuses(meta), S3AUtils.ACCEPT_ALL, acceptor);
                if (this.allowAuthoritative && meta != null && meta.isAuthoritative()) {
                    return this.listing.createLocatedFileStatusIterator(cachedFilesIterator);
                }
            }
            return this.listing.createTombstoneReconcilingIterator(this.listing.createLocatedFileStatusIterator(this.listing.createFileStatusListingIterator(path, this.createListObjectsRequest(key, delimiter), S3AUtils.ACCEPT_ALL, acceptor, cachedFilesIterator)), tombstones);
        }
        catch (AmazonClientException e) {
            throw S3AUtils.translateException("listFiles", path, e);
        }
    }

    @Override
    public RemoteIterator<LocatedFileStatus> listLocatedStatus(Path f) throws FileNotFoundException, IOException {
        return this.listLocatedStatus(f, S3AUtils.ACCEPT_ALL);
    }

    @Override
    public RemoteIterator<LocatedFileStatus> listLocatedStatus(Path f, PathFilter filter) throws FileNotFoundException, IOException {
        this.entryPoint(Statistic.INVOCATION_LIST_LOCATED_STATUS);
        Path path = this.qualify(f);
        LOG.debug("listLocatedStatus({}, {}", (Object)path, (Object)filter);
        return Invoker.once("listLocatedStatus", path.toString(), () -> {
            FileStatus fileStatus = this.getFileStatus(path);
            if (fileStatus.isFile()) {
                LOG.debug("Path is a file");
                return new Listing.SingleStatusRemoteIterator(filter.accept(path) ? this.toLocatedFileStatus(fileStatus) : null);
            }
            String key = this.maybeAddTrailingSlash(this.pathToKey(path));
            Listing.AcceptAllButSelfAndS3nDirs acceptor = new Listing.AcceptAllButSelfAndS3nDirs(path);
            DirListingMetadata meta = this.metadataStore.listChildren(path);
            Listing.ProvidedFileStatusIterator cachedFileStatusIterator = this.listing.createProvidedFileStatusIterator(S3Guard.dirMetaToStatuses(meta), filter, acceptor);
            return this.allowAuthoritative && meta != null && meta.isAuthoritative() ? this.listing.createLocatedFileStatusIterator(cachedFileStatusIterator) : this.listing.createLocatedFileStatusIterator(this.listing.createFileStatusListingIterator(path, this.createListObjectsRequest(key, "/"), filter, acceptor, cachedFileStatusIterator));
        });
    }

    LocatedFileStatus toLocatedFileStatus(FileStatus status) throws IOException {
        return new LocatedFileStatus(status, status.isFile() ? this.getFileBlockLocations(status, 0L, status.getLen()) : null);
    }

    public MultipartUtils.UploadIterator listUploads(@Nullable String prefix) throws IOException {
        return MultipartUtils.listMultipartUploads(this.s3, this.invoker, this.bucket, this.maxKeys, prefix);
    }

    @InterfaceAudience.Private
    public List<MultipartUpload> listMultipartUploads(String prefix) throws IOException {
        ListMultipartUploadsRequest request = new ListMultipartUploadsRequest(this.bucket);
        if (!prefix.isEmpty()) {
            if (!prefix.endsWith("/")) {
                prefix = prefix + "/";
            }
            request.setPrefix(prefix);
        }
        return this.invoker.retry("listMultipartUploads", prefix, true, () -> this.s3.listMultipartUploads(request).getMultipartUploads());
    }

    void abortMultipartUpload(String destKey, String uploadId) {
        LOG.info("Aborting multipart upload {} to {}", (Object)uploadId, (Object)destKey);
        this.getAmazonS3Client().abortMultipartUpload(new AbortMultipartUploadRequest(this.getBucket(), destKey, uploadId));
    }

    void abortMultipartUpload(MultipartUpload upload) {
        String destKey = upload.getKey();
        String uploadId = upload.getUploadId();
        if (LOG.isInfoEnabled()) {
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            LOG.info("Aborting multipart upload {} to {} initiated by {} on {}", new Object[]{uploadId, destKey, upload.getInitiator(), df.format(upload.getInitiated())});
        }
        this.getAmazonS3Client().abortMultipartUpload(new AbortMultipartUploadRequest(this.getBucket(), destKey, uploadId));
    }

    public S3AInstrumentation.CommitterStatistics newCommitterStatistics() {
        return this.instrumentation.newCommitterStatistics();
    }

    @Override
    public boolean hasCapability(String capability) {
        switch (capability.toLowerCase(Locale.ENGLISH)) {
            case "s3a:magic.committer": {
                return this.isMagicCommitEnabled();
            }
        }
        return false;
    }

    static {
        S3AFileSystem.addDeprecatedKeys();
    }
}

