/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.s3a;

import java.io.EOFException;
import java.io.IOException;
import org.apache.flink.fs.s3base.shaded.com.amazonaws.services.s3.AmazonS3;
import org.apache.flink.fs.s3base.shaded.com.amazonaws.services.s3.model.GetObjectRequest;
import org.apache.flink.fs.s3base.shaded.com.amazonaws.services.s3.model.S3Object;
import org.apache.flink.fs.s3base.shaded.com.amazonaws.services.s3.model.S3ObjectInputStream;
import org.apache.flink.fs.s3base.shaded.com.amazonaws.services.s3.model.SSECustomerKey;
import org.apache.flink.fs.s3base.shaded.com.google.common.base.Preconditions;
import org.apache.flink.fs.shaded.hadoop3.org.apache.commons.lang.StringUtils;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.classification.InterfaceAudience;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.classification.InterfaceStability;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.CanSetReadahead;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.FSInputStream;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.s3a.Invoker;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.s3a.S3AEncryptionMethods;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.s3a.S3AInputPolicy;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.s3a.S3AInstrumentation;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.s3a.S3AReadOpContext;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.s3a.S3ObjectAttributes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class S3AInputStream
extends FSInputStream
implements CanSetReadahead {
    private long pos;
    private volatile boolean closed;
    private S3ObjectInputStream wrappedStream;
    private final S3AReadOpContext context;
    private final AmazonS3 client;
    private final String bucket;
    private final String key;
    private final String pathStr;
    private final long contentLength;
    private final String uri;
    private static final Logger LOG = LoggerFactory.getLogger(S3AInputStream.class);
    private final S3AInstrumentation.InputStreamStatistics streamStatistics;
    private S3AEncryptionMethods serverSideEncryptionAlgorithm;
    private String serverSideEncryptionKey;
    private S3AInputPolicy inputPolicy;
    private long readahead = 65536L;
    private long nextReadPos;
    private long contentRangeFinish;
    private long contentRangeStart;

    public S3AInputStream(S3AReadOpContext ctx, S3ObjectAttributes s3Attributes, long contentLength, AmazonS3 client, long readahead, S3AInputPolicy inputPolicy) {
        Preconditions.checkArgument(org.apache.flink.fs.shaded.hadoop3.org.apache.commons.lang3.StringUtils.isNotEmpty(s3Attributes.getBucket()), "No Bucket");
        Preconditions.checkArgument(org.apache.flink.fs.shaded.hadoop3.org.apache.commons.lang3.StringUtils.isNotEmpty(s3Attributes.getKey()), "No Key");
        Preconditions.checkArgument(contentLength >= 0L, "Negative content length");
        this.context = ctx;
        this.bucket = s3Attributes.getBucket();
        this.key = s3Attributes.getKey();
        this.pathStr = ctx.dstFileStatus.getPath().toString();
        this.contentLength = contentLength;
        this.client = client;
        this.uri = "s3a://" + this.bucket + "/" + this.key;
        this.streamStatistics = ctx.instrumentation.newInputStreamStatistics();
        this.serverSideEncryptionAlgorithm = s3Attributes.getServerSideEncryptionAlgorithm();
        this.serverSideEncryptionKey = s3Attributes.getServerSideEncryptionKey();
        this.setInputPolicy(inputPolicy);
        this.setReadahead(readahead);
    }

    private void setInputPolicy(S3AInputPolicy inputPolicy) {
        this.inputPolicy = inputPolicy;
        this.streamStatistics.inputPolicySet(inputPolicy.ordinal());
    }

    private synchronized void reopen(String reason, long targetPos, long length) throws IOException {
        if (this.wrappedStream != null) {
            this.closeStream("reopen(" + reason + ")", this.contentRangeFinish, false);
        }
        this.contentRangeFinish = S3AInputStream.calculateRequestLimit(this.inputPolicy, targetPos, length, this.contentLength, this.readahead);
        LOG.debug("reopen({}) for {} range[{}-{}], length={}, streamPosition={}, nextReadPosition={}, policy={}", new Object[]{this.uri, reason, targetPos, this.contentRangeFinish, length, this.pos, this.nextReadPos, this.inputPolicy});
        long opencount = this.streamStatistics.streamOpened();
        GetObjectRequest request = new GetObjectRequest(this.bucket, this.key).withRange(targetPos, this.contentRangeFinish - 1L);
        if (S3AEncryptionMethods.SSE_C.equals((Object)this.serverSideEncryptionAlgorithm) && StringUtils.isNotBlank(this.serverSideEncryptionKey)) {
            request.setSSECustomerKey(new SSECustomerKey(this.serverSideEncryptionKey));
        }
        String text = String.format("Failed to %s %s at %d", opencount == 0L ? "open" : "re-open", this.uri, targetPos);
        this.context.getReadInvoker();
        S3Object object = Invoker.once(text, this.uri, () -> this.client.getObject(request));
        this.wrappedStream = object.getObjectContent();
        this.contentRangeStart = targetPos;
        if (this.wrappedStream == null) {
            throw new IOException("Null IO stream from reopen of (" + reason + ") " + this.uri);
        }
        this.pos = targetPos;
    }

    @Override
    public synchronized long getPos() throws IOException {
        return this.nextReadPos < 0L ? 0L : this.nextReadPos;
    }

    @Override
    public synchronized void seek(long targetPos) throws IOException {
        this.checkNotClosed();
        if (targetPos < 0L) {
            throw new EOFException("Cannot seek to a negative offset " + targetPos);
        }
        if (this.contentLength <= 0L) {
            return;
        }
        this.nextReadPos = targetPos;
    }

    private void seekQuietly(long positiveTargetPos) {
        try {
            this.seek(positiveTargetPos);
        }
        catch (IOException ioe) {
            LOG.debug("Ignoring IOE on seek of {} to {}", new Object[]{this.uri, positiveTargetPos, ioe});
        }
    }

    private void seekInStream(long targetPos, long length) throws IOException {
        this.checkNotClosed();
        if (this.wrappedStream == null) {
            return;
        }
        long diff = targetPos - this.pos;
        if (diff > 0L) {
            boolean skipForward;
            int available = this.wrappedStream.available();
            long forwardSeekRange = Math.max(this.readahead, (long)available);
            long remainingInCurrentRequest = this.remainingInCurrentRequest();
            long forwardSeekLimit = Math.min(remainingInCurrentRequest, forwardSeekRange);
            boolean bl = skipForward = remainingInCurrentRequest > 0L && diff <= forwardSeekLimit;
            if (skipForward) {
                LOG.debug("Forward seek on {}, of {} bytes", (Object)this.uri, (Object)diff);
                this.streamStatistics.seekForwards(diff);
                long skipped = this.wrappedStream.skip(diff);
                if (skipped > 0L) {
                    this.pos += skipped;
                    this.incrementBytesRead(diff);
                }
                if (this.pos == targetPos) {
                    return;
                }
                LOG.warn("Failed to seek on {} to {}. Current position {}", new Object[]{this.uri, targetPos, this.pos});
            }
        } else if (diff < 0L) {
            this.streamStatistics.seekBackwards(diff);
            if (this.inputPolicy.equals((Object)S3AInputPolicy.Normal)) {
                LOG.info("Switching to Random IO seek policy");
                this.setInputPolicy(S3AInputPolicy.Random);
            }
        } else if (this.remainingInCurrentRequest() > 0L) {
            return;
        }
        this.closeStream("seekInStream()", this.contentRangeFinish, false);
        this.pos = targetPos;
    }

    @Override
    public boolean seekToNewSource(long targetPos) throws IOException {
        return false;
    }

    private void lazySeek(long targetPos, long len) throws IOException {
        Invoker invoker = this.context.getReadInvoker();
        invoker.retry("lazySeek", this.pathStr, true, () -> {
            this.seekInStream(targetPos, len);
            if (this.wrappedStream == null) {
                this.reopen("read from new offset", targetPos, len);
            }
        });
    }

    private void incrementBytesRead(long bytesRead) {
        this.streamStatistics.bytesRead(bytesRead);
        if (this.context.stats != null && bytesRead > 0L) {
            this.context.stats.incrementBytesRead(bytesRead);
        }
    }

    @Override
    public synchronized int read() throws IOException {
        this.checkNotClosed();
        if (this.contentLength == 0L || this.nextReadPos >= this.contentLength) {
            return -1;
        }
        try {
            this.lazySeek(this.nextReadPos, 1L);
        }
        catch (EOFException e) {
            return -1;
        }
        Invoker invoker = this.context.getReadInvoker();
        int byteRead = invoker.retry("read", this.pathStr, true, () -> {
            int b;
            try {
                b = this.wrappedStream.read();
            }
            catch (EOFException e) {
                return -1;
            }
            catch (IOException e) {
                this.onReadFailure(e, 1);
                b = this.wrappedStream.read();
            }
            return b;
        });
        if (byteRead >= 0) {
            ++this.pos;
            ++this.nextReadPos;
        }
        if (byteRead >= 0) {
            this.incrementBytesRead(1L);
        }
        return byteRead;
    }

    private void onReadFailure(IOException ioe, int length) throws IOException {
        LOG.info("Got exception while trying to read from stream {} trying to recover: " + ioe, (Object)this.uri);
        this.streamStatistics.readException();
        this.reopen("failure recovery", this.pos, length);
    }

    @Override
    public synchronized int read(byte[] buf, int off, int len) throws IOException {
        this.checkNotClosed();
        this.validatePositionedReadArgs(this.nextReadPos, buf, off, len);
        if (len == 0) {
            return 0;
        }
        if (this.contentLength == 0L || this.nextReadPos >= this.contentLength) {
            return -1;
        }
        try {
            this.lazySeek(this.nextReadPos, len);
        }
        catch (EOFException e) {
            return -1;
        }
        Invoker invoker = this.context.getReadInvoker();
        this.streamStatistics.readOperationStarted(this.nextReadPos, len);
        int bytesRead = invoker.retry("read", this.pathStr, true, () -> {
            int bytes;
            try {
                bytes = this.wrappedStream.read(buf, off, len);
            }
            catch (EOFException e) {
                return -1;
            }
            catch (IOException e) {
                this.onReadFailure(e, len);
                bytes = this.wrappedStream.read(buf, off, len);
            }
            return bytes;
        });
        if (bytesRead > 0) {
            this.pos += (long)bytesRead;
            this.nextReadPos += (long)bytesRead;
        }
        this.incrementBytesRead(bytesRead);
        this.streamStatistics.readOperationCompleted(len, bytesRead);
        return bytesRead;
    }

    private void checkNotClosed() throws IOException {
        if (this.closed) {
            throw new IOException(this.uri + ": " + "Stream is closed!");
        }
    }

    @Override
    public synchronized void close() throws IOException {
        if (!this.closed) {
            this.closed = true;
            try {
                this.closeStream("close() operation", this.contentRangeFinish, false);
                LOG.debug("Statistics of stream {}\n{}", (Object)this.key, (Object)this.streamStatistics);
                super.close();
            }
            finally {
                this.streamStatistics.close();
            }
        }
    }

    private void closeStream(String reason, long length, boolean forceAbort) {
        if (this.wrappedStream != null) {
            boolean shouldAbort;
            long remaining = this.remainingInCurrentRequest();
            LOG.debug("Closing stream {}: {}", (Object)reason, (Object)(forceAbort ? "abort" : "soft"));
            boolean bl = shouldAbort = forceAbort || remaining > this.readahead;
            if (!shouldAbort) {
                try {
                    long drained = 0L;
                    while (this.wrappedStream.read() >= 0) {
                        ++drained;
                    }
                    LOG.debug("Drained stream of {} bytes", (Object)drained);
                    this.wrappedStream.close();
                    this.streamStatistics.streamClose(false, drained);
                }
                catch (IOException e) {
                    LOG.debug("When closing {} stream for {}", new Object[]{this.uri, reason, e});
                    shouldAbort = true;
                }
            }
            if (shouldAbort) {
                LOG.debug("Aborting stream");
                this.wrappedStream.abort();
                this.streamStatistics.streamClose(true, remaining);
            }
            LOG.debug("Stream {} {}: {}; remaining={} streamPos={}, nextReadPos={}, request range {}-{} length={}", new Object[]{this.uri, shouldAbort ? "aborted" : "closed", reason, remaining, this.pos, this.nextReadPos, this.contentRangeStart, this.contentRangeFinish, length});
            this.wrappedStream = null;
        }
    }

    @InterfaceStability.Unstable
    public synchronized boolean resetConnection() throws IOException {
        boolean connectionOpen;
        this.checkNotClosed();
        boolean bl = connectionOpen = this.wrappedStream != null;
        if (connectionOpen) {
            LOG.info("Forced reset of connection to {}", (Object)this.uri);
            this.closeStream("reset()", this.contentRangeFinish, true);
        }
        return connectionOpen;
    }

    @Override
    public synchronized int available() throws IOException {
        this.checkNotClosed();
        long remaining = this.remainingInFile();
        if (remaining > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)remaining;
    }

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public synchronized long remainingInFile() {
        return this.contentLength - this.pos;
    }

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public synchronized long remainingInCurrentRequest() {
        return this.contentRangeFinish - this.pos;
    }

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public synchronized long getContentRangeFinish() {
        return this.contentRangeFinish;
    }

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public synchronized long getContentRangeStart() {
        return this.contentRangeStart;
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InterfaceStability.Unstable
    public String toString() {
        String s = this.streamStatistics.toString();
        S3AInputStream s3AInputStream = this;
        synchronized (s3AInputStream) {
            StringBuilder sb = new StringBuilder("S3AInputStream{");
            sb.append(this.uri);
            sb.append(" wrappedStream=").append(this.wrappedStream != null ? "open" : "closed");
            sb.append(" read policy=").append((Object)this.inputPolicy);
            sb.append(" pos=").append(this.pos);
            sb.append(" nextReadPos=").append(this.nextReadPos);
            sb.append(" contentLength=").append(this.contentLength);
            sb.append(" contentRangeStart=").append(this.contentRangeStart);
            sb.append(" contentRangeFinish=").append(this.contentRangeFinish);
            sb.append(" remainingInCurrentRequest=").append(this.remainingInCurrentRequest());
            sb.append('\n').append(s);
            sb.append('}');
            return sb.toString();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void readFully(long position, byte[] buffer, int offset, int length) throws IOException {
        this.checkNotClosed();
        this.validatePositionedReadArgs(position, buffer, offset, length);
        this.streamStatistics.readFullyOperationStarted(position, length);
        if (length == 0) {
            return;
        }
        S3AInputStream s3AInputStream = this;
        synchronized (s3AInputStream) {
            long oldPos = this.getPos();
            try {
                int nbytes;
                this.seek(position);
                for (int nread = 0; nread < length; nread += nbytes) {
                    nbytes = this.read(buffer, offset + nread, length - nread);
                    if (nbytes >= 0) continue;
                    throw new EOFException("End of file reached before reading fully.");
                }
            }
            finally {
                this.seekQuietly(oldPos);
            }
        }
    }

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public S3AInstrumentation.InputStreamStatistics getS3AStreamStatistics() {
        return this.streamStatistics;
    }

    @Override
    public synchronized void setReadahead(Long readahead) {
        if (readahead == null) {
            this.readahead = 65536L;
        } else {
            Preconditions.checkArgument(readahead >= 0L, "Negative readahead value");
            this.readahead = readahead;
        }
    }

    public synchronized long getReadahead() {
        return this.readahead;
    }

    static long calculateRequestLimit(S3AInputPolicy inputPolicy, long targetPos, long length, long contentLength, long readahead) {
        long rangeLimit;
        switch (inputPolicy) {
            case Random: {
                rangeLimit = length < 0L ? contentLength : targetPos + Math.max(readahead, length);
                break;
            }
            case Sequential: {
                rangeLimit = contentLength;
                break;
            }
            default: {
                rangeLimit = contentLength;
            }
        }
        rangeLimit = Math.min(contentLength, rangeLimit);
        return rangeLimit;
    }
}

