/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.s3a;

import java.io.EOFException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.NoRouteToHostException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.nio.file.AccessDeniedException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.flink.fs.s3base.shaded.com.amazonaws.AmazonClientException;
import org.apache.flink.fs.s3base.shaded.com.amazonaws.SdkBaseException;
import org.apache.flink.fs.s3base.shaded.com.amazonaws.services.dynamodbv2.model.ProvisionedThroughputExceededException;
import org.apache.flink.fs.s3base.shaded.com.google.common.base.Preconditions;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.conf.Configuration;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.InvalidRequestException;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.s3a.AWSBadRequestException;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.s3a.AWSClientIOException;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.s3a.AWSNoResponseException;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.s3a.AWSRedirectException;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.s3a.AWSS3IOException;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.s3a.AWSServiceIOException;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.s3a.AWSServiceThrottledException;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.s3a.AWSStatus500Exception;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.s3a.S3AUtils;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.io.retry.RetryPolicies;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.io.retry.RetryPolicy;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.net.ConnectTimeoutException;

public class S3ARetryPolicy
implements RetryPolicy {
    private final RetryPolicy retryPolicy;
    protected final RetryPolicy fixedRetries;
    protected final RetryPolicy retryIdempotentCalls;
    protected final RetryPolicy throttlePolicy;
    protected final RetryPolicy fail = RetryPolicies.TRY_ONCE_THEN_FAIL;
    protected final RetryPolicy connectivityFailure;

    public S3ARetryPolicy(Configuration conf) {
        Preconditions.checkArgument(conf != null, "Null configuration");
        this.fixedRetries = RetryPolicies.retryUpToMaximumCountWithFixedSleep(conf.getInt("fs.s3a.retry.limit", 20), conf.getTimeDuration("fs.s3a.retry.interval", "500ms", TimeUnit.MILLISECONDS), TimeUnit.MILLISECONDS);
        this.retryIdempotentCalls = new FailNonIOEs(new IdempotencyRetryFilter(this.fixedRetries));
        this.throttlePolicy = RetryPolicies.exponentialBackoffRetry(conf.getInt("fs.s3a.retry.throttle.limit", 20), conf.getTimeDuration("fs.s3a.retry.throttle.interval", "500ms", TimeUnit.MILLISECONDS), TimeUnit.MILLISECONDS);
        this.connectivityFailure = this.fixedRetries;
        Map<Class<? extends Exception>, RetryPolicy> policyMap = this.createExceptionMap();
        this.retryPolicy = RetryPolicies.retryByException(this.retryIdempotentCalls, policyMap);
    }

    protected Map<Class<? extends Exception>, RetryPolicy> createExceptionMap() {
        HashMap<Class<? extends Exception>, RetryPolicy> policyMap = new HashMap<Class<? extends Exception>, RetryPolicy>();
        policyMap.put(UnknownHostException.class, this.fail);
        policyMap.put(NoRouteToHostException.class, this.fail);
        policyMap.put(InterruptedException.class, this.fail);
        policyMap.put(InterruptedIOException.class, this.fail);
        policyMap.put(AccessDeniedException.class, this.fail);
        policyMap.put(FileNotFoundException.class, this.fail);
        policyMap.put(InvalidRequestException.class, this.fail);
        policyMap.put(AWSRedirectException.class, this.fail);
        policyMap.put(AWSServiceThrottledException.class, this.throttlePolicy);
        policyMap.put(ConnectTimeoutException.class, this.connectivityFailure);
        policyMap.put(EOFException.class, this.retryIdempotentCalls);
        policyMap.put(AWSBadRequestException.class, this.connectivityFailure);
        policyMap.put(AWSStatus500Exception.class, this.connectivityFailure);
        policyMap.put(AWSNoResponseException.class, this.retryIdempotentCalls);
        policyMap.put(AWSClientIOException.class, this.retryIdempotentCalls);
        policyMap.put(AWSServiceIOException.class, this.retryIdempotentCalls);
        policyMap.put(AWSS3IOException.class, this.retryIdempotentCalls);
        policyMap.put(SocketTimeoutException.class, this.retryIdempotentCalls);
        policyMap.put(ProvisionedThroughputExceededException.class, this.throttlePolicy);
        return policyMap;
    }

    @Override
    public RetryPolicy.RetryAction shouldRetry(Exception exception, int retries, int failovers, boolean idempotent) throws Exception {
        Exception ex = exception;
        if (exception instanceof AmazonClientException) {
            ex = S3AUtils.translateException("", "", (SdkBaseException)((AmazonClientException)exception));
        }
        return this.retryPolicy.shouldRetry(ex, retries, failovers, idempotent);
    }

    private static final class FailNonIOEs
    implements RetryPolicy {
        private final RetryPolicy next;

        private FailNonIOEs(RetryPolicy next) {
            this.next = next;
        }

        @Override
        public RetryPolicy.RetryAction shouldRetry(Exception e, int retries, int failovers, boolean isIdempotentOrAtMostOnce) throws Exception {
            return e instanceof IOException ? this.next.shouldRetry(e, retries, failovers, true) : RetryPolicy.RetryAction.FAIL;
        }
    }

    private static final class IdempotencyRetryFilter
    implements RetryPolicy {
        private final RetryPolicy next;

        IdempotencyRetryFilter(RetryPolicy next) {
            this.next = next;
        }

        @Override
        public RetryPolicy.RetryAction shouldRetry(Exception e, int retries, int failovers, boolean idempotent) throws Exception {
            return idempotent ? this.next.shouldRetry(e, retries, failovers, true) : RetryPolicy.RetryAction.FAIL;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("IdempotencyRetryFilter{");
            sb.append("next=").append(this.next);
            sb.append('}');
            return sb.toString();
        }
    }
}

