/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.s3a.auth;

import java.io.Closeable;
import java.io.IOException;
import java.net.URI;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import org.apache.flink.fs.s3base.shaded.com.amazonaws.auth.AWSCredentials;
import org.apache.flink.fs.s3base.shaded.com.amazonaws.auth.AWSCredentialsProvider;
import org.apache.flink.fs.s3base.shaded.com.amazonaws.auth.STSAssumeRoleSessionCredentialsProvider;
import org.apache.flink.fs.s3base.shaded.com.amazonaws.services.securitytoken.model.AWSSecurityTokenServiceException;
import org.apache.flink.fs.s3base.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.flink.fs.shaded.hadoop3.org.apache.commons.lang.StringUtils;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.classification.InterfaceAudience;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.classification.InterfaceStability;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.conf.Configuration;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.s3a.AWSCredentialProviderList;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.s3a.S3AUtils;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.s3a.SimpleAWSCredentialsProvider;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.security.UserGroupInformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class AssumedRoleCredentialProvider
implements AWSCredentialsProvider,
Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(AssumedRoleCredentialProvider.class);
    public static final String NAME = "org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.s3a.auth.AssumedRoleCredentialProvider";
    static final String E_FORBIDDEN_PROVIDER = "AssumedRoleCredentialProvider cannot be in fs.s3a.assumed.role.credentials.provider";
    public static final String E_NO_ROLE = "Unset property fs.s3a.assumed.role.arn";
    private final STSAssumeRoleSessionCredentialsProvider stsProvider;
    private final String sessionName;
    private final long duration;
    private final String arn;

    public AssumedRoleCredentialProvider(URI uri, Configuration conf) throws IOException {
        String epr;
        this.arn = conf.getTrimmed("fs.s3a.assumed.role.arn", "");
        if (StringUtils.isEmpty(this.arn)) {
            throw new IOException(E_NO_ROLE);
        }
        Class<?>[] awsClasses = S3AUtils.loadAWSProviderClasses(conf, "fs.s3a.assumed.role.credentials.provider", SimpleAWSCredentialsProvider.class);
        AWSCredentialProviderList credentials = new AWSCredentialProviderList();
        for (Class<?> aClass : awsClasses) {
            if (this.getClass().equals(aClass)) {
                throw new IOException(E_FORBIDDEN_PROVIDER);
            }
            credentials.add(S3AUtils.createAWSCredentialProvider(conf, aClass, uri));
        }
        this.sessionName = conf.getTrimmed("fs.s3a.assumed.role.session.name", AssumedRoleCredentialProvider.buildSessionName());
        this.duration = conf.getTimeDuration("fs.s3a.assumed.role.session.duration", "30m", TimeUnit.SECONDS);
        String policy = conf.getTrimmed("fs.s3a.assumed.role.policy", "");
        LOG.debug("{}", (Object)this);
        STSAssumeRoleSessionCredentialsProvider.Builder builder = new STSAssumeRoleSessionCredentialsProvider.Builder(this.arn, this.sessionName);
        builder.withRoleSessionDurationSeconds((int)this.duration);
        if (StringUtils.isNotEmpty(policy)) {
            LOG.debug("Scope down policy {}", (Object)policy);
            builder.withScopeDownPolicy(policy);
        }
        if (StringUtils.isNotEmpty(epr = conf.get("fs.s3a.assumed.role.sts.endpoint", ""))) {
            LOG.debug("STS Endpoint: {}", (Object)epr);
            builder.withServiceEndpoint(epr);
        }
        LOG.debug("Credentials to obtain role credentials: {}", (Object)credentials);
        builder.withLongLivedCredentialsProvider((AWSCredentialsProvider)credentials);
        this.stsProvider = builder.build();
        this.getCredentials();
    }

    @Override
    public AWSCredentials getCredentials() {
        try {
            return this.stsProvider.getCredentials();
        }
        catch (AWSSecurityTokenServiceException e) {
            LOG.error("Failed to get credentials for role {}", (Object)this.arn, (Object)e);
            throw e;
        }
    }

    @Override
    public void refresh() {
        this.stsProvider.refresh();
    }

    @Override
    public void close() {
        this.stsProvider.close();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("AssumedRoleCredentialProvider{");
        sb.append("role='").append(this.arn).append('\'');
        sb.append(", session'").append(this.sessionName).append('\'');
        sb.append(", duration=").append(this.duration);
        sb.append('}');
        return sb.toString();
    }

    static String buildSessionName() throws IOException {
        return AssumedRoleCredentialProvider.sanitize(UserGroupInformation.getCurrentUser().getShortUserName());
    }

    @VisibleForTesting
    static String sanitize(String session) {
        StringBuilder r = new StringBuilder(session.length());
        for (char c : session.toCharArray()) {
            if ("abcdefghijklmnopqrstuvwxyz0123456789,.@-".contains(Character.toString(c).toLowerCase(Locale.ENGLISH))) {
                r.append(c);
                continue;
            }
            r.append('-');
        }
        return r.toString();
    }
}

