/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.s3a.commit;

import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.classification.InterfaceAudience;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.classification.InterfaceStability;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.conf.Configuration;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.Path;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.mapreduce.JobContext;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.mapreduce.JobID;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.mapreduce.TaskAttemptContext;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public final class CommitUtilsWithMR {
    private CommitUtilsWithMR() {
    }

    public static Path getMagicJobAttemptsPath(Path out) {
        return new Path(out, "__magic");
    }

    public static int getAppAttemptId(JobContext context) {
        return context.getConfiguration().getInt("mapreduce.job.application.attempt.id", 0);
    }

    public static Path getMagicJobAttemptPath(int appAttemptId, Path dest) {
        return new Path(CommitUtilsWithMR.getMagicJobAttemptsPath(dest), CommitUtilsWithMR.formatAppAttemptDir(appAttemptId));
    }

    public static String formatAppAttemptDir(int attemptId) {
        return String.format("app-attempt-%04d", attemptId);
    }

    public static Path getMagicTaskAttemptsPath(JobContext context, Path dest) {
        return new Path(CommitUtilsWithMR.getMagicJobAttemptPath(CommitUtilsWithMR.getAppAttemptId(context), dest), "tasks");
    }

    public static Path getMagicTaskAttemptPath(TaskAttemptContext context, Path dest) {
        return new Path(CommitUtilsWithMR.getBaseMagicTaskAttemptPath(context, dest), "__base");
    }

    public static Path getBaseMagicTaskAttemptPath(TaskAttemptContext context, Path dest) {
        return new Path(CommitUtilsWithMR.getMagicTaskAttemptsPath((JobContext)context, dest), String.valueOf(context.getTaskAttemptID()));
    }

    public static Path getTempJobAttemptPath(int appAttemptId, Path out) {
        return new Path(new Path(out, "__temp-data"), CommitUtilsWithMR.formatAppAttemptDir(appAttemptId));
    }

    public static Path getTempTaskAttemptPath(TaskAttemptContext context, Path out) {
        return new Path(CommitUtilsWithMR.getTempJobAttemptPath(CommitUtilsWithMR.getAppAttemptId((JobContext)context), out), String.valueOf(context.getTaskAttemptID()));
    }

    public static String jobIdString(JobContext context) {
        JobID jobID = context.getJobID();
        return jobID != null ? jobID.toString() : "(no job ID)";
    }

    public static String jobName(JobContext context) {
        String name = context.getJobName();
        return name != null && !name.isEmpty() ? name : "(anonymous)";
    }

    public static String getConfigurationOption(JobContext context, Configuration fsConf, String key, String defVal) {
        return context.getConfiguration().getTrimmed(key, fsConf.getTrimmed(key, defVal));
    }
}

