/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.s3a.commit;

import java.io.IOException;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.conf.Configuration;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.Path;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.s3a.S3AFileSystem;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.s3a.commit.AbstractS3ACommitterFactory;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.s3a.commit.PathCommitException;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.s3a.commit.magic.MagicS3GuardCommitterFactory;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.s3a.commit.staging.DirectoryStagingCommitterFactory;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.s3a.commit.staging.PartitionedStagingCommitterFactory;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.s3a.commit.staging.StagingCommitterFactory;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.mapreduce.lib.output.PathOutputCommitter;

public class S3ACommitterFactory
extends AbstractS3ACommitterFactory {
    public static final String CLASSNAME = "org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.s3a.commit.S3ACommitterFactory";

    @Override
    public PathOutputCommitter createTaskCommitter(S3AFileSystem fileSystem, Path outputPath, TaskAttemptContext context) throws IOException {
        AbstractS3ACommitterFactory factory = this.chooseCommitterFactory(fileSystem, outputPath, context.getConfiguration());
        return factory != null ? factory.createTaskCommitter(fileSystem, outputPath, context) : this.createFileOutputCommitter(outputPath, context);
    }

    private AbstractS3ACommitterFactory chooseCommitterFactory(S3AFileSystem fileSystem, Path outputPath, Configuration taskConf) throws PathCommitException {
        AbstractS3ACommitterFactory factory;
        Configuration fsConf = fileSystem.getConf();
        String name = fsConf.getTrimmed("fs.s3a.committer.name", "file");
        switch (name = taskConf.getTrimmed("fs.s3a.committer.name", name)) {
            case "file": {
                factory = null;
                break;
            }
            case "directory": {
                factory = new DirectoryStagingCommitterFactory();
                break;
            }
            case "partitioned": {
                factory = new PartitionedStagingCommitterFactory();
                break;
            }
            case "magic": {
                factory = new MagicS3GuardCommitterFactory();
                break;
            }
            case "staging": {
                factory = new StagingCommitterFactory();
                break;
            }
            default: {
                throw new PathCommitException(outputPath, "Unknown committer: \"" + name + "\"");
            }
        }
        return factory;
    }
}

