/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.sftp;

import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import java.io.IOException;
import java.io.InputStream;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.FSInputStream;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.FileSystem;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.util.StringUtils;

class SFTPInputStream
extends FSInputStream {
    public static final String E_SEEK_NOTSUPPORTED = "Seek not supported";
    public static final String E_CLIENT_NULL = "SFTP client null or not connected";
    public static final String E_NULL_INPUTSTREAM = "Null InputStream";
    public static final String E_STREAM_CLOSED = "Stream closed";
    public static final String E_CLIENT_NOTCONNECTED = "Client not connected";
    private InputStream wrappedStream;
    private ChannelSftp channel;
    private FileSystem.Statistics stats;
    private boolean closed;
    private long pos;

    SFTPInputStream(InputStream stream, ChannelSftp channel, FileSystem.Statistics stats) {
        if (stream == null) {
            throw new IllegalArgumentException(E_NULL_INPUTSTREAM);
        }
        if (channel == null || !channel.isConnected()) {
            throw new IllegalArgumentException(E_CLIENT_NULL);
        }
        this.wrappedStream = stream;
        this.channel = channel;
        this.stats = stats;
        this.pos = 0L;
        this.closed = false;
    }

    @Override
    public void seek(long position) throws IOException {
        throw new IOException(E_SEEK_NOTSUPPORTED);
    }

    @Override
    public boolean seekToNewSource(long targetPos) throws IOException {
        throw new IOException(E_SEEK_NOTSUPPORTED);
    }

    @Override
    public long getPos() throws IOException {
        return this.pos;
    }

    @Override
    public synchronized int read() throws IOException {
        if (this.closed) {
            throw new IOException(E_STREAM_CLOSED);
        }
        int byteRead = this.wrappedStream.read();
        if (byteRead >= 0) {
            ++this.pos;
        }
        if (this.stats != null & byteRead >= 0) {
            this.stats.incrementBytesRead(1L);
        }
        return byteRead;
    }

    @Override
    public synchronized int read(byte[] buf, int off, int len) throws IOException {
        if (this.closed) {
            throw new IOException(E_STREAM_CLOSED);
        }
        int result = this.wrappedStream.read(buf, off, len);
        if (result > 0) {
            this.pos += (long)result;
        }
        if (this.stats != null & result > 0) {
            this.stats.incrementBytesRead(result);
        }
        return result;
    }

    @Override
    public synchronized void close() throws IOException {
        if (this.closed) {
            return;
        }
        super.close();
        this.closed = true;
        if (!this.channel.isConnected()) {
            throw new IOException(E_CLIENT_NOTCONNECTED);
        }
        try {
            Session session = this.channel.getSession();
            this.channel.disconnect();
            session.disconnect();
        }
        catch (JSchException e) {
            throw new IOException(StringUtils.stringifyException(e));
        }
    }
}

