/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.security.alias;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.classification.InterfaceAudience;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.conf.Configuration;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.FileStatus;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.FileSystem;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.permission.FsPermission;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.security.alias.AbstractJavaKeyStoreProvider;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.security.alias.CredentialProvider;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.security.alias.CredentialProviderFactory;

@InterfaceAudience.Private
public class JavaKeyStoreProvider
extends AbstractJavaKeyStoreProvider {
    public static final String SCHEME_NAME = "jceks";
    private FileSystem fs;
    private FsPermission permissions;

    private JavaKeyStoreProvider(URI uri, Configuration conf) throws IOException {
        super(uri, conf);
    }

    @Override
    protected String getSchemeName() {
        return SCHEME_NAME;
    }

    @Override
    protected OutputStream getOutputStreamForKeystore() throws IOException {
        FSDataOutputStream out = FileSystem.create(this.fs, this.getPath(), this.permissions);
        return out;
    }

    @Override
    protected boolean keystoreExists() throws IOException {
        return this.fs.exists(this.getPath());
    }

    @Override
    protected InputStream getInputStreamForFile() throws IOException {
        return this.fs.open(this.getPath());
    }

    @Override
    protected void createPermissions(String perms) {
        this.permissions = new FsPermission(perms);
    }

    @Override
    protected void stashOriginalFilePermissions() throws IOException {
        FileStatus s = this.fs.getFileStatus(this.getPath());
        this.permissions = s.getPermission();
    }

    @Override
    protected void initFileSystem(URI uri) throws IOException {
        super.initFileSystem(uri);
        this.fs = this.getPath().getFileSystem(this.getConf());
    }

    public static class Factory
    extends CredentialProviderFactory {
        @Override
        public CredentialProvider createProvider(URI providerName, Configuration conf) throws IOException {
            if (JavaKeyStoreProvider.SCHEME_NAME.equals(providerName.getScheme())) {
                return new JavaKeyStoreProvider(providerName, conf);
            }
            return null;
        }
    }
}

