/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.s3base.shaded.com.amazonaws.services.dynamodbv2.datamodeling;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import org.apache.flink.fs.s3base.shaded.com.amazonaws.services.dynamodbv2.datamodeling.DynamoDB;
import org.apache.flink.fs.s3base.shaded.com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBMapperFieldModel;
import org.apache.flink.fs.s3base.shaded.com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBTypeConverted;
import org.apache.flink.fs.s3base.shaded.com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBTypeConverter;
import org.apache.flink.fs.s3base.shaded.com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBTyped;

@DynamoDB
@DynamoDBTypeConverted(converter=Converter.class)
@DynamoDBTyped(value=DynamoDBMapperFieldModel.DynamoDBAttributeType.S)
@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.FIELD, ElementType.METHOD, ElementType.ANNOTATION_TYPE})
public @interface DynamoDBConvertedBool {
    public Format value();

    public static final class Converter
    implements DynamoDBTypeConverter<String, Boolean> {
        private final String valueTrue;
        private final String valueFalse;

        public Converter(Class<Boolean> targetType, DynamoDBConvertedBool annotation) {
            this.valueTrue = annotation.value().name().split("_")[0];
            this.valueFalse = annotation.value().name().split("_")[1];
        }

        @Override
        public final String convert(Boolean object) {
            return Boolean.TRUE.equals(object) ? this.valueTrue : this.valueFalse;
        }

        @Override
        public final Boolean unconvert(String object) {
            return this.valueTrue.equals(object) ? Boolean.TRUE : Boolean.FALSE;
        }
    }

    public static enum Format {
        true_false,
        T_F,
        Y_N;

    }
}

