/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.s3base.shaded.com.amazonaws.services.dynamodbv2.document.internal;

import org.apache.flink.fs.s3base.shaded.com.amazonaws.services.dynamodbv2.AmazonDynamoDB;
import org.apache.flink.fs.s3base.shaded.com.amazonaws.services.dynamodbv2.document.Page;
import org.apache.flink.fs.s3base.shaded.com.amazonaws.services.dynamodbv2.document.Table;
import org.apache.flink.fs.s3base.shaded.com.amazonaws.services.dynamodbv2.document.TableCollection;
import org.apache.flink.fs.s3base.shaded.com.amazonaws.services.dynamodbv2.document.internal.InternalUtils;
import org.apache.flink.fs.s3base.shaded.com.amazonaws.services.dynamodbv2.document.internal.ListTablesPage;
import org.apache.flink.fs.s3base.shaded.com.amazonaws.services.dynamodbv2.document.spec.ListTablesSpec;
import org.apache.flink.fs.s3base.shaded.com.amazonaws.services.dynamodbv2.model.ListTablesRequest;
import org.apache.flink.fs.s3base.shaded.com.amazonaws.services.dynamodbv2.model.ListTablesResult;

class ListTablesCollection
extends TableCollection<ListTablesResult> {
    private final AmazonDynamoDB client;
    private final ListTablesSpec spec;
    private final String startKey;

    public ListTablesCollection(AmazonDynamoDB client, ListTablesSpec spec) {
        this.client = client;
        this.spec = spec;
        this.startKey = spec.getExclusiveStartTableName();
    }

    @Override
    public Page<Table, ListTablesResult> firstPage() {
        ListTablesRequest request = (ListTablesRequest)this.spec.getRequest();
        request.setExclusiveStartTableName(this.startKey);
        request.setLimit(InternalUtils.minimum(this.spec.getMaxResultSize(), this.spec.getMaxPageSize()));
        ListTablesResult result = this.client.listTables(request);
        this.setLastLowLevelResult(result);
        return new ListTablesPage(this.client, this.spec, request, 0, result);
    }

    @Override
    public Integer getMaxResultSize() {
        return this.spec.getMaxResultSize();
    }
}

