/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.s3base.shaded.com.amazonaws.services.s3.transfer;

import java.io.File;
import java.io.RandomAccessFile;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLProtocolException;
import org.apache.flink.fs.s3base.shaded.com.amazonaws.AmazonClientException;
import org.apache.flink.fs.s3base.shaded.com.amazonaws.SdkClientException;
import org.apache.flink.fs.s3base.shaded.com.amazonaws.annotation.SdkInternalApi;
import org.apache.flink.fs.s3base.shaded.com.amazonaws.services.s3.AmazonS3;
import org.apache.flink.fs.s3base.shaded.com.amazonaws.services.s3.internal.FileLocks;
import org.apache.flink.fs.s3base.shaded.com.amazonaws.services.s3.internal.ServiceUtils;
import org.apache.flink.fs.s3base.shaded.com.amazonaws.services.s3.model.GetObjectRequest;
import org.apache.flink.fs.s3base.shaded.com.amazonaws.services.s3.model.S3Object;
import org.apache.flink.fs.s3base.shaded.com.amazonaws.services.s3.transfer.DownloadTaskImpl;
import org.apache.flink.fs.s3base.shaded.com.amazonaws.services.s3.transfer.Transfer;
import org.apache.flink.fs.s3base.shaded.com.amazonaws.services.s3.transfer.exception.FileLockException;
import org.apache.flink.fs.s3base.shaded.com.amazonaws.services.s3.transfer.internal.CompleteMultipartDownload;
import org.apache.flink.fs.s3base.shaded.com.amazonaws.services.s3.transfer.internal.DownloadImpl;
import org.apache.flink.fs.s3base.shaded.com.amazonaws.services.s3.transfer.internal.DownloadMonitor;
import org.apache.flink.fs.s3base.shaded.com.amazonaws.services.s3.transfer.internal.DownloadPartCallable;
import org.apache.flink.fs.s3base.shaded.com.amazonaws.util.IOUtils;
import org.apache.flink.fs.shaded.hadoop3.org.apache.commons.logging.Log;
import org.apache.flink.fs.shaded.hadoop3.org.apache.commons.logging.LogFactory;

@SdkInternalApi
final class DownloadCallable
implements Callable<File> {
    private static final Log LOG = LogFactory.getLog(DownloadCallable.class);
    private final AmazonS3 s3;
    private final CountDownLatch latch;
    private final GetObjectRequest req;
    private final boolean resumeExistingDownload;
    private final DownloadImpl download;
    private final File dstfile;
    private final long origStartingByte;
    private final long timeout;
    private final ScheduledExecutorService timedExecutor;
    private final ExecutorService executor;
    private final List<Future<File>> futureFiles;
    private final boolean isDownloadParallel;
    private Integer lastFullyMergedPartNumber;
    private final boolean resumeOnRetry;
    private long expectedFileLength;
    private static boolean testing;

    DownloadCallable(AmazonS3 s3, CountDownLatch latch, GetObjectRequest req, boolean resumeExistingDownload, DownloadImpl download, File dstfile, long origStartingByte, long expectedFileLength, long timeout, ScheduledExecutorService timedExecutor, ExecutorService executor, Integer lastFullyDownloadedPartNumber, boolean isDownloadParallel, boolean resumeOnRetry) {
        if (s3 == null || latch == null || req == null || dstfile == null || download == null) {
            throw new IllegalArgumentException();
        }
        this.s3 = s3;
        this.latch = latch;
        this.req = req;
        this.resumeExistingDownload = resumeExistingDownload;
        this.download = download;
        this.dstfile = dstfile;
        this.origStartingByte = origStartingByte;
        this.expectedFileLength = expectedFileLength;
        this.timeout = timeout;
        this.timedExecutor = timedExecutor;
        this.executor = executor;
        this.futureFiles = new ArrayList<Future<File>>();
        this.lastFullyMergedPartNumber = lastFullyDownloadedPartNumber;
        this.isDownloadParallel = isDownloadParallel;
        this.resumeOnRetry = resumeOnRetry;
    }

    @Override
    public File call() throws Exception {
        try {
            this.latch.await();
            if (this.isTimeoutEnabled()) {
                this.timedExecutor.schedule(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            if (DownloadCallable.this.download.getState() != Transfer.TransferState.Completed) {
                                DownloadCallable.this.download.abort();
                            }
                        }
                        catch (Exception e) {
                            throw new SdkClientException("Unable to abort download after timeout", e);
                        }
                    }
                }, this.timeout, TimeUnit.MILLISECONDS);
            }
            this.download.setState(Transfer.TransferState.InProgress);
            ServiceUtils.createParentDirectoryIfNecessary(this.dstfile);
            if (this.isDownloadParallel) {
                this.downloadInParallel(ServiceUtils.getPartCount(this.req, this.s3));
            } else {
                S3Object s3Object = this.retryableDownloadS3ObjectToFile(this.dstfile, new DownloadTaskImpl(this.s3, this.download, this.req));
                this.updateDownloadStatus(s3Object);
            }
            return this.dstfile;
        }
        catch (Throwable t) {
            for (Future<File> f : this.futureFiles) {
                f.cancel(true);
            }
            if (this.download.getState() != Transfer.TransferState.Canceled) {
                this.download.setState(Transfer.TransferState.Failed);
            }
            if (t instanceof Exception) {
                throw (Exception)t;
            }
            throw (Error)t;
        }
    }

    private void updateDownloadStatus(S3Object result) {
        if (result == null) {
            this.download.setState(Transfer.TransferState.Canceled);
            this.download.setMonitor(new DownloadMonitor(this.download, null));
        } else {
            this.download.setState(Transfer.TransferState.Completed);
        }
    }

    private void downloadInParallel(int partCount) throws Exception {
        if (this.lastFullyMergedPartNumber == null) {
            this.lastFullyMergedPartNumber = 0;
        }
        for (int i = this.lastFullyMergedPartNumber + 1; i <= partCount; ++i) {
            GetObjectRequest getPartRequest = (GetObjectRequest)new GetObjectRequest(this.req.getBucketName(), this.req.getKey(), this.req.getVersionId()).withUnmodifiedSinceConstraint(this.req.getUnmodifiedSinceConstraint()).withModifiedSinceConstraint(this.req.getModifiedSinceConstraint()).withResponseHeaders(this.req.getResponseHeaders()).withSSECustomerKey(this.req.getSSECustomerKey()).withGeneralProgressListener(this.req.getGeneralProgressListener());
            getPartRequest.setMatchingETagConstraints(this.req.getMatchingETagConstraints());
            getPartRequest.setNonmatchingETagConstraints(this.req.getNonmatchingETagConstraints());
            getPartRequest.setRequesterPays(this.req.isRequesterPays());
            this.futureFiles.add(this.executor.submit(new DownloadPartCallable(this.s3, getPartRequest.withPartNumber(i), this.dstfile)));
        }
        this.truncateDestinationFileIfNecessary();
        this.lastFullyMergedPartNumber = this.lastFullyMergedPartNumber + 1;
        Future<File> future = this.executor.submit(new CompleteMultipartDownload(this.futureFiles, this.dstfile, this.download, this.lastFullyMergedPartNumber));
        ((DownloadMonitor)this.download.getMonitor()).setFuture(future);
    }

    private void truncateDestinationFileIfNecessary() {
        RandomAccessFile raf;
        block7: {
            raf = null;
            if (!FileLocks.lock(this.dstfile)) {
                throw new FileLockException("Fail to lock " + this.dstfile);
            }
            try {
                raf = new RandomAccessFile(this.dstfile, "rw");
                if (this.lastFullyMergedPartNumber == 0) {
                    raf.setLength(0L);
                    break block7;
                }
                long lastByte = ServiceUtils.getLastByteInPart(this.s3, this.req, this.lastFullyMergedPartNumber);
                if (this.dstfile.length() < lastByte) {
                    throw new SdkClientException("File " + this.dstfile.getAbsolutePath() + " has been modified since last pause.");
                }
                raf.setLength(lastByte + 1L);
                this.download.getProgress().updateProgress(lastByte + 1L);
            }
            catch (Exception e) {
                try {
                    throw new SdkClientException("Unable to append part file to dstfile " + e.getMessage(), e);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(raf, LOG);
                    FileLocks.unlock(this.dstfile);
                    throw throwable;
                }
            }
        }
        IOUtils.closeQuietly(raf, LOG);
        FileLocks.unlock(this.dstfile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void adjustRequest(GetObjectRequest req) {
        long[] range = req.getRange();
        long lastByte = range[1];
        long totalBytesToDownload = lastByte - this.origStartingByte + 1L;
        if (this.dstfile.exists()) {
            if (!FileLocks.lock(this.dstfile)) {
                throw new FileLockException("Fail to lock " + this.dstfile + " for range adjustment");
            }
            try {
                this.expectedFileLength = this.dstfile.length();
                long startingByte = this.origStartingByte + this.expectedFileLength;
                LOG.info("Adjusting request range from " + Arrays.toString(range) + " to " + Arrays.toString(new long[]{startingByte, lastByte}) + " for file " + this.dstfile);
                req.setRange(startingByte, lastByte);
                totalBytesToDownload = lastByte - startingByte + 1L;
            }
            finally {
                FileLocks.unlock(this.dstfile);
            }
        }
        if (totalBytesToDownload < 0L) {
            throw new IllegalArgumentException("Unable to determine the range for download operation. lastByte=" + lastByte + ", origStartingByte=" + this.origStartingByte + ", expectedFileLength=" + this.expectedFileLength + ", totalBytesToDownload=" + totalBytesToDownload);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private S3Object retryableDownloadS3ObjectToFile(File file, ServiceUtils.RetryableS3DownloadTask retryableS3DownloadTask) {
        boolean hasRetried = false;
        while (true) {
            S3Object s3Object;
            boolean appendData;
            boolean bl = appendData = this.resumeExistingDownload || this.resumeOnRetry && hasRetried;
            if (appendData && hasRetried) {
                this.adjustRequest(this.req);
            }
            if ((s3Object = retryableS3DownloadTask.getS3ObjectStream()) == null) {
                return null;
            }
            try {
                if (testing && this.resumeExistingDownload && !hasRetried) {
                    throw new SdkClientException("testing");
                }
                ServiceUtils.downloadToFile(s3Object, file, retryableS3DownloadTask.needIntegrityCheck(), appendData, this.expectedFileLength);
                S3Object s3Object2 = s3Object;
                return s3Object2;
            }
            catch (AmazonClientException ace) {
                if (!ace.isRetryable()) {
                    throw ace;
                }
                Throwable cause = ace.getCause();
                if (cause instanceof SocketException && !cause.getMessage().equals("Connection reset") || cause instanceof SSLProtocolException) {
                    throw ace;
                }
                if (hasRetried) {
                    throw ace;
                }
                LOG.info("Retry the download of object " + s3Object.getKey() + " (bucket " + s3Object.getBucketName() + ")", ace);
                hasRetried = true;
                continue;
            }
            finally {
                s3Object.getObjectContent().abort();
                continue;
            }
            break;
        }
    }

    private boolean isTimeoutEnabled() {
        return this.timeout > 0L;
    }

    static void setTesting(boolean b) {
        testing = b;
    }
}

