/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.s3native;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.util.Objects;
import org.apache.flink.fs.shaded.hadoop3.org.apache.commons.lang.StringUtils;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.conf.Configuration;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.FileSystem;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class S3xLoginHelper {
    private static final Logger LOG = LoggerFactory.getLogger(S3xLoginHelper.class);
    public static final String LOGIN_WARNING = "The Filesystem URI contains login details. This is insecure and may be unsupported in future.";
    public static final String PLUS_WARNING = "Secret key contains a special character that should be URL encoded! Attempting to resolve...";
    public static final String PLUS_UNENCODED = "+";
    public static final String PLUS_ENCODED = "%2B";

    private S3xLoginHelper() {
    }

    public static URI buildFSURI(URI uri) {
        Objects.requireNonNull(uri, "null uri");
        Objects.requireNonNull(uri.getScheme(), "null uri.getScheme()");
        if (uri.getHost() == null && uri.getAuthority() != null) {
            Objects.requireNonNull(uri.getHost(), "null uri host. This can be caused by unencoded / in the password string");
        }
        Objects.requireNonNull(uri.getHost(), "null uri host.");
        return URI.create(uri.getScheme() + "://" + uri.getHost());
    }

    public static String toString(URI pathUri) {
        return pathUri != null ? String.format("%s://%s/%s", pathUri.getScheme(), pathUri.getHost(), pathUri.getPath()) : "(null URI)";
    }

    public static Login extractLoginDetailsWithWarnings(URI name) {
        Login login = S3xLoginHelper.extractLoginDetails(name);
        if (login.hasLogin()) {
            LOG.warn(LOGIN_WARNING);
        }
        return login;
    }

    public static Login extractLoginDetails(URI name) {
        if (name == null) {
            return Login.EMPTY;
        }
        try {
            String authority = name.getAuthority();
            if (authority == null) {
                return Login.EMPTY;
            }
            int loginIndex = authority.indexOf(64);
            if (loginIndex < 0) {
                return Login.EMPTY;
            }
            String login = authority.substring(0, loginIndex);
            int loginSplit = login.indexOf(58);
            if (loginSplit > 0) {
                String user = login.substring(0, loginSplit);
                String encodedPassword = login.substring(loginSplit + 1);
                if (encodedPassword.contains(PLUS_UNENCODED)) {
                    LOG.warn(PLUS_WARNING);
                    encodedPassword = encodedPassword.replaceAll("\\+", PLUS_ENCODED);
                }
                String password = URLDecoder.decode(encodedPassword, "UTF-8");
                return new Login(user, password);
            }
            if (loginSplit == 0) {
                return Login.EMPTY;
            }
            return new Login(login, "");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static URI canonicalizeUri(URI uri, int defaultPort) {
        if (uri.getPort() == -1 && defaultPort > 0) {
            try {
                uri = new URI(uri.getScheme(), null, uri.getHost(), defaultPort, uri.getPath(), uri.getQuery(), uri.getFragment());
            }
            catch (URISyntaxException e) {
                throw new AssertionError((Object)("Valid URI became unparseable: " + uri));
            }
        }
        return uri;
    }

    public static void checkPath(Configuration conf, URI fsUri, Path path, int defaultPort) {
        URI pathUri = path.toUri();
        String thatScheme = pathUri.getScheme();
        if (thatScheme == null) {
            return;
        }
        URI thisUri = S3xLoginHelper.canonicalizeUri(fsUri, defaultPort);
        String thisScheme = thisUri.getScheme();
        if (StringUtils.equalsIgnoreCase(thisScheme, thatScheme)) {
            String thisHost = thisUri.getHost();
            String thatHost = pathUri.getHost();
            if (thatHost == null && thisHost != null) {
                URI defaultUri = FileSystem.getDefaultUri(conf);
                pathUri = StringUtils.equalsIgnoreCase(thisScheme, defaultUri.getScheme()) ? defaultUri : null;
            }
            if (pathUri != null && (thisHost == (thatHost = (pathUri = S3xLoginHelper.canonicalizeUri(pathUri, defaultPort)).getHost()) || thisHost != null && StringUtils.equalsIgnoreCase(thisHost, thatHost))) {
                return;
            }
        }
        throw new IllegalArgumentException("Wrong FS " + S3xLoginHelper.toString(pathUri) + " -expected " + fsUri);
    }

    public static class Login {
        private final String user;
        private final String password;
        public static final Login EMPTY = new Login();

        public Login() {
            this("", "");
        }

        public Login(String user, String password) {
            this.user = user;
            this.password = password;
        }

        public boolean hasLogin() {
            return StringUtils.isNotEmpty(this.user);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Login that = (Login)o;
            return Objects.equals(this.user, that.user) && Objects.equals(this.password, that.password);
        }

        public int hashCode() {
            return Objects.hash(this.user, this.password);
        }

        public String getUser() {
            return this.user;
        }

        public String getPassword() {
            return this.password;
        }
    }
}

