/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.service;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.flink.fs.s3base.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.classification.InterfaceAudience;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.classification.InterfaceStability;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.conf.Configuration;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.service.LifecycleEvent;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.service.Service;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.service.ServiceOperations;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.service.ServiceStateChangeListener;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.service.ServiceStateException;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.service.ServiceStateModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public abstract class AbstractService
implements Service {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractService.class);
    private final String name;
    private final ServiceStateModel stateModel;
    private long startTime;
    private volatile Configuration config;
    private final ServiceOperations.ServiceListeners listeners = new ServiceOperations.ServiceListeners();
    private static ServiceOperations.ServiceListeners globalListeners = new ServiceOperations.ServiceListeners();
    private Exception failureCause;
    private Service.STATE failureState = null;
    private final AtomicBoolean terminationNotification = new AtomicBoolean(false);
    private final List<LifecycleEvent> lifecycleHistory = new ArrayList<LifecycleEvent>(5);
    private final Map<String, String> blockerMap = new HashMap<String, String>();
    private final Object stateChangeLock = new Object();

    public AbstractService(String name) {
        this.name = name;
        this.stateModel = new ServiceStateModel(name);
    }

    @Override
    public final Service.STATE getServiceState() {
        return this.stateModel.getState();
    }

    @Override
    public final synchronized Throwable getFailureCause() {
        return this.failureCause;
    }

    @Override
    public synchronized Service.STATE getFailureState() {
        return this.failureState;
    }

    protected void setConfig(Configuration conf) {
        this.config = conf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void init(Configuration conf) {
        if (conf == null) {
            throw new ServiceStateException("Cannot initialize service " + this.getName() + ": null configuration");
        }
        if (this.isInState(Service.STATE.INITED)) {
            return;
        }
        Object object = this.stateChangeLock;
        synchronized (object) {
            if (this.enterState(Service.STATE.INITED) != Service.STATE.INITED) {
                this.setConfig(conf);
                try {
                    this.serviceInit(this.config);
                    if (this.isInState(Service.STATE.INITED)) {
                        this.notifyListeners();
                    }
                }
                catch (Exception e) {
                    this.noteFailure(e);
                    ServiceOperations.stopQuietly(LOG, (Service)this);
                    throw ServiceStateException.convert(e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() {
        if (this.isInState(Service.STATE.STARTED)) {
            return;
        }
        Object object = this.stateChangeLock;
        synchronized (object) {
            if (this.stateModel.enterState(Service.STATE.STARTED) != Service.STATE.STARTED) {
                try {
                    this.startTime = System.currentTimeMillis();
                    this.serviceStart();
                    if (this.isInState(Service.STATE.STARTED)) {
                        LOG.debug("Service {} is started", (Object)this.getName());
                        this.notifyListeners();
                    }
                }
                catch (Exception e) {
                    this.noteFailure(e);
                    ServiceOperations.stopQuietly(LOG, (Service)this);
                    throw ServiceStateException.convert(e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        if (this.isInState(Service.STATE.STOPPED)) {
            return;
        }
        Object object = this.stateChangeLock;
        synchronized (object) {
            if (this.enterState(Service.STATE.STOPPED) != Service.STATE.STOPPED) {
                try {
                    this.serviceStop();
                }
                catch (Exception e) {
                    this.noteFailure(e);
                    throw ServiceStateException.convert(e);
                }
                finally {
                    this.terminationNotification.set(true);
                    AtomicBoolean atomicBoolean = this.terminationNotification;
                    synchronized (atomicBoolean) {
                        this.terminationNotification.notifyAll();
                    }
                    this.notifyListeners();
                }
            }
            LOG.debug("Ignoring re-entrant call to stop()");
        }
    }

    @Override
    public final void close() throws IOException {
        this.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void noteFailure(Exception exception) {
        LOG.debug("noteFailure {}" + exception);
        if (exception == null) {
            return;
        }
        AbstractService abstractService = this;
        synchronized (abstractService) {
            if (this.failureCause == null) {
                this.failureCause = exception;
                this.failureState = this.getServiceState();
                LOG.info("Service {} failed in state {}", new Object[]{this.getName(), this.failureState, exception});
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean waitForServiceToStop(long timeout) {
        boolean completed = this.terminationNotification.get();
        while (!completed) {
            try {
                AtomicBoolean atomicBoolean = this.terminationNotification;
                synchronized (atomicBoolean) {
                    this.terminationNotification.wait(timeout);
                }
                completed = true;
            }
            catch (InterruptedException e) {
                completed = this.terminationNotification.get();
            }
        }
        return this.terminationNotification.get();
    }

    protected void serviceInit(Configuration conf) throws Exception {
        if (conf != this.config) {
            LOG.debug("Config has been overridden during init");
            this.setConfig(conf);
        }
    }

    protected void serviceStart() throws Exception {
    }

    protected void serviceStop() throws Exception {
    }

    @Override
    public void registerServiceListener(ServiceStateChangeListener l) {
        this.listeners.add(l);
    }

    @Override
    public void unregisterServiceListener(ServiceStateChangeListener l) {
        this.listeners.remove(l);
    }

    public static void registerGlobalListener(ServiceStateChangeListener l) {
        globalListeners.add(l);
    }

    public static boolean unregisterGlobalListener(ServiceStateChangeListener l) {
        return globalListeners.remove(l);
    }

    @VisibleForTesting
    static void resetGlobalListeners() {
        globalListeners.reset();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Configuration getConfig() {
        return this.config;
    }

    @Override
    public long getStartTime() {
        return this.startTime;
    }

    private void notifyListeners() {
        try {
            this.listeners.notifyListeners(this);
            globalListeners.notifyListeners(this);
        }
        catch (Throwable e) {
            LOG.warn("Exception while notifying listeners of {}", (Object)this, (Object)e);
        }
    }

    private void recordLifecycleEvent() {
        LifecycleEvent event = new LifecycleEvent();
        event.time = System.currentTimeMillis();
        event.state = this.getServiceState();
        this.lifecycleHistory.add(event);
    }

    @Override
    public synchronized List<LifecycleEvent> getLifecycleHistory() {
        return new ArrayList<LifecycleEvent>(this.lifecycleHistory);
    }

    private Service.STATE enterState(Service.STATE newState) {
        assert (this.stateModel != null) : "null state in " + this.name + " " + this.getClass();
        Service.STATE oldState = this.stateModel.enterState(newState);
        if (oldState != newState) {
            LOG.debug("Service: {} entered state {}", (Object)this.getName(), (Object)this.getServiceState());
            this.recordLifecycleEvent();
        }
        return oldState;
    }

    @Override
    public final boolean isInState(Service.STATE expected) {
        return this.stateModel.isInState(expected);
    }

    public String toString() {
        return "Service " + this.name + " in state " + this.stateModel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void putBlocker(String name, String details) {
        Map<String, String> map = this.blockerMap;
        synchronized (map) {
            this.blockerMap.put(name, details);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeBlocker(String name) {
        Map<String, String> map = this.blockerMap;
        synchronized (map) {
            this.blockerMap.remove(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, String> getBlockers() {
        Map<String, String> map = this.blockerMap;
        synchronized (map) {
            HashMap<String, String> map2 = new HashMap<String, String>(this.blockerMap);
            return map2;
        }
    }
}

