/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.EnumSet;
import org.apache.hadoop.fs.AbstractFileSystem;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.CreateFlag;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileChecksum;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FsServerDefaults;
import org.apache.hadoop.fs.FsStatus;
import org.apache.hadoop.fs.InvalidPathException;
import org.apache.hadoop.fs.Options;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.UnresolvedLinkException;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.util.Progressable;
import org.junit.Test;

public class TestAfsCheckPath {
    private static int DEFAULT_PORT = 1234;
    private static int OTHER_PORT = 4321;

    @Test
    public void testCheckPathWithNoPorts() throws URISyntaxException {
        URI uri = new URI("dummy://dummy-host");
        DummyFileSystem afs = new DummyFileSystem(uri);
        afs.checkPath(new Path("dummy://dummy-host"));
    }

    @Test
    public void testCheckPathWithDefaultPort() throws URISyntaxException {
        URI uri = new URI("dummy://dummy-host:" + DEFAULT_PORT);
        DummyFileSystem afs = new DummyFileSystem(uri);
        afs.checkPath(new Path("dummy://dummy-host:" + DEFAULT_PORT));
    }

    @Test
    public void testCheckPathWithTheSameNonDefaultPort() throws URISyntaxException {
        URI uri = new URI("dummy://dummy-host:" + OTHER_PORT);
        DummyFileSystem afs = new DummyFileSystem(uri);
        afs.checkPath(new Path("dummy://dummy-host:" + OTHER_PORT));
    }

    @Test(expected=InvalidPathException.class)
    public void testCheckPathWithDifferentPorts() throws URISyntaxException {
        URI uri = new URI("dummy://dummy-host:" + DEFAULT_PORT);
        DummyFileSystem afs = new DummyFileSystem(uri);
        afs.checkPath(new Path("dummy://dummy-host:" + OTHER_PORT));
    }

    private static class DummyFileSystem
    extends AbstractFileSystem {
        public DummyFileSystem(URI uri) throws URISyntaxException {
            super(uri, "dummy", true, DEFAULT_PORT);
        }

        @Override
        public int getUriDefaultPort() {
            return DEFAULT_PORT;
        }

        @Override
        public FSDataOutputStream createInternal(Path f, EnumSet<CreateFlag> flag, FsPermission absolutePermission, int bufferSize, short replication, long blockSize, Progressable progress, Options.ChecksumOpt checksumOpt, boolean createParent) throws IOException {
            return null;
        }

        @Override
        public boolean delete(Path f, boolean recursive) throws AccessControlException, FileNotFoundException, UnresolvedLinkException, IOException {
            return false;
        }

        @Override
        public BlockLocation[] getFileBlockLocations(Path f, long start, long len) throws IOException {
            return null;
        }

        @Override
        public FileChecksum getFileChecksum(Path f) throws IOException {
            return null;
        }

        @Override
        public FileStatus getFileStatus(Path f) throws IOException {
            return null;
        }

        @Override
        public FsStatus getFsStatus() throws IOException {
            return null;
        }

        @Override
        public FsServerDefaults getServerDefaults() throws IOException {
            return null;
        }

        @Override
        public FileStatus[] listStatus(Path f) throws IOException {
            return null;
        }

        @Override
        public void mkdir(Path dir, FsPermission permission, boolean createParent) throws IOException {
        }

        @Override
        public FSDataInputStream open(Path f, int bufferSize) throws IOException {
            return null;
        }

        @Override
        public void renameInternal(Path src, Path dst) throws IOException {
        }

        @Override
        public void setOwner(Path f, String username, String groupname) throws IOException {
        }

        @Override
        public void setPermission(Path f, FsPermission permission) throws IOException {
        }

        @Override
        public boolean setReplication(Path f, short replication) throws IOException {
            return false;
        }

        @Override
        public void setTimes(Path f, long mtime, long atime) throws IOException {
        }

        @Override
        public void setVerifyChecksum(boolean verifyChecksum) throws IOException {
        }
    }
}

